/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.util.LinkedHashMap;
import org.eclipse.fordiac.ide.typemanagement.refactoring.IFordiacPreviewChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ChangeConfigurationViewer
implements IChangePreviewViewer {
    private Composite control;
    private IFordiacPreviewChange change;
    private Table table;
    private final LinkedHashMap<TableItem, IFordiacPreviewChange.ChangeState> choices = new LinkedHashMap();

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new FillLayout());
        this.table = new Table(this.control, 2080);
        this.table.setSize(100, 100);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TableItem item = (TableItem)e.item;
                    IFordiacPreviewChange.ChangeState cs = ChangeConfigurationViewer.this.choices.get(item);
                    if (ChangeConfigurationViewer.this.change.getState().contains((Object)cs)) {
                        item.setChecked(true);
                        return;
                    }
                    ChangeConfigurationViewer.this.change.addState(cs);
                    ChangeConfigurationViewer.this.change.getState().removeIf(state -> !state.equals((Object)cs));
                    ChangeConfigurationViewer.this.choices.keySet().stream().filter(anyItem -> !anyItem.equals(item)).forEach(otherItem -> otherItem.setChecked(false));
                }
            }
        });
    }

    public Control getControl() {
        return this.control;
    }

    public void setInput(ChangePreviewViewerInput input) {
        Change change;
        if (this.choices.isEmpty()) {
            this.initializeChoices(input);
        }
        if ((change = input.getChange()) instanceof IFordiacPreviewChange) {
            IFordiacPreviewChange deleteChange = (IFordiacPreviewChange)change;
            this.setSelection(deleteChange);
        }
    }

    private void setSelection(IFordiacPreviewChange delChange) {
        this.choices.keySet().stream().forEach(i -> i.setChecked(false));
        this.change = delChange;
        this.choices.entrySet().stream().filter(entry -> delChange.getState().contains(entry.getValue())).forEach(entry -> ((TableItem)entry.getKey()).setChecked(true));
        if (this.choices.keySet().stream().filter(TableItem::getChecked).toList().isEmpty()) {
            ((TableItem)this.choices.firstEntry().getKey()).setChecked(true);
            IFordiacPreviewChange.ChangeState cs = (IFordiacPreviewChange.ChangeState)((Object)this.choices.firstEntry().getValue());
            this.change.addState(cs);
            this.change.getState().removeIf(state -> !state.equals((Object)cs));
        }
    }

    private void initializeChoices(ChangePreviewViewerInput input) {
        Change change = input.getChange();
        if (change instanceof IFordiacPreviewChange) {
            IFordiacPreviewChange previewChange = (IFordiacPreviewChange)change;
            previewChange.getAllowedChoices().forEach(s -> {
                TableItem ti = new TableItem(this.table, 0);
                ti.setText(s.toString());
                this.choices.put(ti, (IFordiacPreviewChange.ChangeState)((Object)s));
            });
        }
    }
}

