/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceProvider;
import org.eclipse.acceleo.query.runtime.ServiceUtils;

public abstract class AbstractServiceProvider
implements IServiceProvider {
    private static final String WRONG_IMPLEMENTATION = "Wrong implementation of " + AbstractServiceProvider.class.getName();
    private List<IService<?>> services;

    @Override
    public List<IService<?>> getServices(IReadOnlyQueryEnvironment queryEnvironment, boolean forWorkspace) {
        try {
            if (this.services == null) {
                Method[] methods;
                Method getServicesMethod = this.getClass().getMethod("getServices", IReadOnlyQueryEnvironment.class, Boolean.TYPE);
                this.services = new ArrayList();
                Method[] methodArray = methods = this.getClass().getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IService<Method> service;
                    Method method = methodArray[n2];
                    if (ServiceUtils.isServiceMethod(this, method) && !getServicesMethod.equals(method) && (service = this.getService(method, forWorkspace)) != null) {
                        this.services.add(service);
                    }
                    ++n2;
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(WRONG_IMPLEMENTATION, e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(WRONG_IMPLEMENTATION, e);
        }
        return this.services;
    }

    protected abstract IService<Method> getService(Method var1, boolean var2);
}

