/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.List;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.Positions;
import org.eclipse.emf.common.util.Diagnostic;

public class AstResult {
    private final Expression ast;
    private final List<Error> errors;
    private final Positions<ASTNode> positions;
    private Diagnostic diagnostic;

    public AstResult(Expression ast, Positions<ASTNode> positions, List<Error> errors, Diagnostic diagnostic) {
        this.ast = ast;
        this.positions = positions;
        this.errors = errors;
        this.diagnostic = diagnostic;
    }

    public Expression getAst() {
        return this.ast;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public int getStartPosition(ASTNode astNode) {
        Integer position = this.positions.getStartPositions(astNode);
        int res = position != null ? position : -1;
        return res;
    }

    public int getStartLine(ASTNode astNode) {
        Integer line = this.positions.getStartLines(astNode);
        int res = line != null ? line : -1;
        return res;
    }

    public int getStartColumn(ASTNode astNode) {
        Integer column = this.positions.getStartColumns(astNode);
        int res = column != null ? column : -1;
        return res;
    }

    public int getEndPosition(ASTNode astNode) {
        Integer position = this.positions.getEndPositions(astNode);
        int res = position != null ? position : -1;
        return res;
    }

    public int getEndLine(ASTNode astNode) {
        Integer line = this.positions.getEndLines(astNode);
        int res = line != null ? line : -1;
        return res;
    }

    public int getEndColumn(ASTNode astNode) {
        Integer column = this.positions.getEndColumns(astNode);
        int res = column != null ? column : -1;
        return res;
    }

    public int getIdentifierStartPosition(ASTNode astNode) {
        Integer position = this.positions.getIdentifierStartPositions(astNode);
        int res = position != null ? position : -1;
        return res;
    }

    public int getIdentifierStartLine(ASTNode astNode) {
        Integer line = this.positions.getIdentifierStartLines(astNode);
        int res = line != null ? line : -1;
        return res;
    }

    public int getIdentifierStartColumn(ASTNode astNode) {
        Integer column = this.positions.getIdentifierStartColumns(astNode);
        int res = column != null ? column : -1;
        return res;
    }

    public int getIdentifierEndPosition(ASTNode astNode) {
        Integer position = this.positions.getIdentifierEndPositions(astNode);
        int res = position != null ? position : -1;
        return res;
    }

    public int getIdentifierEndLine(ASTNode astNode) {
        Integer line = this.positions.getIdentifierEndLines(astNode);
        int res = line != null ? line : -1;
        return res;
    }

    public int getIdentifierEndColumn(ASTNode astNode) {
        Integer column = this.positions.getIdentifierEndColumns(astNode);
        int res = column != null ? column : -1;
        return res;
    }

    public void addAllPositonsTo(Positions<ASTNode> pos, int offsetPosition, int offsetLine, int offsetColumn) {
        pos.addAll(this.positions, offsetPosition, offsetLine, offsetColumn);
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public AstResult subResult(Expression subAst) {
        return new AstResult(subAst, this.positions, this.errors, this.diagnostic);
    }

    public ASTNode getAstNode(int position) {
        return this.positions.getNodeAt(this.ast, position);
    }

    public ASTNode getAstNode(int line, int column) {
        return this.positions.getNodeAt(this.ast, line, column);
    }

    public Positions<ASTNode> getPositions() {
        return this.positions;
    }
}

