/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.ide.ui.command;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.acceleo.aql.migration.ide.ui.AcceleoMigrationPlugin;
import org.eclipse.acceleo.aql.migration.standalone.StandaloneMigrator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MigrateToAcceleo4Handler
extends AbstractHandler {
    private static final String MIGRATION_FAILED = "Migration failed";
    private static final String ACCELEO3_NATURE = "org.eclipse.acceleo.ide.ui.acceleoNature";
    private static final String ACCELEO3_BUILDER = "org.eclipse.acceleo.ide.ui.acceleoBuilder";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block21: {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                DirectoryDialog dialog = new DirectoryDialog(shell);
                dialog.setMessage("Select target directory");
                dialog.setText("Select the target directory for migrated projects.");
                String targetString = dialog.open();
                try {
                    if (targetString == null) break block21;
                    Path targetPath = new File(targetString).toPath();
                    File logFile = targetPath.resolve("Acceleo4migation.log").toFile();
                    if (!logFile.exists()) {
                        File parentFolder = logFile.getParentFile();
                        if (!parentFolder.exists()) {
                            parentFolder.mkdirs();
                        }
                        logFile.createNewFile();
                    }
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (FileWriter logWriter = new FileWriter(logFile);){
                        for (Object selected : (IStructuredSelection)selection) {
                            Object javaProject = selected instanceof IJavaProject ? (IJavaProject)selected : (selected instanceof IProject ? JavaCore.create((IProject)((IProject)selected)) : null);
                            IProject project = javaProject.getProject();
                            Path projectPath = project.getLocation().toFile().toPath();
                            ArrayList<Path> ignoreFolders = new ArrayList<Path>();
                            try {
                                Path binaryPath = new File(projectPath.getParent().toString() + javaProject.getOutputLocation().toString()).toPath();
                                ignoreFolders.add(binaryPath);
                                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                                int n = iClasspathEntryArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IClasspathEntry entry = iClasspathEntryArray[n2];
                                    if (entry.getEntryKind() == 3) {
                                        Path sourcePath = new File(projectPath.getParent().toString() + entry.getPath().toString()).toPath();
                                        ignoreFolders.add(sourcePath);
                                        Path relativeSourcePath = projectPath.getParent().relativize(sourcePath);
                                        Path targetSourcePath = targetPath.resolve(relativeSourcePath);
                                        StandaloneMigrator migrator = new StandaloneMigrator((Writer)logWriter, sourcePath, binaryPath, targetSourcePath);
                                        migrator.migrateAll();
                                    }
                                    ++n2;
                                }
                            }
                            catch (IOException | JavaModelException e) {
                                AcceleoMigrationPlugin.getPlugin().log(new Status(4, "org.eclipse.acceleo.aql.migration.ide.ui", MIGRATION_FAILED, e));
                            }
                            Path targetProjectPath = targetPath.resolve(projectPath.getParent().relativize(projectPath));
                            try {
                                this.copyPath(projectPath, targetProjectPath, ignoreFolders);
                            }
                            catch (IOException e) {
                                AcceleoMigrationPlugin.getPlugin().log(new Status(4, "org.eclipse.acceleo.aql.migration.ide.ui", MIGRATION_FAILED, (Throwable)e));
                                e.printStackTrace();
                            }
                            this.removeAcceleo3BuilderAndNature(targetProjectPath);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    AcceleoMigrationPlugin.getPlugin().log(new Status(4, "org.eclipse.acceleo.aql.migration.ide.ui", MIGRATION_FAILED, (Throwable)e));
                }
            }
        }
        return null;
    }

    private void removeAcceleo3BuilderAndNature(Path targetProjectPath) {
        Path projectDescriptionPath = targetProjectPath.resolve(".project");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xml = db.parse(projectDescriptionPath.toFile());
            NodeList childNodes = xml.getChildNodes().item(0).getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node = childNodes.item(i);
                if ("buildSpec".equals(node.getNodeName())) {
                    this.removeAcceleo3Builder(node);
                }
                if ("natures".equals(node.getNodeName())) {
                    this.removeAcceleo3Nature(node);
                }
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(xml);
            StreamResult streamResult = new StreamResult(projectDescriptionPath.toFile());
            transformer.transform(source, streamResult);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            AcceleoMigrationPlugin.getPlugin().log(new Status(4, "org.eclipse.acceleo.aql.migration.ide.ui", MIGRATION_FAILED, (Throwable)e));
        }
    }

    private void removeAcceleo3Nature(Node node) {
        NodeList naturesChildren = node.getChildNodes();
        boolean found = false;
        Node natureNode = null;
        int j = 0;
        while (j < naturesChildren.getLength()) {
            natureNode = naturesChildren.item(j);
            if ("nature".equals(natureNode.getNodeName()) && ACCELEO3_NATURE.equals(natureNode.getFirstChild().getNodeValue())) {
                found = true;
                break;
            }
            ++j;
        }
        if (found) {
            node.removeChild(natureNode);
        }
    }

    private void removeAcceleo3Builder(Node node) {
        NodeList buildChildren = node.getChildNodes();
        boolean found = false;
        int j = 0;
        while (j < buildChildren.getLength()) {
            Node buildNode = buildChildren.item(j);
            NodeList buildNodeChildren = buildNode.getChildNodes();
            int k = 0;
            while (k < buildNodeChildren.getLength()) {
                Node buildNodeChildNode = buildNodeChildren.item(k);
                if ("name".equals(buildNodeChildNode.getNodeName()) && ACCELEO3_BUILDER.equals(buildNodeChildNode.getFirstChild().getNodeValue())) {
                    found = true;
                    break;
                }
                ++k;
            }
            if (found) {
                node.removeChild(buildNode);
                break;
            }
            ++j;
        }
    }

    private void copyPath(Path source, Path target, List<Path> ignoreFolders) throws IOException {
        File sourceFile = source.toFile();
        File[] fileArray = sourceFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            Path childPath = child.toPath().toAbsolutePath();
            Path childTarget = target.toAbsolutePath().resolve(source.toAbsolutePath().relativize(childPath));
            if (child.isDirectory() && !ignoreFolders.contains(childPath)) {
                File targetFolder = childTarget.toFile();
                if (!targetFolder.exists()) {
                    targetFolder.mkdirs();
                }
                this.copyPath(childPath, childTarget, ignoreFolders);
            } else if (!childTarget.toFile().exists()) {
                Files.copy(childPath, childTarget, new CopyOption[0]);
            }
            ++n2;
        }
    }
}

