/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.workspace.command;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.VisibilityKind;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerPositionUtils;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.workspace.command.AbstractDocumentRangeCommand;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;

public class ExtractTemplateCommand
extends AbstractDocumentRangeCommand {
    public WorkspaceEdit exec(AcceleoTextDocument document, Range range) {
        WorkspaceEdit res;
        if (range.getStart().getCharacter() == 0 && range.getEnd().getCharacter() == 0) {
            int startIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(range.getStart(), document.getContents());
            int endIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(range.getEnd(), document.getContents());
            String text = document.getContents().substring(startIndex, endIndex);
            if (!text.isEmpty() && this.isSameBlock(document, startIndex, endIndex)) {
                LinkedHashMap changes = new LinkedHashMap();
                Template template = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTemplate();
                template.setVisibility(VisibilityKind.PUBLIC);
                template.setName("myTemplate");
                String lineDelimiter = System.lineSeparator();
                String blockIndentation = this.getBlockIndentation(text);
                template.setBody(this.createBlock(text, blockIndentation, "  ", lineDelimiter, true));
                List<Variable> parameters = this.getVariablesDeclaredOutSide(document, startIndex, endIndex);
                template.getParameters().addAll(parameters);
                String addTemplateText = lineDelimiter + lineDelimiter + new AcceleoAstSerializer(lineDelimiter).serialize((AcceleoASTNode)template);
                ModuleElement containingElement = AcceleoUtil.getContainingModuleElement((ASTNode)document.getAcceleoAstResult().getAstNode(startIndex));
                Position addTemplatePosition = AcceleoLanguageServerPositionUtils.getEndPositionOf((AcceleoASTNode)containingElement, document.getAcceleoAstResult());
                Range addTemplateRange = new Range(addTemplatePosition, addTemplatePosition);
                TextEdit addTemplateEdit = new TextEdit(addTemplateRange, addTemplateText + lineDelimiter);
                String sourceURI = document.getQueryEnvironment().getLookupEngine().getResolver().getSourceURI(document.getModuleQualifiedName()).toString();
                Range replacementCallRange = AcceleoLanguageServerPositionUtils.getCorrespondingRange(startIndex, endIndex, document.getContents());
                ExpressionStatement templateCall = this.createCall(template.getName(), parameters);
                String replacementCallText = blockIndentation + new AcceleoAstSerializer(lineDelimiter).serialize((AcceleoASTNode)templateCall);
                TextEdit replacementCallEdit = new TextEdit(replacementCallRange, replacementCallText + lineDelimiter);
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                edits.add(addTemplateEdit);
                edits.add(replacementCallEdit);
                changes.put(sourceURI, edits);
                res = new WorkspaceEdit(changes);
            } else {
                res = null;
            }
        } else {
            res = null;
        }
        return res;
    }
}

