/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.gradleprop.provider;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class GradlePropertiesConnectionProvider
extends ProcessStreamConnectionProvider
implements StreamConnectionProvider {
    public GradlePropertiesConnectionProvider() {
        Bundle bundle = FrameworkUtil.getBundle(GradlePropertiesConnectionProvider.class);
        try {
            URL localFileURL = FileLocator.toFileURL((URL)bundle.getEntry("/"));
            Path pathToPlugin = Paths.get(localFileURL.toURI());
            String pathToServer = pathToPlugin.resolve("libs/language-server.jar").toString();
            IExecutionEnvironment[] executionEnvironments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            IExecutionEnvironment java11Environment = null;
            for (IExecutionEnvironment environment : executionEnvironments) {
                if (!environment.getId().equals("JavaSE-11")) continue;
                java11Environment = environment;
                break;
            }
            ArrayList<IVMInstall> compatibleJVMs = new ArrayList<IVMInstall>(Arrays.asList(java11Environment.getCompatibleVMs()));
            IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
            IVMInstall javaExecutable = null;
            if (!compatibleJVMs.isEmpty()) {
                javaExecutable = compatibleJVMs.contains(defaultVMInstall) ? defaultVMInstall : compatibleJVMs.get(0);
                String pathToJavaExecutable = javaExecutable.getInstallLocation().toPath().resolve("bin").resolve("java").toString();
                ArrayList<String> commands = new ArrayList<String>(Arrays.asList(pathToJavaExecutable, "-jar", pathToServer));
                this.setCommands(commands);
                this.setWorkingDirectory(pathToPlugin.toString());
            } else {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = new Shell();
                        MessageBox messageBox = new MessageBox(shell, 40);
                        messageBox.setText("Error");
                        messageBox.setMessage("Compatible version of Java isn't found! Install and rerun application.");
                        messageBox.open();
                        shell.dispose();
                    }
                });
            }
        }
        catch (IOException | URISyntaxException e) {
            System.err.println("[GradlePropertiesConnectionProvider]:" + e.toString());
            e.printStackTrace();
        }
    }
}

