/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.config.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.polarsys.capella.common.tools.report.config.persistence.LogLevel;
import org.polarsys.capella.common.tools.report.config.persistence.ObjectFactory;
import org.polarsys.capella.common.tools.report.config.persistence.OutputConfiguration;
import org.polarsys.capella.common.tools.report.config.persistence.ReportConfigurationFile;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CreateXmlConfiguration {
    private static final String FILE_PATH = System.getProperty("osgi.configuration.area") + "ReportConfiguration.xml";
    private final ObjectFactory objectFactory = new ObjectFactory();
    private String filePath = null;

    public CreateXmlConfiguration() {
        this.filePath = URI.createURI((String)FILE_PATH).toFileString();
    }

    public CreateXmlConfiguration(String filePath) {
        this.filePath = filePath;
    }

    public ConfigurationInstance createDefaultConfiguration(String componentName, Collection<String> appenders) {
        ConfigurationInstance confInstance = this.objectFactory.createConfigurationInstance();
        confInstance.setComponentName(componentName);
        List<OutputConfiguration> opConfList = confInstance.getOutputConfiguration();
        for (String appenderName : appenders) {
            OutputConfiguration currentConfig = this.objectFactory.createOutputConfiguration();
            currentConfig.setOutputName(appenderName);
            opConfList.add(currentConfig);
            this.createLogConfig(currentConfig);
        }
        return confInstance;
    }

    private void createLogConfig(OutputConfiguration outputConfiguration) {
        List<LogLevel> logLevelListFile = outputConfiguration.getLogLevel();
        logLevelListFile.clear();
        boolean value = "Information".equals(outputConfiguration.getOutputName());
        logLevelListFile.add(this.buildLogLevel(value, "INFO"));
        logLevelListFile.add(this.buildLogLevel(value, "WARN"));
        logLevelListFile.add(this.buildLogLevel(value, "ERROR"));
        logLevelListFile.add(this.buildLogLevel(value, "FATAL"));
        logLevelListFile.add(this.buildLogLevel(false, "DEBUG"));
    }

    private LogLevel buildLogLevel(boolean logLevelValue, String logLevelInfo) {
        LogLevel infoLevelFile = this.objectFactory.createLogLevel();
        infoLevelFile.setName(logLevelInfo);
        infoLevelFile.setValue(logLevelValue);
        return infoLevelFile;
    }

    public boolean isConfigurationFileExists() {
        File file = new File(this.filePath);
        return file.exists();
    }

    public Map<String, ConfigurationInstance> loadConfiguration() {
        if (this.isConfigurationFileExists()) {
            HashMap<String, ConfigurationInstance> configurationMap = new HashMap<String, ConfigurationInstance>();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new File(this.filePath));
                document.getDocumentElement().normalize();
                ReportConfigurationFile file = new ReportConfigurationFile(document.getDocumentElement());
                configurationMap.putAll(this.getConfiguration(file));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
            return configurationMap;
        }
        return null;
    }

    public Map<String, ConfigurationInstance> getConfiguration(ReportConfigurationFile file) {
        HashMap<String, ConfigurationInstance> configurationMap = new HashMap<String, ConfigurationInstance>(1);
        List<ConfigurationInstance> confInst = file.getConfigurationInstance();
        for (ConfigurationInstance configurationInstance : confInst) {
            configurationMap.put(configurationInstance.getComponentName(), configurationInstance);
        }
        return configurationMap;
    }

    public void saveConfiguration(Map<String, ConfigurationInstance> configurationMap) {
        ReportConfigurationFile repConffile = this.objectFactory.createReportConfigurationFile();
        repConffile.setFileFormatVersion("1.0.1");
        repConffile.setReportManagerVersion("1.1");
        Collection<ConfigurationInstance> confInst = configurationMap.values();
        List<ConfigurationInstance> confInstanceList = repConffile.getConfigurationInstance();
        confInstanceList.addAll(confInst);
        repConffile.setConfigurationInstance(confInstanceList);
        this.doSaveConfigurationFile(repConffile);
    }

    private void doSaveConfigurationFile(ReportConfigurationFile repConffile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlStandalone(true);
            document.appendChild(repConffile.convertToElement(document));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(new File(this.filePath));
            transformer.transform(domSource, streamResult);
        }
        catch (ParserConfigurationException | TransformerException e) {
            e.printStackTrace();
        }
    }
}

