/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.action;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.polarsys.capella.common.ui.toolkit.browser.action.BrowserHistory;
import org.polarsys.capella.common.ui.toolkit.browser.label.provider.factory.AbstractLabelProviderFactory;
import org.polarsys.capella.common.ui.toolkit.browser.view.ISemanticBrowserViewPart;

public class SemanticBrowserHistoryAction
extends Action
implements IMenuCreator,
ActionFactory.IWorkbenchAction {
    public static final String FORWARD_ACTION_ID = "forward";
    public static final String BACKWARD_ACTION_ID = "backward";
    private boolean _forward;
    private ISemanticBrowserViewPart _semanticBrowserViewPart;
    private BrowserHistory _browserHistory;

    public SemanticBrowserHistoryAction(IWorkbenchWindow window, ISemanticBrowserViewPart semanticBrowserView, boolean forward) {
        this._semanticBrowserViewPart = semanticBrowserView;
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        if (forward) {
            this.setText("&Forward");
            this.setToolTipText("Forward");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.setId(FORWARD_ACTION_ID);
        } else {
            this.setText("&Back");
            this.setToolTipText("Back");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.setId(BACKWARD_ACTION_ID);
        }
        this._browserHistory = semanticBrowserView.getHistory();
        this._browserHistory.addActionAsListener(this);
        this._forward = forward;
        this.setMenuCreator(this);
        this.setEnabled(false);
    }

    private HistoryItemAction createHistoryAction(BrowserHistory.BrowserNavigationHistoryEntry navigationEntry) {
        if (!navigationEntry.isValid()) {
            return null;
        }
        Object realObject = navigationEntry.getRealObject();
        ILabelProvider labelProvider = AbstractLabelProviderFactory.getInstance().getCurrentLabelProvider();
        Image image = labelProvider.getImage(realObject);
        ImageDescriptor imgDescriptor = null;
        if (image != null) {
            imgDescriptor = ImageDescriptor.createFromImage((Image)image);
        }
        HistoryItemAction goToAction = new HistoryItemAction(navigationEntry, labelProvider.getText(realObject), imgDescriptor);
        return goToAction;
    }

    private List<BrowserHistory.BrowserNavigationHistoryEntry> getAvailableNavigationEntries() {
        List<BrowserHistory.BrowserNavigationHistoryEntry> historyEntries = null;
        if (this._forward) {
            historyEntries = this._browserHistory.getForwardNavigationEntries();
        } else {
            historyEntries = this._browserHistory.getBackwardNavigationEntries();
            Collections.reverse(historyEntries);
        }
        return historyEntries;
    }

    public Menu getMenu(Control parent) {
        MenuManager menuManager = new MenuManager();
        final Menu menu = menuManager.createContextMenu(parent);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                List<BrowserHistory.BrowserNavigationHistoryEntry> navigationEntries = SemanticBrowserHistoryAction.this.getAvailableNavigationEntries();
                for (BrowserHistory.BrowserNavigationHistoryEntry entry : navigationEntries) {
                    HistoryItemAction historyEntryAction = SemanticBrowserHistoryAction.this.createHistoryAction(entry);
                    if (historyEntryAction == null) continue;
                    manager.add((IAction)historyEntryAction);
                }
            }
        });
        final Display display = menu.getDisplay();
        menu.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!menu.isDisposed()) {
                                menu.dispose();
                            }
                        }
                    });
                }
            }
        });
        return menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void run() {
        Iterator<BrowserHistory.BrowserNavigationHistoryEntry> availableHistoryEntries = this.getAvailableNavigationEntries().iterator();
        if (availableHistoryEntries.hasNext()) {
            HistoryItemAction historyAction = this.createHistoryAction(availableHistoryEntries.next());
            while (historyAction == null) {
                historyAction = this.createHistoryAction(availableHistoryEntries.next());
            }
            historyAction.run();
        }
    }

    protected void updateControlState() {
        boolean enabled = false;
        if (this._forward) {
            if (this._browserHistory.getForwardNavigationEntries().size() > 0) {
                enabled = true;
            }
        } else if (this._browserHistory.getBackwardNavigationEntries().size() > 0) {
            enabled = true;
        }
        this.setEnabled(enabled);
    }

    public void dispose() {
    }

    protected class HistoryItemAction
    extends Action {
        protected BrowserHistory.BrowserNavigationHistoryEntry _navigationEntry;

        public HistoryItemAction(BrowserHistory.BrowserNavigationHistoryEntry navigationEntry, String text, ImageDescriptor imageDescriptor) {
            super(text, imageDescriptor);
            this._navigationEntry = navigationEntry;
        }

        public void run() {
            SemanticBrowserHistoryAction.this._browserHistory.setDoUpdate(false);
            try {
                SemanticBrowserHistoryAction.this._browserHistory.goTo(this._navigationEntry);
                SemanticBrowserHistoryAction.this._semanticBrowserViewPart.setInput(this._navigationEntry.getRealObject());
                SemanticBrowserHistoryAction.this._browserHistory.notifyActionListeners();
            }
            finally {
                SemanticBrowserHistoryAction.this._browserHistory.setDoUpdate(true);
            }
        }
    }
}

