/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.project.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.skeleton.EngineeringDomain;
import org.polarsys.capella.core.model.skeleton.impl.SkeletonServicesImpl;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateCapellaProjectCmd;
import org.polarsys.capella.core.platform.sirius.ui.project.operations.SessionCreationHelper;

public class ProjectSessionCreationHelper
extends SessionCreationHelper {
    CapellaProjectHelper.ProjectApproach projectApproach;
    boolean epbsSelected;
    boolean opaSelected;

    public ProjectSessionCreationHelper(boolean epbsSelected_p, boolean opaSelected_p) {
        this(epbsSelected_p, opaSelected_p, CapellaProjectHelper.ProjectApproach.SingletonComponents);
    }

    public ProjectSessionCreationHelper(boolean epbsSelected_p, boolean opaSelected_p, CapellaProjectHelper.ProjectApproach projectApproach_p) {
        this.projectApproach = projectApproach_p;
        this.epbsSelected = epbsSelected_p;
        this.opaSelected = opaSelected_p;
    }

    protected CapellaProjectHelper.ProjectApproach getProjectApproach() {
        return this.projectApproach;
    }

    protected boolean isEpbsSelected() {
        return this.epbsSelected;
    }

    protected boolean isOpaSelected() {
        return this.opaSelected;
    }

    @Override
    protected ICommand createInitialElementsCommand(Resource resource_p, String projectName_p, IProgressMonitor monitor_p) {
        return new CreateCapellaProjectCmd(resource_p, projectName_p, this.projectApproach);
    }

    @Override
    protected ICommand updateInitialElementsCommand(final Resource semanticResource_p, final String name_p, final IProgressMonitor monitor_p) {
        return new AbstractReadWriteCommand(){

            public void run() {
                EObject root;
                EList content = semanticResource_p.getContents();
                if (!content.isEmpty() && (root = (EObject)content.get(0)) instanceof Project) {
                    ProjectSessionCreationHelper.this.fillNewModel((Project)root, name_p, monitor_p);
                }
            }
        };
    }

    public void fillNewModel(Project project, String name_p, IProgressMonitor monitor_p) {
        EngineeringDomain engDomain = EngineeringDomain.Software;
        if (this.epbsSelected) {
            engDomain = EngineeringDomain.System;
        }
        SkeletonServicesImpl skeletonServicesImpl = new SkeletonServicesImpl();
        skeletonServicesImpl.doSystemEngineering(project, name_p, engDomain, this.opaSelected);
    }

    public void createNewSystemEngineering(Resource semanticResource, String name_p, IProgressMonitor monitor_p) {
        monitor_p.beginTask("Create initial skeletton", 1);
        ICommand command = this.updateInitialElementsCommand(semanticResource, name_p, monitor_p);
        if (command != null) {
            TransactionHelper.getExecutionManager((Resource)semanticResource).execute(command);
        }
        monitor_p.worked(1);
    }
}

