/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.crossreferencer;

import java.lang.ref.WeakReference;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class CapellaECrossReferenceAdapter
extends SiriusCrossReferenceAdapter {
    WeakReference<EditingDomain> _editingDomain;

    public CapellaECrossReferenceAdapter(EditingDomain editingDomain) {
        this._editingDomain = new WeakReference<EditingDomain>(editingDomain);
    }

    protected void adaptAllEReferences(EObject object) {
        EList eAllReferences = object.eClass().getEAllReferences();
        for (EReference eReference : eAllReferences) {
            if (!eReference.isContainment() && !this.isIncluded(eReference)) continue;
            int eventType = 5;
            if (!eReference.isMany()) {
                eventType = 1;
            }
            this.selfAdapt((Notification)new ENotificationImpl((InternalEObject)object, eventType, (EStructuralFeature)eReference, null, object.eGet((EStructuralFeature)eReference)));
        }
    }

    protected void addAdapter(Notifier notifier) {
        if (notifier instanceof Resource && !this.retainResource((Resource)notifier)) {
            return;
        }
        super.addAdapter(notifier);
    }

    protected ECrossReferenceAdapter.InverseCrossReferencer createInverseCrossReferencer() {
        return new CapellaInverseCrossReferencer();
    }

    protected void handleContainment(Notification notification) {
        super.handleContainment(notification);
        int eventType = notification.getEventType();
        if (eventType == 3 || eventType == 5 || eventType == 1) {
            Object newValue = notification.getNewValue();
            if (newValue instanceof EObject) {
                this.adaptAllEReferences((EObject)newValue);
            } else if (newValue instanceof Collection) {
                for (Object value : (Collection)notification.getNewValue()) {
                    if (!(value instanceof EObject)) continue;
                    this.adaptAllEReferences((EObject)value);
                }
            }
        }
        if (eventType == 3 || eventType == 5 || eventType == 1 || eventType == 4 || eventType == 6 || eventType == 2) {
            Object oldValue = notification.getOldValue();
            if (oldValue instanceof EObject) {
                EObject object = (EObject)oldValue;
                if (object.eContainer() == null) {
                    this.unsetTarget(object);
                }
            } else if (oldValue instanceof Collection) {
                for (Object value : (Collection)notification.getOldValue()) {
                    EObject object;
                    if (!(value instanceof EObject) || (object = (EObject)value).eContainer() != null) continue;
                    this.unsetTarget(object);
                }
            }
        }
    }

    protected boolean handleResourceContentNotification(Notification notification) {
        boolean handleSomething = false;
        switch (notification.getFeatureID(Resource.class)) {
            case 2: {
                switch (notification.getEventType()) {
                    case 4: {
                        handleSomething = true;
                        EObject eObject = (EObject)notification.getOldValue();
                        this.unsetTarget(eObject);
                    }
                }
                break;
            }
            case 4: {
                handleSomething = true;
                Object notifier = notification.getNotifier();
                if (!notification.getNewBooleanValue()) break;
                this.unloadedResources.remove(notifier);
                for (Notifier child : ((Resource)notifier).getContents()) {
                    this.addAdapter(child);
                }
                break;
            }
        }
        return handleSomething;
    }

    protected boolean retainResource(Resource resource) {
        return CapellaResourceHelper.isCapellaResource(resource);
    }

    protected void selfAdapt(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof Resource) {
            if (!this.retainResource((Resource)notifier)) {
                return;
            }
            if (this.handleResourceContentNotification(notification)) {
                return;
            }
        }
        super.selfAdapt(notification);
    }

    class CapellaInverseCrossReferencer
    extends ECrossReferenceAdapter.InverseCrossReferencer {
        private static final long serialVersionUID = -3473829340961544993L;

        CapellaInverseCrossReferencer() {
            super((ECrossReferenceAdapter)CapellaECrossReferenceAdapter.this);
        }

        protected void addProxy(EObject proxy, EObject context) {
        }

        protected boolean resolve() {
            return CapellaECrossReferenceAdapter.this.resolve();
        }
    }
}

