/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadOnlyCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;

public class CrossReferencerHelper {
    private static boolean enabledResolution = true;

    public static List<EObject> getReferencingElements(final EObject referencedElement) {
        final ArrayList<EObject> referencingElements = new ArrayList<EObject>(0);
        AbstractReadOnlyCommand command = new AbstractReadOnlyCommand(){

            public void run() {
                SiriusCrossReferenceAdapter crossReferencer = ((SemanticEditingDomainFactory.SemanticEditingDomain)TransactionHelper.getEditingDomain((EObject)referencedElement)).getCrossReferencer();
                referencingElements.addAll(EcoreUtil2.getReferencingElements((EObject)referencedElement, (ECrossReferenceAdapter)crossReferencer));
            }
        };
        ExecutionManager mgr = TransactionHelper.getExecutionManager((EObject)referencedElement);
        if (mgr != null) {
            mgr.execute((ICommand)command);
        }
        return referencingElements;
    }

    public static void enableResolveProxy(TransactionalEditingDomain editingDomain) {
        if (editingDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)editingDomain;
            domain.getCrossReferencer().enableResolveProxy();
        }
    }

    public static void disableResolveProxy(TransactionalEditingDomain editingDomain) {
        if (editingDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)editingDomain;
            domain.getCrossReferencer().disableResolveProxy();
        }
    }

    public static boolean isResolveProxyEnabled(EditingDomain editingDomain) {
        if (editingDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            return ((SemanticEditingDomainFactory.SemanticEditingDomain)editingDomain).getCrossReferencer().isResolveProxyEnabled();
        }
        return true;
    }

    @Deprecated
    public static void enableResolution(boolean enabled) {
        enabledResolution = enabled;
    }

    @Deprecated
    public static boolean resolutionEnabled() {
        return enabledResolution;
    }

    public static boolean isSelfContained(EObject eObject, boolean allowsReferencingElements) {
        HashSet<EObject> hierarchyMembers = new HashSet<EObject>();
        hierarchyMembers.add(eObject);
        TreeIterator allContents = eObject.eAllContents();
        while (allContents.hasNext()) {
            hierarchyMembers.add((EObject)allContents.next());
        }
        for (EObject member : hierarchyMembers) {
            List<EObject> referencingElements;
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)member.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject referencedElement = (EObject)featureIterator.next();
                EReference eReference = (EReference)featureIterator.feature();
                if (eReference.isDerived() || hierarchyMembers.contains(referencedElement)) continue;
                return false;
            }
            if (!allowsReferencingElements || hierarchyMembers.containsAll(referencingElements = CrossReferencerHelper.getReferencingElements(member))) continue;
            return false;
        }
        return true;
    }
}

