/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.helpers;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DRepresentationDescriptorQuery;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.query.SiriusReferenceFinder;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.utils.RunnableWithBooleanResult;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;
import org.polarsys.capella.core.model.handler.helpers.SemanticResourcesScope;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;

public class RepresentationHelper {
    public static Collection<DRepresentation> getRepresentations(Collection<?> selection) {
        return RepresentationHelper.getSelectedDescriptors(selection).stream().map(d -> d.getRepresentation()).collect(Collectors.toList());
    }

    public static Collection<DRepresentationDescriptor> getSelectedDescriptors(Collection<?> selectedElements) {
        return CapellaAdapterHelper.resolveEObjects(selectedElements).stream().filter(x -> x instanceof DRepresentationDescriptor || x instanceof DRepresentation).map(new Function<Object, DRepresentationDescriptor>(){

            @Override
            public DRepresentationDescriptor apply(Object t) {
                if (t instanceof DRepresentation) {
                    return new DRepresentationQuery((DRepresentation)t).getRepresentationDescriptor();
                }
                return (DRepresentationDescriptor)t;
            }
        }).collect(Collectors.toList());
    }

    public static Collection<DRepresentationDescriptor> getAllRepresentationDescriptorsTargetedBy(Collection<?> semanticElements) {
        HashSet<DRepresentationDescriptor> representations = new HashSet<DRepresentationDescriptor>();
        Iterable semanticEObjects = Iterables.filter(semanticElements, EObject.class);
        for (EObject semanticEObject : semanticEObjects) {
            Session session = SessionManager.INSTANCE.getSession(semanticEObject);
            if (session == null) continue;
            representations.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(semanticEObject, session));
            TreeIterator allChildrenOfCurrentElement = semanticEObject.eAllContents();
            while (allChildrenOfCurrentElement != null && allChildrenOfCurrentElement.hasNext()) {
                EObject child = (EObject)allChildrenOfCurrentElement.next();
                representations.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(child, session));
            }
        }
        return representations;
    }

    private static void getRelatedRepresentations(EObject semanticElement, Set<DRepresentationDescriptor> representationDescriptors) {
        HashSet<EObject> semanticElementsToCheck = new HashSet<EObject>();
        semanticElementsToCheck.add(semanticElement);
        if (semanticElement instanceof Component) {
            semanticElementsToCheck.addAll((Collection<EObject>)((Component)semanticElement).getAllocatedFunctions());
        }
        Session session = SessionManager.INSTANCE.getSession(semanticElement);
        Map impactedRepresentationDescriptors = ((DAnalysisSessionImpl)session).getSiriusReferenceFinder().getImpactedRepresentationDescriptors(semanticElementsToCheck, SiriusReferenceFinder.SearchScope.ALL_REPRESENTATIONS_SCOPE);
        for (Map.Entry entry : impactedRepresentationDescriptors.entrySet()) {
            Collection impactedRepDescs = (Collection)entry.getValue();
            if (impactedRepDescs.isEmpty()) continue;
            representationDescriptors.addAll(impactedRepDescs);
        }
    }

    public static Collection<DRepresentationDescriptor> getAllRepresentationDescriptorsWhereSemanticElementIsDisplayed(EObject semanticElement, RunnableWithBooleanResult filteringCondition) {
        Session session = SessionManager.INSTANCE.getSession(semanticElement);
        if (session == null) {
            return Collections.emptySet();
        }
        HashSet<DRepresentationDescriptor> unfilteredRepresentationDescs = new HashSet<DRepresentationDescriptor>();
        RepresentationHelper.getRelatedRepresentations(semanticElement, unfilteredRepresentationDescs);
        HashSet<DRepresentationDescriptor> filteredRepresentationDescs = new HashSet<DRepresentationDescriptor>();
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (DRepresentationDescriptor representationDescriptor : unfilteredRepresentationDescs) {
            RepresentationDescription representationDescription = representationDescriptor.getDescription();
            Viewpoint parentViewpoint = new RepresentationDescriptionQuery(representationDescription).getParentViewpoint();
            if (!selectedViewpoints.contains(parentViewpoint)) continue;
            if (filteringCondition == null) {
                filteredRepresentationDescs.add(representationDescriptor);
                continue;
            }
            filteringCondition.setObject((EObject)representationDescription);
            filteringCondition.run();
            if (!filteringCondition.getResult().booleanValue()) continue;
            filteredRepresentationDescs.add(representationDescriptor);
        }
        return filteredRepresentationDescs;
    }

    public static Collection<Resource> collectDependentResources(EObject semanticRoot) {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (EObject referencingElement : CrossReferencerHelper.getReferencingElements(semanticRoot)) {
            resources.add(referencingElement.eResource());
        }
        for (DRepresentationDescriptor representationDescriptor : RepresentationHelper.getAllRepresentationDescriptorsWhereSemanticElementIsDisplayed(semanticRoot, null)) {
            resources.add(representationDescriptor.eResource());
        }
        Resource semanticRootResource = semanticRoot.eResource();
        TreeIterator semanticRootEAllContents = semanticRoot.eAllContents();
        while (semanticRootEAllContents.hasNext()) {
            EObject child = (EObject)semanticRootEAllContents.next();
            Resource childResource = EcoreUtil2.getResourceContainer((EObject)child).eResource();
            if (!semanticRootResource.equals(childResource)) continue;
            for (EObject referencingElement : CrossReferencerHelper.getReferencingElements(child)) {
                resources.add(referencingElement.eResource());
            }
            for (DRepresentationDescriptor representationDescriptor : RepresentationHelper.getAllRepresentationDescriptorsWhereSemanticElementIsDisplayed(child, null)) {
                resources.add(representationDescriptor.eResource());
            }
        }
        return resources;
    }

    @Deprecated
    public static DAnnotation getAnnotation(String source, DRepresentation representation) {
        for (DAnnotation annotation : representation.getEAnnotations()) {
            if (annotation.getSource() == null || !annotation.getSource().equals(source)) continue;
            return annotation;
        }
        return null;
    }

    @Deprecated
    public static DAnnotation createAnnotation(String source, DRepresentation representation) {
        DAnnotation annotation = DescriptionFactory.eINSTANCE.createDAnnotation();
        annotation.setSource(source);
        representation.getEAnnotations().add((Object)annotation);
        return annotation;
    }

    @Deprecated
    public static void removeAnnotation(String source, DRepresentation representation) {
        DAnnotation annotation = RepresentationHelper.getAnnotation(source, representation);
        if (annotation != null) {
            representation.getEAnnotations().remove((Object)annotation);
        }
    }

    public static Collection<Resource> getSemanticResources(DRepresentationDescriptor representation) {
        EObject root;
        if (representation != null && (root = representation.getTarget()) != null) {
            HashSet<Resource> resources = new HashSet<Resource>();
            Session session = SessionManager.INSTANCE.getSession(root);
            if (session != null) {
                Set referencedSessionResources;
                HashSet sessionResources = new HashSet();
                Collection sessionSemanticResources = session.getSemanticResources();
                if (sessionSemanticResources != null) {
                    sessionResources.addAll(sessionSemanticResources);
                }
                if ((referencedSessionResources = session.getReferencedSessionResources()) != null) {
                    sessionResources.addAll(referencedSessionResources);
                }
                for (Resource resource : sessionResources) {
                    if (resource instanceof AirdResource) {
                        AirdResource airdResource = (AirdResource)resource;
                        if (airdResource.getContents() == null) continue;
                        for (EObject rootAird : airdResource.getContents()) {
                            DAnalysis analysis;
                            if (!(rootAird instanceof DAnalysis) || (analysis = (DAnalysis)rootAird).getModels() == null) continue;
                            for (EObject model : analysis.getModels()) {
                                Resource modelResource;
                                if (model == null || model.eIsProxy() || (modelResource = model.eResource()) == null) continue;
                                resources.add(modelResource);
                            }
                        }
                        continue;
                    }
                    if (!CapellaResourceHelper.isCapellaResource(resource)) continue;
                    resources.add(resource);
                }
                return resources;
            }
            return Collections.singletonList(root.eResource());
        }
        return Collections.EMPTY_LIST;
    }

    public static DRepresentationDescriptor getRepresentationDescriptor(Session session, DRepresentation representation) {
        return new DRepresentationQuery(representation).getRepresentationDescriptor();
    }

    public static DRepresentationDescriptor getRepresentationDescriptor(DRepresentation representation) {
        return new DRepresentationQuery(representation).getRepresentationDescriptor();
    }

    public static EObject getRepresentationDescriptorOrSemanticObject(ResourceSet rSet, String id) {
        SemanticResourcesScope scope = new SemanticResourcesScope(rSet);
        EObject eObject = IdManager.getInstance().getEObject(id, (IScope)scope);
        if (eObject == null) {
            return RepresentationHelper.getRepresentationDescriptor(rSet, id);
        }
        return eObject;
    }

    public static DRepresentationDescriptor getRepresentationDescriptor(ResourceSet resourceSet, String id) {
        SemanticResourcesScope capellaSemanticResourceScope = new SemanticResourcesScope(resourceSet);
        List capellaSemanticResources = capellaSemanticResourceScope.getResources();
        Resource resource = capellaSemanticResources.stream().findFirst().orElse(null);
        Session session = SessionManager.INSTANCE.getSession(resource);
        Collection representationDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
        for (DRepresentationDescriptor representationDescriptor : representationDescriptors) {
            String descriptorFragment;
            try {
                descriptorFragment = representationDescriptor.getRepPath().getResourceURI().fragment();
            }
            catch (NullPointerException e) {
                descriptorFragment = "";
            }
            String descriptorUid = representationDescriptor.getUid();
            if (!id.equals(descriptorFragment) && !id.equals(descriptorUid)) continue;
            return representationDescriptor;
        }
        return null;
    }

    public static Collection<DRepresentationDescriptor> getRepresentationDescriptors(Collection<DRepresentation> representations) {
        HashSet<DRepresentationDescriptor> result = new HashSet<DRepresentationDescriptor>();
        for (DRepresentation representation : representations) {
            DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor(representation);
            if (descriptor == null) continue;
            result.add(descriptor);
        }
        return result;
    }

    public static Collection<DRepresentationDescriptor> getAllRepresentationDescriptorsAnnotatedBy(List<EObject> objects) {
        Session session;
        ArrayList<DRepresentationDescriptor> result = new ArrayList<DRepresentationDescriptor>();
        if (!objects.isEmpty() && (session = SessionManager.INSTANCE.getSession(objects.iterator().next())) != null) {
            block0: for (DRepresentationDescriptor descriptor : DialectManager.INSTANCE.getAllRepresentationDescriptors(session)) {
                for (DAnnotation annotation : descriptor.getEAnnotations()) {
                    if (Collections.disjoint(annotation.getReferences(), objects)) continue;
                    result.add(descriptor);
                    continue block0;
                }
            }
        }
        return result;
    }

    public static boolean isValid(DRepresentationDescriptor descriptor) {
        return new DRepresentationDescriptorQuery(descriptor).isRepresentationValid();
    }

    public static String getRepresentationStatusText(DRepresentationDescriptor element) {
        String result = "";
        if (!new DRepresentationDescriptorQuery(element).isRepresentationValid()) {
            return "(Invalid)";
        }
        if (!element.isLoadedRepresentation()) {
            result = "(Not Loaded)";
        } else {
            DRepresentation representation = element.getRepresentation();
            if (representation instanceof DDiagram) {
                result = ((DDiagram)representation).isSynchronized() ? "(Synchronized)" : "(Unsynchronized)";
            }
        }
        return result;
    }

    public static String getRepresentationFullPathText(DRepresentationDescriptor descriptor) {
        Object fullPathText = "";
        EObject semanticElement = descriptor.getTarget();
        if (semanticElement != null) {
            fullPathText = (String)fullPathText + EObjectLabelProviderHelper.getFullPathText((EObject)semanticElement);
        }
        fullPathText = (String)fullPathText + "::" + descriptor.getName() + " " + RepresentationHelper.getRepresentationStatusText(descriptor);
        return fullPathText;
    }

    public static void setTarget(DRepresentationDescriptor representationDescriptor, DRepresentation representation, EObject target) {
        if (representation instanceof DSemanticDecorator) {
            ((DSemanticDecorator)representation).setTarget(target);
            representationDescriptor.setTarget(target);
        }
    }

    public static void setTarget(DRepresentation representation, EObject target) {
        RepresentationHelper.setTarget(RepresentationHelper.getRepresentationDescriptor(representation), representation, target);
    }

    public static void setTarget(DRepresentationDescriptor representationDescriptor, EObject target) {
        RepresentationHelper.setTarget(representationDescriptor, representationDescriptor.getRepresentation(), target);
    }
}

