/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.DeleteEObjectTask;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CompositeFilterApplicationBuilder;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.activity.Pin;
import org.polarsys.capella.common.data.modellingcore.AbstractConstraint;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.helpers.cache.CachedFunction;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManager;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.commands.preferences.initializers.CapellaDiagramPreferencesInitializer;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeCategory;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.information.PortRealization;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.PhysicalQuantity;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.RefinementLink;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.Messages;
import org.polarsys.capella.core.sirius.analysis.PhysicalServices;
import org.polarsys.capella.core.sirius.analysis.queries.QueryIdentifierConstants;
import org.polarsys.capella.core.sirius.analysis.tool.StringUtil;

public class CapellaServices {
    public static final String RE_THROW_OCE_PREFIX = "-RT-";
    static CachedFunction<PhysicalLink, Set<PhysicalPath>> getInvolvingPhysicalPaths = PhysicalLinkExt::getInvolvingPhysicalPaths;
    static CachedFunction<DDiagram, Map<PhysicalPath, DNode>> getDisplayedPhysicalPathAndNodes = PhysicalServices.getService()::getDisplayedPhysicalPathsAndNodes;
    static CachedFunction<DDiagram, Map<FunctionalChain, DNode>> getDisplayedFunctionalChainAndNodes = FunctionalChainServices.getFunctionalChainServices()::getDisplayedFunctionalChains;
    private static CapellaServices service;

    public EObject getRootContainer(EObject eObject) {
        return EcoreUtil.getRootContainer((EObject)eObject);
    }

    public List<DDiagramElementContainer> getAllContainersNew(EObject container) {
        return this.getAllContainers(container);
    }

    public static Collection<EObject> getAllDAnalysis(EObject eObject) {
        Session session;
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject source = eObject;
        if (source instanceof DSemanticDecorator) {
            source = ((DSemanticDecorator)source).getTarget();
        }
        if (source instanceof DRepresentationDescriptor) {
            source = ((DRepresentationDescriptor)source).getTarget();
        }
        if ((session = SessionManager.INSTANCE.getSession(source)) instanceof DAnalysisSession) {
            result.addAll(((DAnalysisSession)session).allAnalyses());
        }
        return result;
    }

    public Object void2Null(EObject eObject, Object object) {
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return null;
        }
        return object;
    }

    public Object makeIntersection(EObject eObject, Object obj1, Object obj2) {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            if (obj1 instanceof Collection) {
                result.addAll((Collection)obj1);
            } else if (obj1 != null) {
                result.add(obj1);
            }
            if (obj2 instanceof Collection) {
                result.retainAll((Collection)obj2);
            } else if (obj2 != null && !result.contains(obj2)) {
                result.remove(obj2);
            }
            return result;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException();
        }
    }

    public Object makeDiff(EObject eObject, Object obj1, Object obj2) {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            if (obj1 instanceof Collection) {
                result.addAll((Collection)obj1);
            } else if (obj1 != null) {
                result.add(obj1);
            }
            if (obj2 instanceof Collection) {
                result.removeAll((Collection)obj2);
            } else if (obj2 instanceof Object[]) {
                Object[] objectArray = (Object[])obj2;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    result.remove(o);
                    ++n2;
                }
            } else if (obj2 != null) {
                result.remove(obj2);
            }
            return result;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException();
        }
    }

    public Object makeUnion(EObject eObject, Object obj1, Object obj2) {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            if (obj1 instanceof Collection) {
                result.addAll((Collection)obj1);
            } else if (obj1 != null) {
                result.add(obj1);
            }
            if (obj2 instanceof Collection) {
                result.addAll((Collection)obj2);
            } else if (obj2 != null) {
                result.add(obj2);
            }
            return result;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException();
        }
    }

    public Object makeUnion(EObject eObject, Object obj1, Object obj2, Object obj3) {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            if (obj1 instanceof Collection) {
                result.addAll((Collection)obj1);
            } else if (obj1 != null) {
                result.add(obj1);
            }
            if (obj2 instanceof Collection) {
                result.addAll((Collection)obj2);
            } else if (obj2 != null) {
                result.add(obj2);
            }
            if (obj3 instanceof Collection) {
                result.addAll((Collection)obj3);
            } else if (obj3 != null) {
                result.add(obj3);
            }
            return result;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException();
        }
    }

    public Object makeUnion(EObject eObject, Object obj1, Object obj2, Object obj3, Object obj4) {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            if (obj1 instanceof Collection) {
                result.addAll((Collection)obj1);
            } else if (obj1 != null) {
                result.add(obj1);
            }
            if (obj2 instanceof Collection) {
                result.addAll((Collection)obj2);
            } else if (obj2 != null) {
                result.add(obj2);
            }
            if (obj3 instanceof Collection) {
                result.addAll((Collection)obj3);
            } else if (obj3 != null) {
                result.add(obj3);
            }
            if (obj4 instanceof Collection) {
                result.addAll((Collection)obj4);
            } else if (obj4 != null) {
                result.add(obj4);
            }
            return result;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException();
        }
    }

    public List<EObject> selectOnlyCreatedView(EObject eObject) {
        return Collections.singletonList((EObject)InterpreterUtil.getInterpreter((EObject)eObject).getVariable("view"));
    }

    public boolean isInLib(EObject context) {
        Session session = SessionManager.INSTANCE.getSession(context);
        IModel sessionModel = ILibraryManager.INSTANCE.getModel(TransactionHelper.getEditingDomain((Session)session));
        IModel currentElementModel = ILibraryManager.INSTANCE.getModel(context);
        return sessionModel.equals(currentElementModel);
    }

    public List<EObject> ancestor(EObject object) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (object != null) {
            object = object.eContainer();
            while (object != null) {
                result.add(object);
                object = object.eContainer();
            }
        }
        return result;
    }

    protected void addInAvailableFunctionList(AbstractFunction function, AbstractFunction functionToAdd, List<AbstractFunction> functionInDiagram) {
        if (EcoreUtil.isAncestor((EObject)functionToAdd, (EObject)function) || EcoreUtil.isAncestor((EObject)function, (EObject)functionToAdd) || functionInDiagram.contains(functionToAdd)) {
            return;
        }
        AbstractFunction toRemove = null;
        boolean toAdd = true;
        for (AbstractFunction aFunction : functionInDiagram) {
            if (EcoreUtil.isAncestor((EObject)functionToAdd, (EObject)aFunction)) {
                toRemove = aFunction;
                toAdd = true;
                break;
            }
            if (!EcoreUtil.isAncestor((EObject)aFunction, (EObject)functionToAdd)) continue;
            toAdd = false;
        }
        if (toRemove != null && functionInDiagram.contains(toRemove)) {
            functionInDiagram.remove(toRemove);
        }
        if (toAdd && !functionInDiagram.contains(toRemove)) {
            functionInDiagram.add(functionToAdd);
        }
    }

    public EObject creationService(EObject context) {
        return CapellaElementExt.creationService((EObject)context);
    }

    public EObject creationService(EObject context, String namingPrefix) {
        return CapellaElementExt.creationService((EObject)context, (String)namingPrefix);
    }

    public void deleteView(DDiagramElement element) {
        DeleteEObjectTask task = new DeleteEObjectTask((EObject)element, SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)element));
        try {
            task.execute();
        }
        catch (FeatureNotFoundException | MetaClassNotFoundException throwable) {
            // empty catch block
        }
    }

    public void filter(Collection<? extends EObject> collection, EClass type) {
        Iterator<? extends EObject> iterContents = collection.iterator();
        while (iterContents.hasNext()) {
            EObject next = iterContents.next();
            if (type.isSuperTypeOf(next.eClass())) continue;
            iterContents.remove();
        }
    }

    public EObject forceRefresh(DDiagram diagram) {
        if (diagram != null && !new DRepresentationQuery((DRepresentation)diagram).isAutoRefresh()) {
            if (!diagram.getActivatedFilters().isEmpty()) {
                CompositeFilterApplicationBuilder builder = new CompositeFilterApplicationBuilder(diagram);
                builder.computeCompositeFilterApplications();
            }
            DialectManager.INSTANCE.refresh((DRepresentation)diagram, (IProgressMonitor)new NullProgressMonitor());
        }
        return diagram;
    }

    public String getNavigationName(DSemanticDecorator containerView, String diagramName) {
        String result = diagramName;
        if (StringUtil.isEmpty(result)) {
            result = Messages.CapellaServices_NavigateUnnamed;
        }
        return Messages.CapellaServices_NavigateOpen + result;
    }

    public List<EObject> getNavigationScope(EObject current) {
        ArrayList<EObject> scope = new ArrayList<EObject>();
        if (current instanceof AbstractTypedElement) {
            scope.add((EObject)((AbstractTypedElement)current).getAbstractType());
        } else if (current instanceof AbstractType) {
            scope.addAll((Collection<EObject>)((AbstractType)current).getAbstractTypedElements());
        }
        return scope;
    }

    public List<Component> getAllActors(ComponentPkg actorPkg) {
        return ScenarioExt.getAllActors((EObject)actorPkg);
    }

    /*
     * Unable to fully structure code
     */
    public List<EObject> getAllAncestor(EObject eObject) {
        obj = eObject;
        list = new ArrayList<EObject>();
        if (obj != null) ** GOTO lbl9
        return list;
lbl-1000:
        // 1 sources

        {
            container = obj.eContainer();
            list.add(container);
            obj = container;
lbl9:
            // 2 sources

            ** while (obj.eContainer() != null)
        }
lbl10:
        // 1 sources

        return list;
    }

    public List<Component> getAllAncestors(EObject context, Component current) {
        return this.getAllAncestors(current);
    }

    List<Component> getAllAncestors(Component current) {
        return ComponentExt.getAllPartitionableElementAncestors((Component)current);
    }

    public EList<CapabilityExploitation> getAllCapabilityExploitation(EObject context) {
        BasicEList list = new BasicEList();
        SystemAnalysis ca = (SystemAnalysis)this.getAncestor(context, CtxPackage.Literals.SYSTEM_ANALYSIS);
        EList<MissionPkg> allMissionPkg = this.getAllRecursiveMissionPkg(ca);
        BasicEList ownedMissions = new BasicEList();
        for (MissionPkg missionPkg : allMissionPkg) {
            ownedMissions.addAll((Collection)missionPkg.getOwnedMissions());
        }
        for (Mission mission : ownedMissions) {
            list.addAll((Collection)mission.getOwnedCapabilityExploitations());
        }
        return list;
    }

    private Collection<Constraint> getAllConstraints(EObject context) {
        ArrayList<Constraint> returnedClasses = new ArrayList<Constraint>();
        for (BlockArchitecture aBlockArchitecture : this.getAvailableArchitectures(context)) {
            TreeIterator it = aBlockArchitecture.eAllContents();
            while (it.hasNext()) {
                EObject currentObject = (EObject)it.next();
                if (!(currentObject instanceof Constraint)) continue;
                returnedClasses.add((Constraint)currentObject);
            }
        }
        return returnedClasses;
    }

    private List<Pin> getAllContainedPins(AbstractFunction function) {
        LinkedList<Pin> result = new LinkedList<Pin>();
        for (EObject eObject : FaServices.getFaServices().getAllAbstractFunctions(function)) {
            if (!(eObject instanceof AbstractFunction)) continue;
            result.addAll(this.getContainedPins((AbstractFunction)eObject));
        }
        return result;
    }

    public List<DDiagramElementContainer> getAllContainers(EObject container) {
        EList returnedList = new ArrayList();
        if (container instanceof DDiagram) {
            returnedList = ((DDiagram)container).getContainers();
        } else if (container instanceof DDiagramElementContainer) {
            returnedList.add((DDiagramElementContainer)container);
            for (DDiagramElementContainer aContainer : ((DDiagramElementContainer)container).getContainers()) {
                returnedList.addAll(this.getAllContainers((EObject)aContainer));
            }
        }
        return returnedList;
    }

    public List<Component> getAllDescendants(Component current) {
        ArrayList<Component> result = new ArrayList<Component>();
        List ownedPartitions = ComponentExt.getSubParts((Component)current);
        ArrayList<Component> children = new ArrayList<Component>();
        for (Part partition : ownedPartitions) {
            if (!(partition.getAbstractType() instanceof Component)) continue;
            Component pa = (Component)partition.getAbstractType();
            children.add(pa);
        }
        result.addAll(children);
        for (Component partitionableElement : children) {
            result.addAll(this.getAllDescendants(partitionableElement));
        }
        return result;
    }

    public EList<ExchangeCategory> getAllExchangeCategory(EObject context) {
        BasicEList result = new BasicEList();
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)context);
        result.addAll((Collection)FunctionPkgExt.getAllExchangeCategories((FunctionPkg)architecture.getOwnedFunctionPkg()));
        return result;
    }

    public Collection<AbstractExchangeItem> getAllExchangeItems(EObject context) {
        ArrayList<AbstractExchangeItem> returnedInformationItems = new ArrayList<AbstractExchangeItem>();
        List blocks = QueryInterpretor.executeQuery((String)"GetAvailableArchitecturesForLib", (Object)context);
        for (BlockArchitecture aBlockArchitecture : blocks) {
            TreeIterator it = aBlockArchitecture.eAllContents();
            while (it.hasNext()) {
                EObject currentObject = (EObject)it.next();
                if (currentObject instanceof AbstractExchangeItem) {
                    returnedInformationItems.add((AbstractExchangeItem)currentObject);
                }
                if (currentObject instanceof Block || currentObject instanceof Structure) continue;
                it.prune();
            }
        }
        return returnedInformationItems;
    }

    public List<FunctionalChain> getAllFunctionalChain(ModelElement context) {
        BlockArchitecture architecture = ComponentExt.getRootBlockArchitecture((ModelElement)context);
        return FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)architecture);
    }

    private List<DNodeContainer> getAllGraphicalContainers(DDiagram diagram) {
        ArrayList<DNodeContainer> returnedList = new ArrayList<DNodeContainer>();
        for (AbstractDNode aContainer : diagram.getContainers()) {
            if (!(aContainer instanceof DNodeContainer)) continue;
            returnedList.add((DNodeContainer)aContainer);
        }
        return returnedList;
    }

    private List<DNodeContainer> getAllGraphicalContainers(DNodeContainer container) {
        LinkedList<DNodeContainer> result = new LinkedList<DNodeContainer>();
        result.add(container);
        for (AbstractDNode aContainer : container.getContainers()) {
            if (!(aContainer instanceof DNodeContainer)) continue;
            result.add((DNodeContainer)aContainer);
        }
        return result;
    }

    public List<LogicalComponent> getAllLogicalActors(LogicalComponentPkg logicalActorPkg) {
        return ScenarioExt.getAllActors((EObject)logicalActorPkg);
    }

    public List<PhysicalComponent> getAllphysicalActors(PhysicalComponentPkg physicalActorPkg) {
        return ScenarioExt.getAllActors((EObject)physicalActorPkg);
    }

    @Deprecated
    public EList<PortAllocation> getAllPortAllocation(EObject context) {
        BasicEList result = new BasicEList();
        Collection subLCsFromRoot = BlockArchitectureExt.getAllComponents((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)context));
        for (Component partitionableElement : subLCsFromRoot) {
            EList ownedFeatures = partitionableElement.getOwnedFeatures();
            for (Feature feature : ownedFeatures) {
                if (!(feature instanceof Port)) continue;
                Port fp = (Port)feature;
                result.addAll((Collection)fp.getOwnedPortAllocations());
            }
        }
        return result;
    }

    @Deprecated
    public EList<PortRealization> getAllPortRealisation(EObject context) {
        BasicEList result = new BasicEList();
        Collection enclosedComponents = BlockArchitectureExt.getAllComponents((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)context));
        for (Component partitionableElement : enclosedComponents) {
            EList ownedFeatures = partitionableElement.getOwnedFeatures();
            for (Feature feature : ownedFeatures) {
                if (!(feature instanceof Port)) continue;
                Port fp = (Port)feature;
                result.addAll((Collection)fp.getOwnedPortRealizations());
            }
        }
        return result;
    }

    public EList<Mission> getAllPurposeMission(Capability context) {
        BasicEList list = new BasicEList();
        list.addAll((Collection)context.getPurposeMissions());
        SystemAnalysis ca = (SystemAnalysis)this.getAncestor((EObject)context, CtxPackage.Literals.SYSTEM_ANALYSIS);
        EList<MissionPkg> allMissionPkg = this.getAllRecursiveMissionPkg(ca);
        BasicEList ownedMissions = new BasicEList();
        for (MissionPkg missionPkg : allMissionPkg) {
            ownedMissions.addAll((Collection)missionPkg.getOwnedMissions());
        }
        for (Mission mission : ownedMissions) {
            EList exploitedCapabilities = mission.getExploitedCapabilities();
            if (!exploitedCapabilities.contains((Object)context)) continue;
            list.add((Object)mission);
        }
        return list;
    }

    private EList<MissionPkg> getAllRecursiveMissionPkg(MissionPkg missionPkg) {
        BasicEList list = new BasicEList();
        EList subMissionPkgs = missionPkg.getOwnedMissionPkgs();
        list.addAll((Collection)subMissionPkgs);
        for (MissionPkg pkg : subMissionPkgs) {
            list.addAll(this.getAllRecursiveMissionPkg(pkg));
        }
        return list;
    }

    private EList<MissionPkg> getAllRecursiveMissionPkg(SystemAnalysis contextArchi) {
        BasicEList list = new BasicEList();
        MissionPkg ownedMissionPkg = contextArchi.getOwnedMissionPkg();
        list.add((Object)ownedMissionPkg);
        list.addAll(this.getAllRecursiveMissionPkg(ownedMissionPkg));
        return list;
    }

    public List<AbstractCapability> getAllSuperCapabilities(EObject context, AbstractCapability target) {
        LinkedList<AbstractCapability> result = new LinkedList<AbstractCapability>();
        result.add(target);
        if (target.getSuper() == null) {
            return result;
        }
        for (AbstractCapability current : target.getSuper()) {
            result.addAll(this.getAllSuperCapabilities(context, current));
        }
        return result;
    }

    public String getAllUniqueName(AbstractNamedElement namedElement, String prefix) {
        return EcoreUtil2.getUniqueName((EObject)namedElement, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)prefix, (boolean)false, (boolean)true);
    }

    public EObject getAncestor(EObject context, EClass eclass) {
        EObject current = context.eContainer();
        while (current != null && !eclass.isInstance((Object)current)) {
            current = current.eContainer();
        }
        return current;
    }

    public List<BlockArchitecture> getAvailableArchitectures(EObject context) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_AVAILABLE_ARCHITECTURES, (Object)context);
    }

    public Collection<EObject> getRelatedAssociations(Classifier clazz) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (TypedElement typedElement : clazz.getTypedElements()) {
            SiriusCrossReferenceAdapter crossReferencer;
            Property property;
            SemanticEditingDomainFactory.SemanticEditingDomain semEditDomain;
            if (!(typedElement instanceof Property) || ((Property)typedElement).getAggregationKind() == AggregationKind.UNSET || (semEditDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionHelper.getEditingDomain((EObject)(property = (Property)typedElement))) == null || (crossReferencer = semEditDomain.getCrossReferencer()) == null) continue;
            for (EStructuralFeature.Setting setting : crossReferencer.getInverseReferences((EObject)property)) {
                EObject eObject = setting.getEObject();
                if (!(eObject instanceof Association)) continue;
                result.add(eObject);
            }
        }
        return result;
    }

    public List<EObject> getAvailableAssociationToInsert(EObject context) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (context instanceof AbstractDNode) {
            AbstractDNode currentContainer = (AbstractDNode)context;
            DDiagram currentDiagram = this.getDiagramContainer((EObject)currentContainer);
            ArrayList<EObject> elementsIndiagram = new ArrayList<EObject>();
            for (AbstractDNode aContainer : currentDiagram.getContainers()) {
                elementsIndiagram.add(aContainer.getTarget());
            }
            if (currentContainer.getTarget() instanceof Classifier) {
                Classifier target = (Classifier)currentContainer.getTarget();
                result.addAll(this.getRelatedAssociations(target));
            }
            for (DEdge anEdge : currentDiagram.getEdges()) {
                if (!result.contains(anEdge.getTarget())) continue;
                result.remove(anEdge.getTarget());
            }
        }
        return result;
    }

    public EObject getSemanticContext(EObject context) {
        EObject semanticContext = context;
        if (semanticContext instanceof DSemanticDecorator) {
            semanticContext = ((DSemanticDecorator)semanticContext).getTarget();
        }
        return semanticContext;
    }

    public Collection<Constraint> getAvailableConstraintToInsert(EObject context, EObject containerView) {
        EObject semanticContext = this.getSemanticContext(context);
        if (containerView instanceof DDiagram) {
            return this.getAllConstraints(semanticContext);
        }
        if (semanticContext instanceof Structure) {
            ArrayList<Constraint> list = new ArrayList<Constraint>();
            EList constraints = ((Structure)semanticContext).getOwnedConstraints();
            for (AbstractConstraint abstractConstraint : constraints) {
                if (!(abstractConstraint instanceof Constraint)) continue;
                list.add((Constraint)abstractConstraint);
            }
            return list;
        }
        return new ArrayList<Constraint>();
    }

    public List<AbstractFunction> getCDFSemanticAbstractFunctions(AbstractFunction function) {
        AbstractFunction linkedFunction;
        ArrayList<AbstractFunction> returnedFunctions = new ArrayList<AbstractFunction>();
        AbstractFunction node = function;
        if (node.getOutgoing() != null) {
            for (ActivityEdge anActivityEdge : node.getOutgoing()) {
                if (!(anActivityEdge instanceof FunctionalExchange)) continue;
                linkedFunction = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)((FunctionalExchange)anActivityEdge));
                this.addInAvailableFunctionList(function, linkedFunction, returnedFunctions);
            }
        }
        if (node.getIncoming() != null) {
            for (ActivityEdge anActivityEdge : node.getIncoming()) {
                if (!(anActivityEdge instanceof FunctionalExchange)) continue;
                linkedFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)anActivityEdge));
                this.addInAvailableFunctionList(function, linkedFunction, returnedFunctions);
            }
        }
        for (Pin aPin : this.getAllContainedPins(function)) {
            AbstractFunction linkedFunction2;
            if (aPin.getIncoming() != null) {
                for (ActivityEdge anActivityEdge : aPin.getIncoming()) {
                    if (!(anActivityEdge instanceof FunctionalExchange)) continue;
                    linkedFunction2 = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)anActivityEdge));
                    this.addInAvailableFunctionList(function, linkedFunction2, returnedFunctions);
                }
            }
            if (aPin.getOutgoing() == null) continue;
            for (ActivityEdge anActivityEdge : aPin.getOutgoing()) {
                if (!(anActivityEdge instanceof FunctionalExchange)) continue;
                linkedFunction2 = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)((FunctionalExchange)anActivityEdge));
                this.addInAvailableFunctionList(function, linkedFunction2, returnedFunctions);
            }
        }
        returnedFunctions.add(function);
        return returnedFunctions;
    }

    public List<EObject> getAvailableExchangeItemElementToInsert(EObject context) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (context instanceof AbstractDNode) {
            AbstractDNode currentContainer = (AbstractDNode)context;
            DDiagram currentDiagram = this.getDiagramContainer((EObject)currentContainer);
            ArrayList<EObject> elementsIndiagram = new ArrayList<EObject>();
            for (AbstractDNode aContainer : currentDiagram.getContainers()) {
                elementsIndiagram.add(aContainer.getTarget());
            }
            for (AbstractDNode aContainer : currentDiagram.getNodes()) {
                elementsIndiagram.add(aContainer.getTarget());
            }
            if (currentContainer.getTarget() instanceof ExchangeItem) {
                ExchangeItem target = (ExchangeItem)currentContainer.getTarget();
                result.addAll((Collection<EObject>)target.getOwnedElements());
            }
            for (DEdge anEdge : currentDiagram.getEdges()) {
                if (!result.contains(anEdge.getTarget())) continue;
                result.remove(anEdge.getTarget());
            }
        }
        return result;
    }

    public List<EObject> getAvailableFunctionalAllocation(CapellaElement capellaElement) {
        ArrayList<EObject> returnedList = new ArrayList<EObject>();
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(capellaElement.eClass(), (EStructuralFeature)FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__ALLOCATED_FUNCTIONS);
        if (query != null) {
            returnedList.addAll(query.getAvailableElements((EObject)capellaElement));
        }
        return returnedList;
    }

    List<AbstractFunction> getAvailableFunctionsInDataFlowBlank(AbstractFunction context) {
        FunctionPkg pkgOwner = (FunctionPkg)this.getAncestor((EObject)context, FaPackage.Literals.FUNCTION_PKG);
        return FunctionPkgExt.getAllAbstractFunctions((FunctionPkg)pkgOwner);
    }

    public List<AbstractFunction> getAvailableFunctionsToInsert(EObject current) {
        ArrayList<AbstractFunction> returnedFunctions = new ArrayList<AbstractFunction>();
        List<DNodeContainer> allGraphicalContainers = null;
        ArrayList ownedNodes = new ArrayList();
        AbstractFunction rootFunction = null;
        if (current instanceof DSemanticDecorator) {
            EObject eObject = ((DSemanticDiagram)current).getTarget();
            if (current instanceof DSemanticDiagram) {
                rootFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)eObject));
                allGraphicalContainers = this.getAllGraphicalContainers((DDiagram)current);
            }
            if (current instanceof DNodeContainer) {
                rootFunction = (AbstractFunction)((DNodeContainer)current).getTarget();
                allGraphicalContainers = this.getAllGraphicalContainers((DNodeContainer)current);
                ownedNodes.addAll(((DNodeContainer)current).getNodes());
                ownedNodes.removeAll((Collection<?>)((DNodeContainer)current).getOwnedBorderedNodes());
            }
        }
        returnedFunctions.addAll((Collection)ModelCache.getCache(FunctionExt::getAllAbstractFunctions, rootFunction));
        returnedFunctions.removeAll(ownedNodes);
        if (allGraphicalContainers != null) {
            for (DDiagramElementContainer dDiagramElementContainer : allGraphicalContainers) {
                ArrayList<AbstractFunction> toBeRemoved = new ArrayList<AbstractFunction>();
                if (dDiagramElementContainer.getTarget() instanceof AbstractFunction) {
                    returnedFunctions.remove(dDiagramElementContainer.getTarget());
                    for (AbstractFunction anAbstractFunction : returnedFunctions) {
                        if (!EcoreUtil.isAncestor((EObject)anAbstractFunction, (EObject)dDiagramElementContainer.getTarget())) continue;
                        toBeRemoved.add(anAbstractFunction);
                    }
                }
                EList ownedBorderedNodes = dDiagramElementContainer.getOwnedBorderedNodes();
                for (DNode aNode : dDiagramElementContainer.getNodes()) {
                    if (!(aNode.getTarget() instanceof AbstractFunction) || ownedBorderedNodes.contains(aNode)) continue;
                    returnedFunctions.remove(aNode.getTarget());
                    for (AbstractFunction anAbstractFunction : returnedFunctions) {
                        if (!EcoreUtil.isAncestor((EObject)anAbstractFunction, (EObject)aNode.getTarget())) continue;
                        toBeRemoved.add(anAbstractFunction);
                    }
                }
                returnedFunctions.removeAll(toBeRemoved);
                toBeRemoved = null;
            }
        }
        return returnedFunctions;
    }

    public List<EObject> getAvailableGeneralizationToInsert(EObject context) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (context instanceof AbstractDNode) {
            AbstractDNode currentContainer = (AbstractDNode)context;
            DDiagram currentDiagram = this.getDiagramContainer((EObject)currentContainer);
            ArrayList<EObject> elementsIndiagram = new ArrayList<EObject>();
            for (AbstractDNode aContainer : currentDiagram.getContainers()) {
                elementsIndiagram.add(aContainer.getTarget());
            }
            for (AbstractDNode aContainer : currentDiagram.getNodes()) {
                elementsIndiagram.add(aContainer.getTarget());
            }
            if (currentContainer.getTarget() instanceof GeneralizableElement) {
                GeneralizableElement target = (GeneralizableElement)currentContainer.getTarget();
                for (Generalization aGeneralization : target.getSuperGeneralizations()) {
                    result.add((EObject)aGeneralization);
                }
                for (Generalization aGeneralization : target.getSubGeneralizations()) {
                    result.add((EObject)aGeneralization);
                }
            }
            for (DEdge anEdge : currentDiagram.getEdges()) {
                if (!result.contains(anEdge.getTarget())) continue;
                result.remove(anEdge.getTarget());
            }
        }
        return result;
    }

    public List<AbstractFunction> getAvailableOperationalActivities(OperationalActivity context) {
        return this.getAvailableFunctionsInDataFlowBlank((AbstractFunction)context);
    }

    public List<ActivityNode> getAvailablePins(AbstractFunction context, DDiagram viewPoint, AbstractDNode containerView) {
        ArrayList<ActivityNode> returnedList = new ArrayList<ActivityNode>();
        returnedList.addAll(this.getAllContainedPins(context));
        if (containerView instanceof DNodeContainer) {
            for (DNodeContainer aContainer : FaServices.getFaServices().getOwnedVisibleFunctionContainersInDataFlowBlank((DNodeContainer)containerView, viewPoint)) {
                Iterator returnedIterator = returnedList.iterator();
                if (aContainer.getTarget() == null) continue;
                while (returnedIterator.hasNext()) {
                    ActivityNode node = (ActivityNode)returnedIterator.next();
                    if (!EcoreUtil.isAncestor((EObject)aContainer.getTarget(), (EObject)node)) continue;
                    returnedIterator.remove();
                }
            }
        }
        Iterator returnedIterator = returnedList.iterator();
        while (returnedIterator.hasNext()) {
            EList outgoing;
            ActivityNode pin = (ActivityNode)returnedIterator.next();
            boolean toRemove = true;
            if (pin instanceof FunctionInputPort) {
                EList incoming = ((FunctionInputPort)pin).getIncomingFunctionalExchanges();
                if (incoming != null) {
                    if (incoming.isEmpty()) {
                        toRemove = false;
                    }
                    for (ActivityEdge anActivityEdge : incoming) {
                        if (!(anActivityEdge instanceof FunctionalExchange) || !(anActivityEdge.getSource() instanceof FunctionOutputPort) || EcoreUtil.isAncestor((EObject)context, (EObject)anActivityEdge.getSource().eContainer())) continue;
                        toRemove = false;
                        break;
                    }
                }
            } else if (pin instanceof FunctionOutputPort && (outgoing = ((FunctionOutputPort)pin).getOutgoingFunctionalExchanges()) != null) {
                if (outgoing.isEmpty()) {
                    toRemove = false;
                }
                for (ActivityEdge anActivityEdge : outgoing) {
                    if (!(anActivityEdge instanceof FunctionalExchange) || !(anActivityEdge.getTarget() instanceof FunctionInputPort) || EcoreUtil.isAncestor((EObject)context, (EObject)anActivityEdge.getTarget().eContainer())) continue;
                    toRemove = false;
                    break;
                }
            }
            if (!toRemove) continue;
            returnedIterator.remove();
        }
        return returnedList;
    }

    public boolean areInternalEdgePorts(DSemanticDecorator sourcePort, DSemanticDecorator targetPort) {
        return EcoreUtil.isAncestor((EObject)sourcePort.eContainer(), (EObject)targetPort.eContainer()) || EcoreUtil.isAncestor((EObject)targetPort.eContainer(), (EObject)sourcePort.eContainer());
    }

    public EObject getBestCandidate(EObject eObject, List<?> first, List<?> second) {
        LinkedList first2 = new LinkedList(first);
        first2.retainAll(second);
        if (first2.isEmpty() && eObject instanceof DSemanticDecorator) {
            return ((DSemanticDecorator)eObject).getTarget();
        }
        return first2.isEmpty() ? eObject : (EObject)first2.get(0);
    }

    public EObject getBestGraphicalContainer(EObject eObject, DDiagram diagram, EClass eclass) {
        Hashtable<EObject, DDiagramElement> elementsInDiagram = new Hashtable<EObject, DDiagramElement>();
        for (DDiagramElement aContainer : diagram.getContainers()) {
            if (aContainer == null || aContainer.getTarget() == null || !aContainer.isVisible()) continue;
            elementsInDiagram.put(aContainer.getTarget(), aContainer);
        }
        EObject anObject = eObject;
        while (anObject != null) {
            DDiagramElement container;
            if ((anObject = this.getAncestor(anObject, eclass)) == null || (container = (DDiagramElement)elementsInDiagram.get(anObject)) == null) continue;
            return container;
        }
        return diagram;
    }

    /*
     * Unable to fully structure code
     */
    public EObject getCommonAncestor(EObject e1, EObject e2) {
        contextContainer = e1.eContainer();
        if (EcoreUtil.isAncestor((EObject)e1, (EObject)e2)) {
            return e1;
        }
        if (!EcoreUtil.isAncestor((EObject)e2, (EObject)e1)) ** GOTO lbl7
        return e2;
lbl-1000:
        // 1 sources

        {
            contextContainer = contextContainer.eContainer();
lbl7:
            // 2 sources

            ** while (!EcoreUtil.isAncestor((EObject)contextContainer, (EObject)e2) && contextContainer != null)
        }
lbl8:
        // 1 sources

        return contextContainer;
    }

    public AbstractFunction getCommonFunctionAncestor(EObject e1, EObject e2) {
        EObject contextContainer = this.getCommonAncestor(e1, e2);
        if (contextContainer == null) {
            contextContainer = e1;
        }
        return FaServices.getFaServices().getFunctionContainer(contextContainer);
    }

    public Component getCommonComponentAncestor(EObject e1, Component c1, Component c2) {
        return ComponentExt.getCommonComponentAncestor((Component)c1, (Component)c2);
    }

    public Component getComponentContainer(EObject object) {
        EObject container = object;
        while (container != null && !(container instanceof Component) && !(container instanceof ModellingArchitecture)) {
            container = container.eContainer();
        }
        if (container instanceof Component) {
            return (Component)container;
        }
        if (container instanceof SystemAnalysis || container instanceof LogicalArchitecture || container instanceof PhysicalArchitecture || container instanceof EPBSArchitecture) {
            return ((BlockArchitecture)container).getSystem();
        }
        return null;
    }

    private List<Pin> getContainedPins(AbstractFunction function) {
        LinkedList<Pin> result = new LinkedList<Pin>();
        result.addAll((Collection<Pin>)function.getInputs());
        result.addAll((Collection<Pin>)function.getOutputs());
        return result;
    }

    public EList<EObject> getDepleyedElements(PhysicalComponent context, DDiagram viewPoint, DNodeContainer containerView) {
        EList activatedLayers = viewPoint.getActivatedLayers();
        boolean hasActivatedLayer = false;
        for (Layer layer : activatedLayers) {
            if (!layer.getName().equalsIgnoreCase("Sub Components")) continue;
            hasActivatedLayer = true;
        }
        BasicEList deployedElements = new BasicEList();
        BasicEList containerViewdeployedElements = new BasicEList();
        if (!hasActivatedLayer) {
            this.getInDepthDeployedElements(context, (EList<EObject>)deployedElements);
        } else {
            this.getInDepthDeployedElements(context, (EList<EObject>)deployedElements);
            if (containerView != null) {
                EList ownedDiagramElements = containerView.getOwnedDiagramElements();
                for (DDiagramElement diagramElement : ownedDiagramElements) {
                    AbstractDNode abstractNode;
                    EObject target;
                    if (!(diagramElement instanceof AbstractDNode) || !((target = (abstractNode = (AbstractDNode)diagramElement).getTarget()) instanceof PhysicalComponent)) continue;
                    this.getInDepthDeployedElements((PhysicalComponent)target, (EList<EObject>)containerViewdeployedElements);
                }
            }
        }
        deployedElements.removeAll((Collection)containerViewdeployedElements);
        return deployedElements;
    }

    public DDiagram getDiagramContainer(EObject current) {
        DDiagram parent = DiagramHelper.getService().getDiagramContainer(current);
        if (parent == null) {
            EObject target = current;
            if (current instanceof DSemanticDecorator && ((DSemanticDecorator)current).getTarget() != null) {
                target = ((DSemanticDecorator)current).getTarget();
                Object oDiagram = CsServices.getService().getInterpreterVariable(target, "diagram");
                if (oDiagram instanceof DDiagram) {
                    return (DDiagram)oDiagram;
                }
            }
        }
        return parent;
    }

    public boolean isOrIsChildFunction(AbstractFunction child, EObject parent) {
        AbstractFunction childContainer = child;
        while (childContainer instanceof AbstractFunction) {
            if (childContainer.equals(parent)) {
                return true;
            }
            childContainer = childContainer.eContainer();
        }
        return false;
    }

    public Collection<EObject> getPhysicalLinkSemanticElements(DEdge view) {
        LinkedHashSet<EObject> semanticElements = new LinkedHashSet<EObject>();
        EObject target = view.getTarget();
        semanticElements.add(target);
        if (target instanceof PhysicalLink) {
            semanticElements.addAll(this.getDisplayedInvolvingPhysicalPaths(view));
        }
        return semanticElements;
    }

    public Collection<PhysicalPath> getDisplayedInvolvingPhysicalPaths(DEdge view) {
        ArrayList<PhysicalPath> displayedInvolvingPhysicalPaths = new ArrayList<PhysicalPath>();
        EObject target = view.getTarget();
        if (target instanceof PhysicalLink) {
            PhysicalLink targetPL = (PhysicalLink)target;
            DDiagram diagram = view.getParentDiagram();
            Map displayedPhysicalPaths = (Map)getDisplayedPhysicalPathAndNodes.get((Object)diagram);
            displayedInvolvingPhysicalPaths.addAll((Collection)getInvolvingPhysicalPaths.get((Object)targetPL));
            displayedInvolvingPhysicalPaths.retainAll(displayedPhysicalPaths.keySet());
        }
        return displayedInvolvingPhysicalPaths;
    }

    public Collection<EObject> getFunctionalExchangeSemanticElements(DEdge view) {
        LinkedHashSet<EObject> semanticElements = new LinkedHashSet<EObject>();
        EObject target = view.getTarget();
        semanticElements.add(target);
        if (target instanceof FunctionalExchange) {
            semanticElements.addAll(this.getDisplayedInvolvingFunctionalChains(view));
        }
        return semanticElements;
    }

    public Collection<FunctionalChain> getDisplayedInvolvingFunctionalChains(DEdge view) {
        ArrayList<FunctionalChain> displayedInvolvingFunctionalChains = new ArrayList<FunctionalChain>();
        EObject target = view.getTarget();
        if (target instanceof FunctionalExchange) {
            FunctionalExchange targetFE = (FunctionalExchange)target;
            DDiagram diagram = view.getParentDiagram();
            Map displayedFunctionalChains = (Map)getDisplayedFunctionalChainAndNodes.get((Object)diagram);
            displayedInvolvingFunctionalChains.addAll((Collection<FunctionalChain>)targetFE.getInvolvingFunctionalChains());
            displayedInvolvingFunctionalChains.retainAll(displayedFunctionalChains.keySet());
        }
        return displayedInvolvingFunctionalChains;
    }

    public Set<EObject> getEdgeExchangeCategorySemanticElements(ExchangeCategory context, DEdge view) {
        LinkedHashSet<EObject> returnedList = new LinkedHashSet<EObject>();
        returnedList.add((EObject)context);
        EObject targetViewFunction = ((DSemanticDecorator)view.getTargetNode().eContainer()).getTarget();
        EObject sourceViewFunction = ((DSemanticDecorator)view.getSourceNode().eContainer()).getTarget();
        for (FunctionalExchange anExchange : context.getExchanges()) {
            AbstractFunction sourceContainer = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)anExchange);
            AbstractFunction targetContainer = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)anExchange);
            if (!this.isOrIsChildFunction(sourceContainer, sourceViewFunction) || !this.isOrIsChildFunction(targetContainer, targetViewFunction)) continue;
            returnedList.add((EObject)anExchange);
        }
        return returnedList;
    }

    public Set<EObject> getEdgeExchangeCategorySemanticElements(ComponentExchangeCategory context, DEdge view) {
        LinkedHashSet<EObject> returnedList = new LinkedHashSet<EObject>();
        returnedList.add((EObject)context);
        EObject sourceViewComponent = CsServices.getService().getComponentType((DSemanticDecorator)view.getSourceNode().eContainer());
        EObject targetViewComponent = CsServices.getService().getComponentType((DSemanticDecorator)view.getTargetNode().eContainer());
        for (ComponentExchange exchange : context.getExchanges()) {
            Component sourceComponent = ComponentExchangeExt.getSourceComponent((ComponentExchange)exchange);
            Component targetComponent = ComponentExchangeExt.getTargetComponent((ComponentExchange)exchange);
            if (sourceComponent.equals(sourceViewComponent) && targetComponent.equals(targetViewComponent)) {
                returnedList.add((EObject)exchange);
                continue;
            }
            if (!targetComponent.equals(sourceViewComponent) || !sourceComponent.equals(targetViewComponent)) continue;
            returnedList.add((EObject)exchange);
        }
        return returnedList;
    }

    public Set<EObject> getEdgeExchangeCategorySemanticElements(PhysicalLinkCategory context, DEdge view) {
        LinkedHashSet<EObject> returnedList = new LinkedHashSet<EObject>();
        returnedList.add((EObject)context);
        EObject sourceViewComponent = CsServices.getService().getComponentType((DSemanticDecorator)view.getSourceNode().eContainer());
        EObject targetViewComponent = CsServices.getService().getComponentType((DSemanticDecorator)view.getTargetNode().eContainer());
        for (PhysicalLink link : context.getLinks()) {
            Component sourceComponent = PhysicalLinkExt.getSourceComponent((PhysicalLink)link);
            Component targetComponent = PhysicalLinkExt.getTargetComponent((PhysicalLink)link);
            if (sourceComponent.equals(sourceViewComponent) && targetComponent.equals(targetViewComponent)) {
                returnedList.add((EObject)link);
                continue;
            }
            if (!targetComponent.equals(sourceViewComponent) || !sourceComponent.equals(targetViewComponent)) continue;
            returnedList.add((EObject)link);
        }
        return returnedList;
    }

    public List<EObject> getEmptyList(EObject context) {
        return new ArrayList<EObject>();
    }

    public String getEObjectLabelProviderHelper(EObject context) {
        return EObjectExt.getText((EObject)context);
    }

    public List<EObject> getExistingAssociationFromDiagram(EObject context) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (context instanceof AbstractDNode) {
            AbstractDNode currentContainer = (AbstractDNode)context;
            DDiagram currentDiagram = this.getDiagramContainer((EObject)currentContainer);
            for (DEdge anEdge : currentDiagram.getEdges()) {
                if (!(anEdge.getTarget() instanceof Association) || !anEdge.getSourceNode().equals(context) && !anEdge.getTargetNode().equals(context)) continue;
                result.add(anEdge.getTarget());
            }
        }
        return result;
    }

    public List<EObject> getExistingConstraintsFromDiagram(EObject context, DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (diagram == null || context == null) {
            return result;
        }
        for (DNode aNode : DiagramServices.getDiagramServices().getAllNodes((EObject)diagram)) {
            EObject target = aNode.getTarget();
            if (!(target instanceof Constraint)) continue;
            if (context instanceof DDiagramElement) {
                EObject target2 = ((DSemanticDecorator)context).getTarget();
                if (target2 == null || !((Constraint)target).getConstrainedElements().contains((Object)target2)) continue;
                result.add(target);
                continue;
            }
            if (!(context instanceof DDiagram)) continue;
            result.add(target);
        }
        return result;
    }

    public ECrossReferenceAdapter getExistingCrossReferenceAdapter(Notifier notifier) {
        return ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)notifier);
    }

    public List<EObject> getExistingExchangeItemElementFromDiagram(EObject context) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (context instanceof AbstractDNode) {
            AbstractDNode currentContainer = (AbstractDNode)context;
            DDiagram currentDiagram = this.getDiagramContainer((EObject)currentContainer);
            for (DEdge anEdge : currentDiagram.getEdges()) {
                if (!(anEdge.getTarget() instanceof ExchangeItemElement) || !anEdge.getSourceNode().equals(context) && !anEdge.getTargetNode().equals(context)) continue;
                result.add(anEdge.getTarget());
            }
        }
        return result;
    }

    public List<EObject> getExistingGeneralizationFromDiagram(EObject context) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (context instanceof AbstractDNode) {
            AbstractDNode currentContainer = (AbstractDNode)context;
            DDiagram currentDiagram = this.getDiagramContainer((EObject)currentContainer);
            for (DEdge anEdge : currentDiagram.getEdges()) {
                if (!(anEdge.getTarget() instanceof Generalization) || !anEdge.getSourceNode().equals(context) && !anEdge.getTargetNode().equals(context)) continue;
                result.add(anEdge.getTarget());
            }
        }
        return result;
    }

    public Collection<FunctionalChain> getFunctionalChain(AbstractFunction context) {
        ArrayList<FunctionalChain> result = new ArrayList<FunctionalChain>();
        result.addAll((Collection<FunctionalChain>)context.getOwnedFunctionalChains());
        TreeIterator allContents = context.eAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!(next instanceof AbstractFunction)) continue;
            AbstractFunction function = (AbstractFunction)next;
            result.addAll((Collection<FunctionalChain>)function.getOwnedFunctionalChains());
        }
        return result;
    }

    public List<DEdge> getIncomingEdges(EdgeTarget containerView) {
        ArrayList<DEdge> returnedList = new ArrayList<DEdge>();
        DDiagram currentDiagram = this.getDiagramContainer((EObject)containerView);
        EList allEgdesInDiagram = currentDiagram.getEdges();
        for (DEdge anEdge : containerView.getIncomingEdges()) {
            if (!allEgdesInDiagram.contains(anEdge)) continue;
            returnedList.add(anEdge);
        }
        return returnedList;
    }

    private void getInDepthDeployedElements(PhysicalComponent context, EList<EObject> deployedElements) {
        EList ownedDeployments = context.getOwnedDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : ownedDeployments) {
            DeployableElement deployedElement = abstractDeployment.getDeployedElement();
            if (deployedElement == null) continue;
            deployedElements.add((Object)deployedElement);
        }
        List<Component> allDescendants = this.getAllDescendants((Component)context);
        for (Component partitionableElement : allDescendants) {
            if (!(partitionableElement instanceof PhysicalComponent)) continue;
            for (AbstractDeploymentLink abstractDeployment : ((PhysicalComponent)partitionableElement).getOwnedDeploymentLinks()) {
                DeployableElement deployedElement = abstractDeployment.getDeployedElement();
                if (deployedElement == null) continue;
                deployedElements.add((Object)deployedElement);
            }
        }
    }

    private void getInDepthTargetElements(PhysicalComponent context, EList<EObject> functionalAllocations) {
        EList functionAllocations = context.getOwnedFunctionalAllocation();
        for (ComponentFunctionalAllocation functionAllocation : functionAllocations) {
            TraceableElement traceableElement = functionAllocation.getTargetElement();
            if (traceableElement == null) continue;
            functionalAllocations.add((Object)traceableElement);
        }
        List<Component> allDescendants = this.getAllDescendants((Component)context);
        for (Component partitionableElement : allDescendants) {
            if (!(partitionableElement instanceof PhysicalComponent)) continue;
            for (ComponentFunctionalAllocation abstractDeployment : ((PhysicalComponent)partitionableElement).getOwnedFunctionalAllocation()) {
                TraceableElement traceableElement = abstractDeployment.getTargetElement();
                if (traceableElement == null) continue;
                functionalAllocations.add((Object)traceableElement);
            }
        }
    }

    public List<EObject> getInputPinCategorySemanticElements(EObject context, DSemanticDecorator view) {
        ArrayList<EObject> returnedList = new ArrayList<EObject>();
        if (context instanceof ExchangeCategory) {
            returnedList.add(context);
            ExchangeCategory currentCategory = (ExchangeCategory)context;
            EObject container = ((DSemanticDecorator)view.eContainer()).getTarget();
            for (FunctionalExchange anExchange : currentCategory.getExchanges()) {
                if (!this.isOrIsChildFunction(FunctionalExchangeExt.getTargetFunction((FunctionalExchange)anExchange), container) || returnedList.contains(anExchange)) continue;
                returnedList.add((EObject)anExchange);
            }
        }
        return returnedList;
    }

    public Collection<?> getIntersection(EObject eObject, Collection<?> first, Collection<?> second) {
        if (first == null) {
            first = Collections.emptyList();
        }
        LinkedList firstCopy = new LinkedList(first);
        firstCopy.retainAll(second);
        return firstCopy;
    }

    public Collection<EObject> getInverseReferences(EObject object, EReference reference) {
        ECrossReferenceAdapter crossReferenceAdapter = this.getExistingCrossReferenceAdapter((Notifier)object);
        if (crossReferenceAdapter != null) {
            Collection allInverseReferences = crossReferenceAdapter.getInverseReferences(object, true);
            HashSet<EObject> inverseReferences = new HashSet<EObject>();
            for (EStructuralFeature.Setting setting : allInverseReferences) {
                if (setting.getEStructuralFeature() != reference) continue;
                inverseReferences.add(setting.getEObject());
            }
            return inverseReferences;
        }
        return Collections.emptyList();
    }

    static LinkedList<AbstractFunction> getLeaves(AbstractFunction function) {
        LinkedList<AbstractFunction> subFunctions = new LinkedList<AbstractFunction>();
        for (AbstractFunction func : function.getSubFunctions()) {
            if (AbstractFunctionExt.isLeaf((AbstractFunction)func)) {
                subFunctions.add(func);
                continue;
            }
            subFunctions.addAll(CapellaServices.getLeaves(func));
        }
        return subFunctions;
    }

    public List<Component> getLogicalParent(EObject context, Component aComponent) {
        return ComponentExt.getDirectParents((Component)aComponent);
    }

    public List<Component> getLogicalParent(Component aComponent) {
        return ComponentExt.getDirectParents((Component)aComponent);
    }

    public List<DEdge> getOutgoingEdges(EdgeTarget containerView) {
        ArrayList<DEdge> returnedList = new ArrayList<DEdge>();
        DDiagram currentDiagram = this.getDiagramContainer((EObject)containerView);
        EList allEgdesInDiagram = currentDiagram.getEdges();
        for (DEdge anEdge : containerView.getOutgoingEdges()) {
            if (!allEgdesInDiagram.contains(anEdge)) continue;
            returnedList.add(anEdge);
        }
        return returnedList;
    }

    public List<EObject> getOutputPinCategorySemanticElements(EObject context, DSemanticDecorator view) {
        ArrayList<EObject> returnedList = new ArrayList<EObject>();
        if (context instanceof ExchangeCategory) {
            returnedList.add(context);
            ExchangeCategory currentCategory = (ExchangeCategory)context;
            EObject container = ((DSemanticDecorator)view.eContainer()).getTarget();
            for (FunctionalExchange anExchange : currentCategory.getExchanges()) {
                if (!this.isOrIsChildFunction(FunctionalExchangeExt.getSourceFunction((FunctionalExchange)anExchange), container) || returnedList.contains(anExchange)) continue;
                returnedList.add((EObject)anExchange);
            }
        }
        return returnedList;
    }

    EObject getParent(EObject object, EClass clazz) {
        EObject currentObject = object;
        while (currentObject != null) {
            if (currentObject.eClass().equals(clazz) || currentObject.eClass().getEAllSuperTypes().contains((Object)clazz)) {
                return currentObject;
            }
            currentObject = currentObject.eContainer();
        }
        return null;
    }

    public Set<DDiagramElement> getSetOfDiagramElements(DDiagram diagram) {
        return DiagramServices.getDiagramServices().getSetOfDiagramElements(diagram);
    }

    public Set<EObject> getPinCategorySemanticElements(ComponentExchangeCategory context, DSemanticDecorator view) {
        HashSet<EObject> returnedList = new HashSet<EObject>();
        returnedList.add((EObject)context);
        EObject viewComponent = CsServices.getService().getComponentType((DSemanticDecorator)view.eContainer());
        for (ComponentExchange exchange : context.getExchanges()) {
            Component sourceComponent = ComponentExchangeExt.getSourceComponent((ComponentExchange)exchange);
            Component targetComponent = ComponentExchangeExt.getTargetComponent((ComponentExchange)exchange);
            if (!sourceComponent.equals(viewComponent) && !targetComponent.equals(viewComponent)) continue;
            returnedList.add((EObject)exchange);
        }
        return returnedList;
    }

    public Set<EObject> getPinCategorySemanticElements(PhysicalLinkCategory context, DSemanticDecorator view) {
        HashSet<EObject> returnedList = new HashSet<EObject>();
        returnedList.add((EObject)context);
        EObject viewComponent = CsServices.getService().getComponentType((DSemanticDecorator)view.eContainer());
        for (PhysicalLink link : context.getLinks()) {
            Component sourceComponent = PhysicalLinkExt.getSourceComponent((PhysicalLink)link);
            Component targetComponent = PhysicalLinkExt.getTargetComponent((PhysicalLink)link);
            if (!sourceComponent.equals(viewComponent) && !targetComponent.equals(viewComponent)) continue;
            returnedList.add((EObject)link);
        }
        return returnedList;
    }

    public Set<ExchangeCategory> getShowableCategories(EObject eObject, List<ExchangeCategory> categories, List<DEdge> exchangesView) {
        HashSet<ExchangeCategory> showableCategory = new HashSet<ExchangeCategory>();
        for (DEdge edge : exchangesView) {
            FunctionalExchange target;
            if (edge.getTarget() instanceof FunctionalExchange) {
                target = (FunctionalExchange)edge.getTarget();
                showableCategory.addAll((Collection<ExchangeCategory>)target.getCategories());
                continue;
            }
            if (!(edge.getTarget() instanceof ExchangeCategory)) continue;
            target = (ExchangeCategory)edge.getTarget();
            for (FunctionalExchange exchange : target.getExchanges()) {
                showableCategory.addAll((Collection<ExchangeCategory>)exchange.getCategories());
            }
        }
        return showableCategory;
    }

    public Collection<GeneralizableElement> getSuperClassifiers(GeneralizableElement aClassifier) {
        ArrayList<GeneralizableElement> superClassifiers = new ArrayList<GeneralizableElement>();
        superClassifiers.add(aClassifier);
        for (Generalization aGeneralization : aClassifier.getSuperGeneralizations()) {
            superClassifiers.addAll(this.getSuperClassifiers(aGeneralization.getSuper()));
        }
        return superClassifiers;
    }

    public Collection<GeneralizableElement> getSuperClassifiers(GeneralizableElement aClassifier, Generalization generalization) {
        ArrayList<GeneralizableElement> superClassifiers = new ArrayList<GeneralizableElement>();
        superClassifiers.add(aClassifier);
        for (Generalization aGeneralization : aClassifier.getSuperGeneralizations()) {
            if (aGeneralization.equals(generalization)) continue;
            superClassifiers.addAll(this.getSuperClassifiers(aGeneralization.getSuper()));
        }
        return superClassifiers;
    }

    public Collection<GeneralizableElement> getSubClassifiers(GeneralizableElement aClassifier) {
        ArrayList<GeneralizableElement> superClassifiers = new ArrayList<GeneralizableElement>();
        superClassifiers.add(aClassifier);
        for (Generalization aGeneralization : aClassifier.getSubGeneralizations()) {
            superClassifiers.addAll(this.getSubClassifiers(aGeneralization.getSub()));
        }
        return superClassifiers;
    }

    public Collection<GeneralizableElement> getSubClassifiers(GeneralizableElement aClassifier, Generalization generalization) {
        ArrayList<GeneralizableElement> superClassifiers = new ArrayList<GeneralizableElement>();
        superClassifiers.add(aClassifier);
        for (Generalization aGeneralization : aClassifier.getSubGeneralizations()) {
            if (aGeneralization.equals(generalization)) continue;
            superClassifiers.addAll(this.getSubClassifiers(aGeneralization.getSub()));
        }
        return superClassifiers;
    }

    public EList<EObject> getTargetElements(PhysicalComponent context, DDiagram viewPoint, DNodeContainer containerView) {
        EList activatedLayers = viewPoint.getActivatedLayers();
        boolean hasActivatedLayer = false;
        for (Layer layer : activatedLayers) {
            if (!layer.getName().equalsIgnoreCase("Sub Components")) continue;
            hasActivatedLayer = true;
        }
        BasicEList functionalAllocations = new BasicEList();
        BasicEList containerfunctionalAllocations = new BasicEList();
        if (!hasActivatedLayer) {
            this.getInDepthTargetElements(context, (EList<EObject>)functionalAllocations);
        } else {
            this.getInDepthTargetElements(context, (EList<EObject>)functionalAllocations);
            if (containerView != null) {
                EList ownedDiagramElements = containerView.getOwnedDiagramElements();
                for (DDiagramElement diagramElement : ownedDiagramElements) {
                    AbstractDNode abstractNode;
                    EObject target;
                    if (!(diagramElement instanceof AbstractDNode) || !((target = (abstractNode = (AbstractDNode)diagramElement).getTarget()) instanceof PhysicalComponent)) continue;
                    this.getInDepthTargetElements((PhysicalComponent)target, (EList<EObject>)containerfunctionalAllocations);
                }
            }
        }
        functionalAllocations.removeAll((Collection)containerfunctionalAllocations);
        return functionalAllocations;
    }

    public String getUniqueName(AbstractNamedElement namedElement) {
        return EcoreUtil2.getUniqueName((EObject)namedElement, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)namedElement.eClass().getName(), (boolean)false, (boolean)false);
    }

    public String getUniqueName(AbstractNamedElement namedElement, boolean space) {
        return EcoreUtil2.getUniqueName((EObject)namedElement, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)namedElement.eClass().getName(), (boolean)space, (boolean)false);
    }

    public String getUniqueName(AbstractNamedElement namedElement, String prefix) {
        return EcoreUtil2.getUniqueName((EObject)namedElement, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)prefix, (boolean)true, (boolean)false);
    }

    @Deprecated
    public DDiagram getViewDiagram(EObject object) {
        if (object instanceof DDiagramElement) {
            return ((DDiagramElement)object).getParentDiagram();
        }
        if (object instanceof DDiagram) {
            return (DDiagram)object;
        }
        return null;
    }

    public List<DSemanticDecorator> getVisibles(List<DSemanticDecorator> decorators) {
        LinkedList<DSemanticDecorator> visibles = new LinkedList<DSemanticDecorator>(decorators);
        for (DSemanticDecorator dec : decorators) {
            if (!(dec instanceof DDiagramElement) || this.isVisibleInDiagram((EObject)dec)) continue;
            visibles.remove(dec);
        }
        return visibles;
    }

    public boolean isAllocatedInActor(AbstractFunction context) {
        EList allocationBlocks = context.getAllocationBlocks();
        for (AbstractFunctionalBlock abstractFunctionalBlock : allocationBlocks) {
            Component component;
            if (!(abstractFunctionalBlock instanceof Component) || !(component = (Component)abstractFunctionalBlock).isActor()) continue;
            return true;
        }
        return false;
    }

    public EObject hide(DDiagramElement context) {
        HideFilterHelper.INSTANCE.hide(context);
        return context;
    }

    public boolean isABorderedNode(AbstractDNode node) {
        return DiagramServices.getDiagramServices().isABorderedNode(node);
    }

    public boolean isAllocatedFunction(EObject eObject, AbstractFunction function, EObject container) {
        LinkedList<AbstractFunction> allocatedFunctions = new LinkedList<AbstractFunction>();
        if (container instanceof Component) {
            Component component = (Component)container;
            allocatedFunctions.addAll((Collection<AbstractFunction>)component.getAllocatedFunctions());
            for (Component subComponent : (List)ModelCache.getCache(ComponentExt::getAllSubUsedAndDeployedComponents, (Object)component)) {
                allocatedFunctions.addAll((Collection<AbstractFunction>)subComponent.getAllocatedFunctions());
            }
        }
        return this.isAllocatedFunctionCommon(function, container, allocatedFunctions);
    }

    public boolean isAllocatedFunction(AbstractFunction function, EObject container, DSemanticDecorator containerView) {
        if (!(containerView instanceof DNodeContainer)) {
            return false;
        }
        EObject containerTarget = function instanceof OperationalActivity ? container : CsServices.getService().getComponentType(container);
        Set allocationObjects = AbstractFunctionExt.getAllocationBlocks((Object)function).stream().filter(EObject.class::isInstance).map(EObject.class::cast).collect(Collectors.toSet());
        if (allocationObjects.contains(containerTarget)) {
            return true;
        }
        for (EObject allocationObject : allocationObjects) {
            if (!DiagramServices.getDiagramServices().isIndirectlyOnDiagram((DNodeContainer)containerView, allocationObject)) continue;
            return false;
        }
        HashSet subComponents = new HashSet();
        if (container instanceof Component) {
            subComponents.addAll(ComponentExt.getSubUsedAndDeployedComponents((Component)((Component)container)));
            if (container instanceof Entity) {
                subComponents.addAll(((Entity)container).getAllocatedRoles());
            }
        } else if (container instanceof Part) {
            subComponents.addAll(PartExt.getSubUsedAndDeployedComponentsOfPart((Part)((Part)container)));
        }
        if (!Collections.disjoint(subComponents, allocationObjects)) {
            return true;
        }
        for (EObject subComponent : subComponents) {
            boolean isOnDiagram = DiagramServices.getDiagramServices().isIndirectlyOnDiagram((DNodeContainer)containerView, subComponent);
            if (isOnDiagram || !this.isAllocatedFunction(function, subComponent, containerView)) continue;
            return true;
        }
        EList subFunctions = function.getSubFunctions();
        if (subFunctions.isEmpty()) {
            return false;
        }
        for (AbstractFunction subFunction : subFunctions) {
            if (this.isAllocatedFunction(subFunction, container, containerView)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAllocatedFunctionCommon(AbstractFunction function, EObject container, LinkedList<AbstractFunction> allocatedFunctions) {
        boolean result = false;
        if (container instanceof Role) {
            Role role = (Role)container;
            for (ActivityAllocation alloc : role.getOwnedActivityAllocations()) {
                if (!(alloc.getTargetElement() instanceof AbstractFunction)) continue;
                AbstractFunction alfunc = (AbstractFunction)alloc.getTargetElement();
                allocatedFunctions.add(alfunc);
            }
        }
        if (allocatedFunctions.contains(function)) {
            result = true;
        } else if (!FunctionExt.isLeaf((AbstractFunction)function)) {
            LinkedList<AbstractFunction> leaves = CapellaServices.getLeaves(function);
            LinkedList<AbstractFunction> allocatedLeaves = new LinkedList<AbstractFunction>(leaves);
            allocatedLeaves.retainAll(allocatedFunctions);
            if (allocatedLeaves.size() == leaves.size()) {
                result = true;
            }
        }
        return result;
    }

    public boolean isAllocatedInThisComponent(AbstractFunction function, EObject container) {
        if (AbstractFunctionExt.isLeaf((AbstractFunction)function)) {
            List allocatingComponent = (List)ModelCache.getCache(AbstractFunctionExt::getAllocatingComponents, (Object)function);
            if (allocatingComponent.size() != 1 || allocatingComponent.get(0) != container) {
                return false;
            }
        } else {
            List allLeaves = (List)ModelCache.getCache(FunctionExt::getAllLeafAbstractFunctions, (Object)function);
            for (AbstractFunction leaf : allLeaves) {
                List allocatingComponent = (List)ModelCache.getCache(AbstractFunctionExt::getAllocatingComponents, (Object)leaf);
                if (allocatingComponent.size() == 1 && allocatingComponent.get(0) == container) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDashedFunction(AbstractFunction function, Component container) {
        if (AbstractFunctionExt.isLeaf((AbstractFunction)function)) {
            List allocatingComponents = (List)ModelCache.getCache(AbstractFunctionExt::getAllocatingComponents, (Object)function);
            if (!allocatingComponents.isEmpty()) {
                return allocatingComponents.stream().allMatch(comp -> comp != container);
            }
        } else {
            List allLeaves = (List)ModelCache.getCache(FunctionExt::getAllLeafAbstractFunctions, (Object)function);
            List subComponents = (List)ModelCache.getCache(ComponentExt::getAllSubUsedAndDeployedComponents, (Object)container);
            for (AbstractFunction leaf : allLeaves) {
                List allocatingComponents = (List)ModelCache.getCache(AbstractFunctionExt::getAllocatingComponents, (Object)leaf);
                if (!allocatingComponents.stream().noneMatch(comp -> comp != container && subComponents.contains(comp))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isAllocatedFunctionOnParentContainers(EObject context) {
        boolean flag = true;
        EObject context2 = context;
        if (context2 instanceof AbstractDNode) {
            EObject container = context2.eContainer();
            if (container != null) {
                TreeIterator allContents = container.eAllContents();
                block0: while (allContents.hasNext()) {
                    EObject next = (EObject)allContents.next();
                    if (!(next instanceof DNodeContainer)) continue;
                    DNodeContainer dnc = (DNodeContainer)next;
                    EList ownedDiagramElements = dnc.getOwnedDiagramElements();
                    for (DDiagramElement diagramElement : ownedDiagramElements) {
                        if (!(diagramElement instanceof DNode) || !((DNode)diagramElement).getTarget().equals(((AbstractDNode)context2).getTarget())) continue;
                        flag = false;
                        continue block0;
                    }
                }
            } else {
                return false;
            }
            if (flag) {
                return true;
            }
            DDiagram dDiagram = this.getDiagramContainer(context2);
            if (dDiagram != null) {
                EList activatedLayers = dDiagram.getActivatedLayers();
                for (Layer layer : activatedLayers) {
                    if (!layer.getName().equalsIgnoreCase("Sub Components")) continue;
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isChild(EObject current, EObject mayBeChild) {
        child = mayBeChild;
        if (child != null) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if (child.eContainer().equals(current)) {
                return true;
            }
            child = child.eContainer();
lbl7:
            // 2 sources

            ** while (child.eContainer() != null)
        }
lbl8:
        // 1 sources

        return false;
    }

    public boolean isEPBSContext(ModelElement scenario) {
        ModellingArchitecture archi = (ModellingArchitecture)this.getAncestor((EObject)scenario, CapellacorePackage.Literals.MODELLING_ARCHITECTURE);
        return archi instanceof EPBSArchitecture;
    }

    public boolean isGeneralizable(EObject context, EObject source, EObject target) {
        if (source instanceof Class && target instanceof Class && ((Class)source).isIsPrimitive() && !((Class)target).isIsPrimitive()) {
            return false;
        }
        if (source instanceof Class && target instanceof Class && !((Class)source).isIsPrimitive() && ((Class)target).isIsPrimitive()) {
            return false;
        }
        if (source instanceof PhysicalQuantity && target instanceof NumericType) {
            return true;
        }
        if (source instanceof PhysicalQuantity && target instanceof NumericType || source instanceof Component && target instanceof Component || source instanceof GeneralizableElement && target instanceof GeneralizableElement && source.eClass().equals(target.eClass())) {
            GeneralizableElement targetClass = (GeneralizableElement)target;
            GeneralizableElement sourceClass = (GeneralizableElement)source;
            if (!this.isMultipleInheritanceAllowed()) {
                if (!this.getSuperClassifiers(sourceClass).contains(targetClass) && !this.getSuperClassifiers(targetClass).contains(sourceClass)) {
                    if (this.getSuperClassifiers(sourceClass).size() == 1) {
                        return true;
                    }
                    if (context instanceof Generalization) {
                        return true;
                    }
                }
            } else {
                if (source instanceof Component) {
                    Component sourceComp = (Component)source;
                    if (!sourceComp.isActor() && !CapellaModelPreferencesPlugin.getDefault().isComponentNonActorInheritanceAllowed()) {
                        return false;
                    }
                    if (target instanceof Component) {
                        Component targetComp = (Component)target;
                        return targetComp.isActor() == sourceComp.isActor();
                    }
                }
                return !this.getSuperClassifiers(sourceClass).contains(targetClass) && !this.getSuperClassifiers(targetClass).contains(sourceClass);
            }
        }
        return false;
    }

    public boolean isInternalLCForExecution(Execution execution) {
        InstanceRole role = execution.getCovered();
        return this.isInternalLCForInstanceRole(role);
    }

    public boolean isInternalLCForInstanceRole(InstanceRole instanceRole) {
        Scenario scenario = (Scenario)instanceRole.eContainer();
        EObject scenarioContainer = EcoreUtil2.getFirstContainer((EObject)scenario, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
        AbstractInstance instance = instanceRole.getRepresentedInstance();
        EObject container = instance.eContainer();
        while (container != null) {
            if (container == scenarioContainer) {
                return true;
            }
            container = container.eContainer();
        }
        return false;
    }

    public boolean isBehaviorComponent(InstanceRole instanceRole) {
        return this.isComponentNature(instanceRole, PhysicalComponentNature.BEHAVIOR);
    }

    public boolean isNodeComponent(InstanceRole instanceRole) {
        return this.isComponentNature(instanceRole, PhysicalComponentNature.NODE);
    }

    private boolean isComponentNature(InstanceRole instanceRole, PhysicalComponentNature nature) {
        Component instanceRoleComponent;
        BlockArchitecture ownerBlockArchitecture = (BlockArchitecture)this.getAncestor((EObject)instanceRole, CsPackage.Literals.BLOCK_ARCHITECTURE);
        boolean isNodeComponent = ownerBlockArchitecture instanceof PhysicalArchitecture;
        Component component = instanceRoleComponent = instanceRole == null ? null : (Component)instanceRole.getRepresentedInstance().getAbstractType();
        if (instanceRoleComponent instanceof PhysicalComponent) {
            PhysicalComponent sourcePhysicalComponent = (PhysicalComponent)instanceRoleComponent;
            isNodeComponent = isNodeComponent && sourcePhysicalComponent.getNature().equals((Object)nature);
        }
        return isNodeComponent;
    }

    public boolean isLinkedWithInternalControlNode(Pin pin) {
        AbstractFunction container = (AbstractFunction)pin.eContainer();
        if (pin instanceof FunctionInputPort) {
            for (FunctionalExchange exchange : ((FunctionInputPort)pin).getIncomingFunctionalExchanges()) {
                if (!FaServices.getFaServices().isControlNode((EObject)exchange.getSource()) || !this.isChild((EObject)container, (EObject)exchange.getSource())) continue;
                return true;
            }
        }
        if (pin instanceof FunctionOutputPort) {
            for (FunctionalExchange exchange : ((FunctionOutputPort)pin).getOutgoingFunctionalExchanges()) {
                if (!FaServices.getFaServices().isControlNode((EObject)exchange.getTarget()) || !this.isChild((EObject)container, (EObject)exchange.getSource())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMultipleInheritanceAllowed() {
        return CapellaModelPreferencesPlugin.getDefault().isMultipleInheritanceAllowed();
    }

    public boolean isNull(EObject current) {
        return current == null;
    }

    public boolean isOperationalContext(Scenario scenario) {
        return scenario.eContainer() instanceof AbstractCapability && BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario) instanceof OperationalAnalysis;
    }

    public boolean isOperationalContext(AbstractCapability capability) {
        return BlockArchitectureExt.getRootBlockArchitecture((EObject)capability) instanceof OperationalAnalysis;
    }

    public boolean isPrimitiveTypeForAttribute(EObject object) {
        if (!(object instanceof Property)) {
            return false;
        }
        AbstractType type = ((Property)object).getAbstractType();
        if (type == null) {
            return true;
        }
        if (type instanceof Class) {
            Class cl = (Class)type;
            return cl.isIsPrimitive();
        }
        if (type instanceof org.polarsys.capella.core.data.information.Collection) {
            org.polarsys.capella.core.data.information.Collection collection = (org.polarsys.capella.core.data.information.Collection)type;
            return collection.isIsPrimitive();
        }
        return type instanceof DataType;
    }

    public boolean isSynchronized(DDiagram diagram) {
        return diagram.isSynchronized();
    }

    public boolean isTransformedExecution(Execution message) {
        for (AbstractTrace trace : message.getOutgoingTraces()) {
            if (!(trace instanceof RefinementLink)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidActorTarget(EObject context, EObject preSource, EObject preTarget) {
        Mission mis;
        Capability cap;
        EList ownedActInvol;
        if (preSource == null || preTarget == null) {
            return false;
        }
        return preSource instanceof Capability ? !(ownedActInvol = (cap = (Capability)preSource).getOwnedCapabilityInvolvements()).isEmpty() && ownedActInvol.contains((Object)preTarget) : preSource instanceof Mission && !(ownedActInvol = (mis = (Mission)preSource).getOwnedMissionInvolvements()).isEmpty() && ownedActInvol.contains((Object)preTarget);
    }

    public boolean isActorInvolvedWithCapability(EObject context, EObject sourceCapability, EObject involvementTarget) {
        BasicEList involvedActors;
        block4: {
            block3: {
                if (sourceCapability == null || involvementTarget == null) {
                    return false;
                }
                involvedActors = new BasicEList();
                if (!(sourceCapability instanceof CapabilityRealization)) break block3;
                for (CapabilityRealizationInvolvedElement element : ((CapabilityRealization)sourceCapability).getInvolvedComponents()) {
                    Component component;
                    if (!(element instanceof Component) || !ComponentExt.isActor((Component)(component = (Component)element))) continue;
                    involvedActors.add((Object)component);
                }
                break block4;
            }
            if (!(sourceCapability instanceof Capability)) break block4;
            for (SystemComponent component : ((Capability)sourceCapability).getInvolvedSystemComponents()) {
                if (!ComponentExt.isActor((Component)component)) continue;
                involvedActors.add((Object)component);
            }
        }
        return !involvedActors.isEmpty() && involvedActors.contains((Object)involvementTarget);
    }

    public boolean isComponentInvolvedWithCapability(EObject context, EObject sourceCapability, EObject involvementTarget) {
        if (sourceCapability == null || involvementTarget == null) {
            return false;
        }
        if (sourceCapability instanceof CapabilityRealization) {
            return ((CapabilityRealization)sourceCapability).getInvolvedComponents().contains((Object)involvementTarget);
        }
        return false;
    }

    public boolean isVisibleInDiagram(DDiagram diagram, DDiagramElement anElement) {
        return DisplayServiceManager.INSTANCE.getDisplayService().isDisplayed(diagram, anElement);
    }

    public boolean isVisibleInDiagram(EObject current) {
        if (!(current instanceof DDiagramElement)) {
            return false;
        }
        DDiagramElement currentElement = (DDiagramElement)current;
        DDiagram currentDiagram = currentElement.getParentDiagram();
        return DisplayServiceManager.INSTANCE.getDisplayService().isDisplayed(currentDiagram, currentElement);
    }

    public void refreshElement(DRepresentationElement element) {
        if (element != null) {
            DDiagram diagram = this.getDiagramContainer((EObject)element);
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(element.getTarget());
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(element.getTarget());
            DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(interpreter, diagram.getDescription(), accessor);
            diagramSync.setDiagram((DSemanticDiagram)diagram);
            DDiagramElementSynchronizer elementSync = diagramSync.getElementSynchronizer();
            if (element instanceof DEdge) {
                elementSync.refresh((DDiagramElement)((DEdge)element));
            } else if (element instanceof AbstractDNode) {
                elementSync.refresh((DDiagramElement)((AbstractDNode)element));
            }
        }
    }

    public void removeElement(CapellaElement element) {
        if (element != null) {
            ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
            list.add(element);
            this.removeElements(list);
        }
    }

    public void removeElements(Collection<? extends EObject> elements) {
        CapellaDeleteCommand command;
        if (elements != null && !elements.isEmpty() && (command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager(elements), elements, false, false, true)).canExecute()) {
            try {
                command.execute();
            }
            catch (OperationCanceledException oce) {
                throw new OperationCanceledException(RE_THROW_OCE_PREFIX);
            }
        }
    }

    public EObject show(DDiagramElement context) {
        HideFilterHelper.INSTANCE.reveal(context);
        return context;
    }

    public EObject show(Collection<DDiagramElement> contexts) {
        DDiagramElement result = null;
        Iterator<DDiagramElement> iterator = contexts.iterator();
        while (iterator.hasNext()) {
            DDiagramElement element;
            result = element = iterator.next();
            HideFilterHelper.INSTANCE.reveal(element);
        }
        return result;
    }

    public static CapellaServices getService() {
        if (service == null) {
            service = new CapellaServices();
        }
        return service;
    }

    public String getConstraintLabel(Constraint constraint) {
        return CapellaEmbeddedLinkedTextEditorInput.getDefaultText((Constraint)constraint, (String)constraint.getName());
    }

    public EClass getEClass(EObject context, String domain) {
        EClass clazz = null;
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(context);
        try {
            clazz = accessor.createInstance(domain).eClass();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    public EClass getDomainClass(EObject context, DiagramElementMapping mapping) {
        DiagramElementMappingQuery query = new DiagramElementMappingQuery(mapping);
        Option domainClass = query.getDomainClass();
        if (domainClass.some()) {
            return this.getEClass(context, (String)domainClass.get());
        }
        return null;
    }

    public String capellaLabelService(EObject e, DDiagramElement view, DDiagram diagram) {
        return EObjectExt.getText((EObject)e);
    }

    public Collection<EObject> getAssociatedSemanticElements(EObject target) {
        List<EObject> associatedSemanticElementsWithoutNulls;
        Collection<EObject> elements;
        ArrayList<EObject> associatedSemanticElements = new ArrayList<EObject>();
        if (target == null) {
            return associatedSemanticElements;
        }
        if (target instanceof AbstractTypedElement) {
            elements = this.getAssociatedSemanticElementsForAbstractTypedElement((AbstractTypedElement)target);
            associatedSemanticElements.addAll(elements);
        }
        if (target instanceof EventReceiptOperation) {
            elements = this.getAssociatedSemanticElementsForEventReceiptOperation((EventReceiptOperation)target);
            associatedSemanticElements.addAll(elements);
        }
        if (target instanceof AbstractEnd) {
            elements = this.getAssociatedSemanticElementsForAbstractEnd((AbstractEnd)target);
            associatedSemanticElements.addAll(elements);
        }
        if (target instanceof EventSentOperation) {
            elements = this.getAssociatedSemanticElementsForEventSentOperation((EventSentOperation)target);
            associatedSemanticElements.addAll(elements);
        }
        if (target instanceof SequenceMessage) {
            elements = this.getAssociatedSemanticElementsForSequenceMessage((SequenceMessage)target);
            associatedSemanticElements.addAll(elements);
        }
        if (target instanceof InstanceRole) {
            elements = this.getAssociatedSemanticElementsForInstanceRole((InstanceRole)target);
            associatedSemanticElements.addAll(elements);
        }
        if (target instanceof StateFragment) {
            elements = this.getAssociatedSemanticElementsForStateFragment((StateFragment)target);
            associatedSemanticElements.addAll(elements);
        }
        if (target instanceof Involvement) {
            elements = this.getAssociatedSemanticElementsForInvolvement((Involvement)target);
            associatedSemanticElements.addAll(elements);
        }
        if (!(associatedSemanticElementsWithoutNulls = associatedSemanticElements.stream().filter(Objects::nonNull).map(x -> x).collect(Collectors.toList())).isEmpty()) {
            return associatedSemanticElementsWithoutNulls;
        }
        return Arrays.asList(target);
    }

    private Collection<EObject> getAssociatedSemanticElementsForAbstractTypedElement(AbstractTypedElement element) {
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        semanticElements.add((EObject)element);
        semanticElements.add((EObject)element.getAbstractType());
        return semanticElements;
    }

    private Collection<EObject> getAssociatedSemanticElementsForEventReceiptOperation(EventReceiptOperation element) {
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        semanticElements.add((EObject)element);
        semanticElements.add((EObject)element.getOperation());
        return semanticElements;
    }

    private Collection<EObject> getAssociatedSemanticElementsForAbstractEnd(AbstractEnd element) {
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        semanticElements.add((EObject)element);
        semanticElements.add((EObject)element.getEvent());
        return semanticElements;
    }

    private Collection<EObject> getAssociatedSemanticElementsForEventSentOperation(EventSentOperation element) {
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        semanticElements.add((EObject)element);
        semanticElements.add((EObject)element.getOperation());
        return semanticElements;
    }

    private Collection<EObject> getAssociatedSemanticElementsForSequenceMessage(SequenceMessage element) {
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        semanticElements.add((EObject)element);
        semanticElements.add((EObject)element.getReceivingEnd());
        semanticElements.add((EObject)element.getSendingEnd());
        semanticElements.add((EObject)element.getInvokedOperation());
        return semanticElements;
    }

    private Collection<EObject> getAssociatedSemanticElementsForInstanceRole(InstanceRole element) {
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        semanticElements.add((EObject)element);
        semanticElements.add((EObject)element.getRepresentedInstance());
        if (element.getRepresentedInstance() instanceof Part) {
            semanticElements.add((EObject)element.getRepresentedInstance().getAbstractType());
        }
        return semanticElements;
    }

    private Collection<EObject> getAssociatedSemanticElementsForStateFragment(StateFragment element) {
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        semanticElements.add((EObject)element);
        semanticElements.add((EObject)element.getRelatedAbstractState());
        semanticElements.add((EObject)element.getRelatedAbstractFunction());
        return semanticElements;
    }

    private Collection<EObject> getAssociatedSemanticElementsForInvolvement(Involvement element) {
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        semanticElements.add((EObject)element);
        semanticElements.add((EObject)element.getInvolved());
        return semanticElements;
    }

    public String getLastModificationDate(EObject representationDescriptor) {
        Long timeStamp = System.currentTimeMillis();
        if (representationDescriptor instanceof DRepresentationDescriptor) {
            String changeId = ((DRepresentationDescriptor)representationDescriptor).getChangeId();
            try {
                timeStamp = Long.parseLong(changeId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Date date = new Date(timeStamp);
        SimpleDateFormat sdf = new SimpleDateFormat(CapellaDiagramPreferencesInitializer.getFormatDate());
        String timeZoneForDateFormatting = CapellaDiagramPreferencesInitializer.getTimeZoneForDateFormatting();
        if ("SYSTEM".equals(timeZoneForDateFormatting)) {
            timeZoneForDateFormatting = TimeZone.getDefault().getID();
        }
        sdf.setTimeZone(TimeZone.getTimeZone(timeZoneForDateFormatting));
        return sdf.format(date);
    }

    public boolean isLibraryElementOf(EObject source, EObject target) {
        if (source == null || target == null) {
            return false;
        }
        IModel srcModel = LibraryManager.INSTANCE.getModel(source);
        IModel targetModel = LibraryManager.INSTANCE.getModel(target);
        if (srcModel == null || targetModel == null) {
            return false;
        }
        return !targetModel.equals(srcModel);
    }
}

