/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageMonitoringLogger;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.sirius.analysis.Messages;
import org.polarsys.capella.core.sirius.analysis.commands.AbstractNewRepresentationCommand;
import org.polarsys.capella.shared.id.handler.IdManager;

public class NewScenarioRepresentationCommand
extends AbstractNewRepresentationCommand {
    public NewScenarioRepresentationCommand(String newName, AbstractCapability eObject, RepresentationDescription repDescription, Session session) {
        super(newName, (EObject)eObject, repDescription, session);
    }

    @Override
    public void run() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        Scenario scenario = InteractionFactory.eINSTANCE.createScenario();
        scenario.setName(this.newName);
        ((AbstractCapability)this.eObject).getOwnedScenarios().add((Object)scenario);
        String eventName = Messages.CreateRepresentationLabel;
        String eventContext = this.repDescription.getName();
        String addendum = IdManager.getInstance().getId((EObject)scenario);
        UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.NONE, addendum);
        this.representation = DialectManager.INSTANCE.createRepresentation(this.newName, (EObject)scenario, this.repDescription, this.currentSession, (IProgressMonitor)monitor);
        UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.OK, addendum);
    }
}

