/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.capella.core.sirius.analysis.activator.SiriusViewActivator;
import org.polarsys.capella.core.sirius.analysis.preferences.Messages;
import org.polarsys.capella.core.sirius.analysis.preferences.TitleBlockDialog;

public class TitleBlockPreferenceField
extends FieldEditor {
    public static final int MIN_CELL_WIDTH = 100;
    public static final String EMPTY_STRING = "";
    public static final int BOUND = 200;
    public static final String IMAGE_LINE = "icons/full/obj16/TitleBlockLine.gif";
    public static final String IMAGE_COLUMN = "icons/full/obj16/TitleBlockColumn.gif";
    public static final String IMAGE_LINE_REMOVE = "icons/full/obj16/TitleBlockLineRemove.gif";
    public static final String IMAGE_COLUMN_REMOVE = "icons/full/obj16/TitleBlockColumnRemove.gif";
    private TableViewer v;
    private List<List<TitleBlockCell>> tccMatrix;
    private int columnsNumber;
    private int linesNumber;
    private String tableContent;

    public TitleBlockPreferenceField(Composite parent) {
        super(EMPTY_STRING, Messages.TitleBlockPreferencePage_Message, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        System.out.println();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.v = new TableViewer(top, 68354);
        this.v.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.v.getTable().setLinesVisible(true);
        this.v.getTable().setHeaderVisible(false);
        this.v.getTable().setLayout((Layout)new GridLayout());
        this.v.getTable().setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).create());
        this.addMenu(this.v);
        Listener tableListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 8: {
                        Point coords = new Point(event.x, event.y);
                        ViewerCell cell = TitleBlockPreferenceField.this.v.getCell(coords);
                        if (cell == null) break;
                        int index = cell.getColumnIndex();
                        List list = (List)cell.getElement();
                        TitleBlockDialog dialog = new TitleBlockDialog(cell.getControl().getShell());
                        dialog.setCurrentName(((TitleBlockCell)list.get((int)index)).name);
                        dialog.setCurrentContent(((TitleBlockCell)list.get((int)index)).content);
                        dialog.create();
                        if (dialog.open() != 0) break;
                        ((TitleBlockCell)list.get((int)index)).name = dialog.getName();
                        ((TitleBlockCell)list.get((int)index)).content = dialog.getContent();
                        TitleBlockPreferenceField.this.v.refresh((Object)list);
                    }
                }
            }
        };
        this.v.getTable().addListener(8, tableListener);
        this.v.getTable().addListener(3, tableListener);
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        TableItem item = (TableItem)event.item;
                        String text = item.getText(event.index);
                        Point size = event.gc.textExtent(text);
                        event.height = Math.max(event.height, size.y + 10);
                    }
                }
            }
        };
        this.v.getTable().addListener(41, paintListener);
    }

    private void disposeColumns() {
        TableColumn[] columns;
        this.v.getTable().setRedraw(false);
        TableColumn[] tableColumnArray = columns = this.v.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.dispose();
            ++n2;
        }
        this.v.getTable().setRedraw(true);
    }

    private void refreshTableInsertColumns(int index) {
        this.disposeColumns();
        ++this.columnsNumber;
        this.createColumns(this.v, this.columnsNumber);
        this.v.setInput(this.insertNewEmptyColumn(index));
    }

    private void refreshTableRemoveColumn(int index) {
        this.disposeColumns();
        --this.columnsNumber;
        this.createColumns(this.v, this.columnsNumber);
        this.v.setInput(this.removeSelectedColumn(index));
    }

    private void refreshTableInsertLines(int index) {
        this.v.setInput(this.insertNewEmptyLine(index));
    }

    private void refreshTableRemoveLine() {
        int lineToDelete = this.v.getTable().getSelectionIndex();
        this.v.setInput(this.removeSelectedLine(lineToDelete));
    }

    protected void doLoad() {
        this.tableContent = this.getPreferenceStore().getString("tableTitleBlock");
        this.columnsNumber = this.getPreferenceStore().getInt("columnsNumberTitleBlock");
        this.linesNumber = this.getPreferenceStore().getInt("linesNumberTitleBlock");
        this.disposeColumns();
        this.createColumns(this.v, this.columnsNumber);
        this.v.setInput(this.createModel());
    }

    protected void doLoadDefault() {
        this.tableContent = this.getPreferenceStore().getDefaultString("tableTitleBlock");
        this.columnsNumber = this.getPreferenceStore().getDefaultInt("columnsNumberTitleBlock");
        this.linesNumber = this.getPreferenceStore().getDefaultInt("linesNumberTitleBlock");
        this.disposeColumns();
        this.createColumns(this.v, this.columnsNumber);
        this.v.setInput(this.createModel());
    }

    protected void doStore() {
        StringBuilder table = new StringBuilder();
        int i = 0;
        while (i < this.linesNumber) {
            int j = 0;
            while (j < this.columnsNumber) {
                table.append(this.tccMatrix.get((int)i).get((int)j).name);
                table.append("SEPARATOR");
                table.append(this.tccMatrix.get((int)i).get((int)j).content);
                if (i != this.linesNumber - 1 || j != this.columnsNumber - 1) {
                    table.append("SEPARATOR");
                }
                ++j;
            }
            ++i;
        }
        this.getPreferenceStore().setValue("columnsNumberTitleBlock", this.columnsNumber);
        this.getPreferenceStore().setValue("linesNumberTitleBlock", this.linesNumber);
        this.getPreferenceStore().setValue("tableTitleBlock", table.toString());
    }

    public int getNumberOfControls() {
        return 1;
    }

    private List<List<TitleBlockCell>> insertNewEmptyColumn(int index) {
        if (index == -1) {
            int i = 0;
            while (i < this.linesNumber) {
                List<TitleBlockCell> tbcCell = this.tccMatrix.get(i);
                tbcCell.add(new TitleBlockCell(EMPTY_STRING, EMPTY_STRING));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.linesNumber) {
                List<TitleBlockCell> tbcCell = this.tccMatrix.get(i);
                tbcCell.add(index, new TitleBlockCell(EMPTY_STRING, EMPTY_STRING));
                ++i;
            }
        }
        return this.tccMatrix;
    }

    private List<List<TitleBlockCell>> insertNewEmptyLine(int index) {
        ++this.linesNumber;
        ArrayList<TitleBlockCell> tbcCell = new ArrayList<TitleBlockCell>();
        int i = 0;
        while (i < this.columnsNumber) {
            tbcCell.add(new TitleBlockCell(EMPTY_STRING, EMPTY_STRING));
            ++i;
        }
        if (index == -1) {
            this.tccMatrix.add(tbcCell);
        } else {
            this.tccMatrix.add(index, tbcCell);
        }
        return this.tccMatrix;
    }

    private List<List<TitleBlockCell>> removeSelectedLine(int lineToDelete) {
        this.tccMatrix.remove(lineToDelete);
        --this.linesNumber;
        return this.tccMatrix;
    }

    private List<List<TitleBlockCell>> removeSelectedColumn(int columnToDelete) {
        int i = 0;
        while (i < this.linesNumber) {
            this.tccMatrix.get(i).remove(columnToDelete);
            ++i;
        }
        return this.tccMatrix;
    }

    private List<List<TitleBlockCell>> createModel() {
        String[] cellsNameAndContent = this.tableContent.split("SEPARATOR", -1);
        int currentIndex = 0;
        this.tccMatrix = new ArrayList<List<TitleBlockCell>>(cellsNameAndContent.length);
        int i = 0;
        while (i < this.linesNumber) {
            ArrayList<TitleBlockCell> row = new ArrayList<TitleBlockCell>();
            int j = 0;
            while (j < this.columnsNumber) {
                String name = currentIndex < cellsNameAndContent.length ? cellsNameAndContent[currentIndex] : EMPTY_STRING;
                String value = currentIndex + 1 < cellsNameAndContent.length ? cellsNameAndContent[currentIndex + 1] : EMPTY_STRING;
                row.add(new TitleBlockCell(name, value));
                currentIndex += 2;
                ++j;
            }
            this.tccMatrix.add(row);
            ++i;
        }
        return this.tccMatrix;
    }

    private void createColumn(TableViewer v, String title, final int index) {
        TableViewerColumn column = this.createTableViewerColumn(v, title, 200);
        column.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                List lst = (List)cell.getElement();
                TitleBlockCell tbcell = (TitleBlockCell)lst.get(index);
                String cellText = String.valueOf(tbcell);
                if (cellText != null && !cellText.trim().isEmpty()) {
                    cell.setText(cellText);
                    int multiLine = cellText.indexOf("\n");
                    if (multiLine > 0) {
                        cell.setStyleRanges(new StyleRange[]{new StyleRange(0, multiLine, cell.getControl().getShell().getDisplay().getSystemColor(21), null), new StyleRange(multiLine, cellText.length(), cell.getControl().getShell().getDisplay().getSystemColor(16), null)});
                    }
                } else {
                    cell.setText(Messages.TitleBlockPreferencePage_EmptyMessage);
                    cell.setForeground(cell.getControl().getShell().getDisplay().getSystemColor(16));
                }
            }
        });
    }

    private void testSelectCell(final TableViewer viewer) {
        CellNavigationStrategy strategy = new CellNavigationStrategy(){

            public ViewerCell findSelectedCell(ColumnViewer cviewer, ViewerCell currentSelectedCell, Event event) {
                ViewerCell cell = null;
                switch (event.keyCode) {
                    case 9: {
                        cell = event.stateMask == 0 ? currentSelectedCell.getNeighbor(ViewerCell.RIGHT, true) : currentSelectedCell.getNeighbor(ViewerCell.LEFT, true);
                    }
                }
                if (cell != null) {
                    TableColumn t = viewer.getTable().getColumn(cell.getColumnIndex());
                    viewer.getTable().showColumn(t);
                }
                return cell;
            }

            public boolean isNavigationEvent(ColumnViewer viewer2, Event event) {
                switch (event.keyCode) {
                    case 9: {
                        return true;
                    }
                }
                return super.isNavigationEvent(viewer2, event);
            }
        };
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)viewer), strategy);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return false;
            }
        };
        TableViewerEditor.create((TableViewer)viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    private void createColumns(TableViewer viewer, int nrColumns) {
        ArrayList<String> columnHeadings = new ArrayList<String>();
        int i = 0;
        while (i < nrColumns) {
            columnHeadings.add(EMPTY_STRING);
            this.createColumn(viewer, (String)columnHeadings.get(i), i);
            ++i;
        }
        this.testSelectCell(viewer);
        this.setColumnLayout(viewer, nrColumns);
    }

    protected void setColumnLayout(TableViewer viewer, int nrColumns) {
        TableColumnLayout layout = new TableColumnLayout();
        viewer.getControl().getParent().setLayout((Layout)layout);
        int i = 0;
        while (i < nrColumns) {
            layout.setColumnData((Widget)viewer.getTable().getColumn(i), (ColumnLayoutData)new ColumnWeightData(100));
            ++i;
        }
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        int wd = viewer.getTable().getClientArea().width;
        if (wd > 0) {
            int columnWidth = wd / this.columnsNumber;
            if (columnWidth > 100) {
                column.setWidth(columnWidth);
            } else {
                column.setWidth(100);
            }
        } else {
            column.setWidth(bound);
        }
        column.setResizable(true);
        return viewerColumn;
    }

    private void addMenu(final TableViewer v) {
        MenuManager mgr = new MenuManager();
        Action insertLine = new Action(Messages.TitleBlockPreferencePage_InsertLine){

            public void run() {
                int lineToInsert = v.getTable().getSelectionIndex() + 1;
                if (lineToInsert != 0) {
                    TitleBlockPreferenceField.this.refreshTableInsertLines(lineToInsert);
                } else {
                    TitleBlockPreferenceField.this.refreshTableInsertLines(TitleBlockPreferenceField.this.linesNumber);
                }
            }
        };
        insertLine.setImageDescriptor(SiriusViewActivator.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.sirius.analysis", (String)IMAGE_LINE));
        Action insertColumn = new Action(Messages.TitleBlockPreferencePage_InsertColumn){

            public void run() {
                ViewerCell focusCell = v.getColumnViewerEditor().getFocusCell();
                TitleBlockPreferenceField.this.createColumn(v, TitleBlockPreferenceField.EMPTY_STRING, v.getTable().getColumnCount());
                if (focusCell != null) {
                    int columnToInsert = focusCell.getColumnIndex() + 1;
                    TitleBlockPreferenceField.this.refreshTableInsertColumns(columnToInsert);
                } else {
                    TitleBlockPreferenceField.this.refreshTableInsertColumns(TitleBlockPreferenceField.this.columnsNumber);
                }
            }
        };
        insertColumn.setImageDescriptor(SiriusViewActivator.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.sirius.analysis", (String)IMAGE_COLUMN));
        Action removeLine = new Action(Messages.TitleBlockPreferencePage_RemoveLine){

            public void run() {
                int lineToDelete;
                if (TitleBlockPreferenceField.this.linesNumber == 1) {
                    TitleBlockPreferenceField.this.createMessageBox(v.getTable().getShell(), Messages.TitleBlockPreferencePage_RemoveLastLineError, TitleBlockPreferenceField.EMPTY_STRING);
                } else if (v.getColumnViewerEditor().getFocusCell() != null && (lineToDelete = v.getTable().getSelectionIndex()) != -1) {
                    MessageBox messageBox = new MessageBox(v.getTable().getShell(), 196);
                    messageBox.setMessage(Messages.TitleBlockPreferencePage_DeleteEntireRow);
                    messageBox.setText(Messages.TitleBlockPreferencePage_ConfirmDeletion);
                    int response = messageBox.open();
                    if (response == 64) {
                        TitleBlockPreferenceField.this.refreshTableRemoveLine();
                    }
                }
            }
        };
        removeLine.setImageDescriptor(SiriusViewActivator.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.sirius.analysis", (String)IMAGE_LINE_REMOVE));
        Action removeColumn = new Action(Messages.TitleBlockPreferencePage_RemoveColumn){

            public void run() {
                if (TitleBlockPreferenceField.this.columnsNumber == 1) {
                    TitleBlockPreferenceField.this.createMessageBox(v.getTable().getShell(), Messages.TitleBlockPreferencePage_RemoveLastColumnError, TitleBlockPreferenceField.EMPTY_STRING);
                }
                if (v.getColumnViewerEditor().getFocusCell() != null && TitleBlockPreferenceField.this.columnsNumber > 1) {
                    MessageBox messageBox = new MessageBox(v.getTable().getShell(), 196);
                    messageBox.setMessage(Messages.TitleBlockPreferencePage_DeleteEntireColumn);
                    messageBox.setText(Messages.TitleBlockPreferencePage_ConfirmDeletion);
                    int response = messageBox.open();
                    if (response == 64) {
                        int columnToDelete = v.getColumnViewerEditor().getFocusCell().getColumnIndex();
                        TitleBlockPreferenceField.this.refreshTableRemoveColumn(columnToDelete);
                    }
                }
            }
        };
        removeColumn.setImageDescriptor(SiriusViewActivator.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.sirius.analysis", (String)IMAGE_COLUMN_REMOVE));
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(manager -> {
            if (v.getTable().getColumnCount() >= 1 && this.linesNumber >= 1) {
                manager.add((IAction)insertLine);
                manager.add((IAction)insertColumn);
                manager.add((IAction)removeLine);
                manager.add((IAction)removeColumn);
            }
        });
        v.getControl().setMenu(mgr.createContextMenu(v.getControl()));
    }

    private void createMessageBox(Shell shell, String messageToDisplay, String textBox) {
        MessageBox box = new MessageBox(shell, 40);
        box.setMessage(messageToDisplay);
        box.setText(textBox);
        box.open();
    }

    private class TitleBlockCell {
        private String name;
        private String content;

        public TitleBlockCell(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public String toString() {
            return this.name + "\n" + this.content;
        }
    }
}

