/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.showhide.IShowHide;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class AbstractShowHide
implements IShowHide {
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String CONTAINER = "container";
    public static final String ROOT = "root";
    public static final String VIEWS = "views";
    public static final String INITIAL_VIEWS = "initial";
    protected DDiagramContents _content;

    protected DDiagramContents getContent() {
        return this._content;
    }

    public AbstractShowHide(DDiagramContents content) {
        this._content = content;
    }

    protected ContextItemView getNextContextItemView(DiagramContext context, ContextItemElement skip) {
        for (ContextItem obj : context) {
            if (!(obj instanceof ContextItemView) || ((ContextItemView)obj).getElement() == skip) continue;
            return (ContextItemView)obj;
        }
        return null;
    }

    protected DiagramContext getComputedDiagramContext(EObject semantic, DiagramContext context, boolean readOnly) {
        DiagramContext contextToVisit = new DiagramContext();
        DiagramContext contextToHide = new DiagramContext();
        ContextItemEnd endContext = new ContextItemEnd();
        contextToVisit.add(context.getLast());
        int i = 0;
        int maximalDepth = this.getMaximalDepth();
        while (contextToVisit.size() > 0 && i < maximalDepth) {
            ++i;
            ContextItem couple = (ContextItem)contextToVisit.removeFirst();
            if (couple instanceof ContextItemView) {
                ContextItemView itemView = (ContextItemView)couple;
                ContextItemElement element = itemView.getElement();
                ContextItemView nextCouple = element.getAncestor();
                for (ContextItemView view : element.getViews()) {
                    Collection<DSemanticDecorator> v;
                    if (!view.getViews().get(VIEWS).isEmpty() || (v = this.get(element.getValue(), context, null, view.getViews())).isEmpty()) continue;
                    view.getViews().putAll(VIEWS, v);
                }
                Collection<DSemanticDecorator> v = null;
                if (readOnly) {
                    v = itemView.getViews().get(VIEWS);
                } else if (!this.mustShow(element, context, itemView.getViews())) {
                    v = itemView.getViews().get(VIEWS);
                } else if (this.bypassRelatedElements(element, context)) {
                    v = itemView.getViews().get(VIEWS);
                } else {
                    v = this.show(element.getValue(), context, null, itemView.getViews());
                    itemView.getViews().putAll(VIEWS, v);
                }
                if (nextCouple != null) {
                    nextCouple.getViews().putAll(element.getKey(), v);
                }
                if (!this.mustHide(element, context)) continue;
                contextToHide.addFirst(couple);
                continue;
            }
            if (couple instanceof ContextItemEnd) {
                context.removeLast();
                continue;
            }
            if (!(couple instanceof ContextItemElement)) continue;
            ContextItemElement element = (ContextItemElement)couple;
            EObject semanticElement = element.getValue();
            contextToVisit.addFirst(endContext);
            if (this.bypassRelatedElements(element, context) && !readOnly) {
                contextToVisit.addFirst(new ContextItemView(element));
                continue;
            }
            HashMapSet<String, EObject> relatedElements = this.getRelatedObjects(semanticElement, context);
            ContextItemView lastView = null;
            Set<String> keys = relatedElements.keySet();
            if (keys.size() == 0) {
                contextToVisit.addFirst(new ContextItemView(element));
            }
            ArrayList<ContextItemElement> items = new ArrayList<ContextItemElement>();
            if (keys.size() == 1) {
                String string = keys.iterator().next();
                var18_21 = relatedElements.get(string).iterator();
                while (var18_21.hasNext()) {
                    related = (EObject)var18_21.next();
                    lastView = new ContextItemView(element);
                    contextToVisit.addFirst(lastView);
                    ContextItemElement relatedCouple = new ContextItemElement(string, related, lastView);
                    items.add(relatedCouple);
                }
            } else if (keys.size() == 2) {
                String string = keys.iterator().next();
                var18_21 = relatedElements.get(string).iterator();
                while (var18_21.hasNext()) {
                    related = (EObject)var18_21.next();
                    Iterator<String> a = keys.iterator();
                    a.next();
                    String key2 = a.next();
                    Iterator iterator = relatedElements.get(key2).iterator();
                    while (iterator.hasNext()) {
                        EObject related2 = (EObject)iterator.next();
                        lastView = new ContextItemView(element);
                        contextToVisit.addFirst(lastView);
                        ContextItemElement relatedCouple = new ContextItemElement(string, related, lastView);
                        ContextItemElement relatedCouple2 = new ContextItemElement(key2, related2, lastView);
                        items.add(relatedCouple);
                        items.add(relatedCouple2);
                    }
                }
            }
            for (ContextItem contextItem : items) {
                context.add(contextItem);
                contextToVisit.addFirst(contextItem);
            }
        }
        return contextToHide;
    }

    protected boolean bypassRelatedElements(ContextItemElement originCouple, DiagramContext context) {
        return false;
    }

    protected int getMaximalDepth() {
        return 500;
    }

    @Override
    public void hide(EObject semantic, DiagramContext context) {
        context.add(new ContextItemElement(ROOT, semantic));
        DiagramContext ctx = this.getComputedDiagramContext(semantic, context, true);
        for (ContextItem couple : ctx) {
            ContextItem cA = couple;
            if (!(cA instanceof ContextItemView)) continue;
            ContextItemView itemView = (ContextItemView)cA;
            ContextItemElement element = itemView.getElement();
            context.add(element);
            HashMapSet<String, DSemanticDecorator> itemViewGetViews = itemView.getViews();
            this.hide(this.get(element.getValue(), context, null, itemViewGetViews), context);
            context.removeLast();
        }
    }

    public Collection<DSemanticDecorator> get(EObject semantic, DiagramContext context) {
        context.add(new ContextItemElement(ROOT, semantic));
        DiagramContext ctx = this.getComputedDiagramContext(semantic, context, true);
        ArrayList<DSemanticDecorator> result = new ArrayList<DSemanticDecorator>();
        for (ContextItem couple : ctx) {
            ContextItem cA = couple;
            if (!(cA instanceof ContextItemView)) continue;
            ContextItemView itemView = (ContextItemView)cA;
            ContextItemElement element = itemView.getElement();
            context.add(element);
            result.addAll(this.get(element.getValue(), context, null, itemView.getViews()));
            context.removeLast();
        }
        return result;
    }

    @Override
    public Collection<DSemanticDecorator> showWithResult(EObject semantic, DiagramContext context) {
        ContextItemElement root = new ContextItemElement(ROOT, semantic);
        context.add(root);
        this.getComputedDiagramContext(semantic, context, false);
        ArrayList<DSemanticDecorator> elements = new ArrayList<DSemanticDecorator>();
        for (ContextItemView view : root.getViews()) {
            elements.addAll((Collection<DSemanticDecorator>)view.getViews().get(VIEWS));
        }
        return elements;
    }

    @Override
    public void show(EObject semantic, DiagramContext context) {
        this.showWithResult(semantic, context);
    }

    protected void hide(Collection<DSemanticDecorator> collection, DiagramContext context) {
        for (DSemanticDecorator view : collection) {
            DDiagramElement element = (DDiagramElement)view;
            if (element == null || !this.mustHide(element, context)) continue;
            if (this.hideInsteadOfRemoveView(element, context)) {
                this.getContent().deferredHide(element);
                continue;
            }
            DiagramElementMapping diagramElementMapping = element.getDiagramElementMapping();
            if (diagramElementMapping instanceof EdgeMapping) {
                DiagramServices.getDiagramServices().removeEdgeView((DEdge)element);
                continue;
            }
            if (!(diagramElementMapping instanceof AbstractNodeMapping)) continue;
            DiagramServices.getDiagramServices().removeAbstractDNodeView((AbstractDNode)element);
        }
    }

    protected boolean hideInsteadOfRemoveView(DDiagramElement element, DiagramContext context) {
        return false;
    }

    protected boolean mustShow(ContextItemElement originCouple, DiagramContext context, HashMapSet<String, DSemanticDecorator> relatedViews) {
        return true;
    }

    protected boolean mustHide(ContextItemElement originCouple, DiagramContext context) {
        return true;
    }

    protected boolean mustHide(DDiagramElement view, DiagramContext context) {
        if (view.getDiagramElementMapping() instanceof AbstractNodeMapping) {
            return ((EdgeTarget)view).getIncomingEdges().isEmpty() && ((EdgeTarget)view).getOutgoingEdges().isEmpty();
        }
        return true;
    }

    protected Collection<DSemanticDecorator> get(EObject semantic, DiagramContext context, HashMapSet<String, EObject> relatedElements, HashMapSet<String, DSemanticDecorator> relatedViews) {
        ArrayList<DSemanticDecorator> result;
        block5: {
            DiagramElementMapping mapping;
            block6: {
                result = new ArrayList<DSemanticDecorator>();
                mapping = this.getMapping(semantic, context, relatedViews);
                if (mapping == null) break block5;
                if (!(mapping instanceof EdgeMapping)) break block6;
                Object sourceViews = relatedViews.get(SOURCE);
                Object targetViews = relatedViews.get(TARGET);
                Iterator iterator = sourceViews.iterator();
                while (iterator.hasNext()) {
                    DSemanticDecorator sourceView = (DSemanticDecorator)iterator.next();
                    Iterator iterator2 = targetViews.iterator();
                    while (iterator2.hasNext()) {
                        DSemanticDecorator targetView = (DSemanticDecorator)iterator2.next();
                        result.addAll(this.getEdges(sourceView, targetView, semantic, this.getContent(), (EdgeMapping)mapping));
                    }
                }
                break block5;
            }
            if (!(mapping instanceof AbstractNodeMapping)) break block5;
            Object targetViews = relatedViews.get(CONTAINER);
            if (targetViews.size() == 0) {
                targetViews.addAll(this.retrieveDefaultContainer(semantic, context, (Collection<DSemanticDecorator>)targetViews));
            }
            Iterator iterator = targetViews.iterator();
            while (iterator.hasNext()) {
                DSemanticDecorator targetView = (DSemanticDecorator)iterator.next();
                if (!this.isValidSemanticView(targetView.getTarget(), targetView, context)) continue;
                for (DDiagramElement semanticView : this.getNodes(targetView, semantic, this._content, (AbstractNodeMapping)mapping)) {
                    if (!this.isValidSemanticView(semantic, (DSemanticDecorator)semanticView, context)) continue;
                    result.add((DSemanticDecorator)semanticView);
                }
            }
        }
        return result;
    }

    protected boolean isValidNodeView(DDiagramElement semanticView, DSemanticDecorator containerView) {
        DiagramElementMapping mapping = semanticView.getDiagramElementMapping();
        if (DiagramServices.getDiagramServices().isBorderedNodeMapping(mapping)) {
            return containerView != null && containerView.equals(semanticView.eContainer());
        }
        return true;
    }

    protected boolean isValidEdgeView(DEdge edge, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        return sourceView.equals(edge.getSourceNode()) && targetView.equals(edge.getTargetNode());
    }

    protected boolean isValidSemanticView(EObject semantic, DSemanticDecorator semanticView, DiagramContext context) {
        return true;
    }

    protected Collection<DSemanticDecorator> show(EObject semantic, DiagramContext context, HashMapSet<String, EObject> relatedElements, HashMapSet<String, DSemanticDecorator> relatedViews) {
        ArrayList<DSemanticDecorator> result;
        block4: {
            DiagramElementMapping mapping;
            block5: {
                result = new ArrayList<DSemanticDecorator>();
                mapping = this.getMapping(semantic, context, relatedViews);
                if (mapping == null) break block4;
                if (!(mapping instanceof EdgeMapping)) break block5;
                Object sourceViews = relatedViews.get(SOURCE);
                Object targetViews = relatedViews.get(TARGET);
                Iterator iterator = sourceViews.iterator();
                while (iterator.hasNext()) {
                    DSemanticDecorator sourceView = (DSemanticDecorator)iterator.next();
                    Iterator iterator2 = targetViews.iterator();
                    while (iterator2.hasNext()) {
                        DSemanticDecorator targetView = (DSemanticDecorator)iterator2.next();
                        result.addAll(this.showEdges(sourceView, targetView, semantic, this.getContent(), (EdgeMapping)mapping));
                    }
                }
                break block4;
            }
            if (!(mapping instanceof AbstractNodeMapping)) break block4;
            Object targetViews = relatedViews.get(CONTAINER);
            if (targetViews.isEmpty()) {
                targetViews.addAll(this.retrieveDefaultContainer(semantic, context, (Collection<DSemanticDecorator>)targetViews));
            }
            Iterator iterator = targetViews.iterator();
            while (iterator.hasNext()) {
                DSemanticDecorator targetView = (DSemanticDecorator)iterator.next();
                if (!this.isValidSemanticView(targetView.getTarget(), targetView, context)) continue;
                result.addAll(this.showNodes(targetView, semantic, this.getContent(), (AbstractNodeMapping)mapping));
            }
        }
        return result;
    }

    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic, DiagramContext context, Collection<DSemanticDecorator> targetViews) {
        return Collections.emptyList();
    }

    protected Collection<DDiagramElement> getNodes(DSemanticDecorator containerView, EObject semantic, DDiagramContents content, AbstractNodeMapping mapping) {
        LinkedList<DDiagramElement> edges = new LinkedList<DDiagramElement>();
        for (DDiagramElement view : content.getDiagramElements(semantic, (DiagramElementMapping)mapping, containerView)) {
            if (!this.isValidNodeView(view, containerView)) continue;
            edges.add(view);
        }
        return edges;
    }

    protected Collection<DDiagramElement> getEdges(DSemanticDecorator sourceView, DSemanticDecorator targetView, EObject semantic, DDiagramContents content, EdgeMapping mapping) {
        LinkedList<DDiagramElement> edges = new LinkedList<DDiagramElement>();
        for (DDiagramElement elementView : content.getDiagramElements(semantic, (DiagramElementMapping)mapping)) {
            if (!(elementView instanceof DEdge)) continue;
            DEdge edge = (DEdge)elementView;
            if (sourceView == null || targetView == null || edge.getSourceNode() == null || edge.getTargetNode() == null || !this.isValidEdgeView(edge, sourceView, targetView)) continue;
            edges.add((DDiagramElement)edge);
        }
        return edges;
    }

    protected Collection<DDiagramElement> showNodes(DSemanticDecorator containerView, EObject semantic, DDiagramContents content, AbstractNodeMapping mapping) {
        Collection<DDiagramElement> nodes = this.getNodes(containerView, semantic, content, mapping);
        if (nodes.isEmpty()) {
            nodes = new ArrayList<DDiagramElement>();
        }
        if (nodes.isEmpty()) {
            DDiagram diagram = content.getDDiagram();
            if (this.mustShow(containerView, semantic, mapping)) {
                AbstractDNode node = DiagramServices.getDiagramServices().createAbstractDNode(mapping, semantic, (DragAndDropTarget)containerView, diagram);
                content.addView((DDiagramElement)node);
                nodes.add((DDiagramElement)node);
            }
        }
        return nodes;
    }

    protected boolean mustShow(DSemanticDecorator containerView, EObject semantic, AbstractNodeMapping mapping) {
        if (containerView instanceof DDiagram && DiagramServices.getDiagramServices().isBorderedNodeMapping((DiagramElementMapping)mapping)) {
            return false;
        }
        if (containerView instanceof DDiagram && mapping.eContainer() instanceof DiagramElementMapping) {
            return false;
        }
        return DiagramServices.getDiagramServices().evaluateNodePrecondition(mapping, this.getContent().getDDiagram(), containerView, semantic);
    }

    protected boolean mustShow(DSemanticDecorator source, DSemanticDecorator target, EObject exchange, EdgeMapping edgeMapping) {
        return DiagramServices.getDiagramServices().evaluateEdgePrecondition(edgeMapping, this.getContent().getDDiagram(), exchange, source, target);
    }

    protected Collection<DDiagramElement> showEdges(DSemanticDecorator source, DSemanticDecorator target, EObject exchange, DDiagramContents content, EdgeMapping edgeMapping) {
        Collection<DDiagramElement> nodes = this.getEdges(source, target, exchange, content, edgeMapping);
        if (nodes.isEmpty()) {
            nodes = new ArrayList<DDiagramElement>();
        }
        if (nodes.isEmpty() && this.mustShow(source, target, exchange, edgeMapping)) {
            DEdge edge = DiagramServices.getDiagramServices().createEdge(edgeMapping, (EdgeTarget)source, (EdgeTarget)target, exchange);
            content.addView((DDiagramElement)edge);
            nodes.add((DDiagramElement)edge);
        }
        return nodes;
    }

    protected DiagramElementMapping getMapping(EObject semantic, DiagramContext context, HashMapSet<String, DSemanticDecorator> relatedViews) {
        return null;
    }

    protected HashMapSet<String, EObject> getRelatedObjects(EObject semantic, DiagramContext context) {
        return new HashMapSet<String, EObject>();
    }

    protected static interface ContextItem {
    }

    protected class ContextItemElement
    implements ContextItem {
        private String _key;
        private EObject _value;
        private ContextItemView _ancestor;
        private ArrayList<ContextItemView> _views = null;

        ContextItemElement(String key, EObject value) {
            this._key = key;
            this._value = value;
            ContextItemView initialView = new ContextItemView(this);
            this.addView(initialView);
            initialView.getViews().putAll(AbstractShowHide.INITIAL_VIEWS, AbstractShowHide.this.getContent().getDiagramElements(value));
            initialView.getViews().putAll(AbstractShowHide.VIEWS, AbstractShowHide.this.getContent().getDiagramElements(value));
        }

        ContextItemElement(String key, EObject value, ContextItemView ancestor) {
            this(key, value);
            this._ancestor = ancestor;
        }

        public void setValue(EObject value) {
            this._value = value;
        }

        public ContextItemView getAncestor() {
            return this._ancestor;
        }

        public String getKey() {
            return this._key;
        }

        public EObject getValue() {
            return this._value;
        }

        public String toString() {
            String result = this._value instanceof AbstractNamedElement ? ((AbstractNamedElement)this._value).getName() : this._value.toString();
            return "Element(" + this._key + "=" + result + ")";
        }

        public ArrayList<ContextItemView> getViews() {
            if (this._views == null) {
                this._views = new ArrayList();
            }
            return this._views;
        }

        public void addView(ContextItemView contextItemView) {
            this.getViews().add(contextItemView);
        }
    }

    protected class ContextItemEnd
    implements ContextItem {
        protected ContextItemEnd() {
        }
    }

    protected class ContextItemVariable
    implements ContextItem {
        private String _key;
        private Object _value;

        ContextItemVariable(String key, Object value) {
            this._key = key;
            this._value = value;
        }

        public void setValue(Object value) {
            this._value = value;
        }

        public String getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public String toString() {
            String result = this._value instanceof AbstractNamedElement ? ((AbstractNamedElement)this._value).getName() : this._value.toString();
            return "Var(" + this._key + "=" + result + ")";
        }
    }

    protected class ContextItemView
    implements ContextItem {
        ContextItemElement _element;
        HashMapSet<String, DSemanticDecorator> _map;

        public ContextItemView(ContextItemElement element) {
            this._element = element;
            this._element.addView(this);
            this._map = new HashMapSet();
        }

        public HashMapSet<String, DSemanticDecorator> getViews() {
            return this._map;
        }

        public ContextItemElement getElement() {
            return this._element;
        }

        public String toString() {
            return "View(" + this._element.toString() + ")";
        }
    }

    public class DiagramContext
    extends LinkedList<ContextItem> {
        private static final long serialVersionUID = 6026544019176965896L;

        public DiagramContext() {
        }

        public DiagramContext(DiagramContext context) {
            this.addAll(context);
        }

        public void setElement(String key, EObject value) {
            ContextItemElement entry = this.getLast(key);
            if (entry == null) {
                this.add(new ContextItemElement(key, value));
            } else {
                entry.setValue(value);
            }
        }

        public void setVariable(String key, Object value) {
            ContextItemVariable entry = this.getLastVariable(key);
            if (entry == null) {
                this.add(new ContextItemVariable(key, value));
            } else {
                entry.setValue(value);
            }
        }

        public void unsetVariable(String key) {
            ContextItemVariable entry = this.getLastVariable(key);
            if (entry != null) {
                this.remove(entry);
            }
        }

        public ContextItemVariable getLastVariable(String key) {
            ContextItemVariable value = null;
            for (ContextItem next : this) {
                if (!(next instanceof ContextItemVariable) || !((ContextItemVariable)next).getKey().equals(key)) continue;
                value = (ContextItemVariable)next;
            }
            return value;
        }

        @Override
        public ContextItemElement getLast() {
            ContextItemElement value = null;
            for (ContextItem next : this) {
                if (!(next instanceof ContextItemElement)) continue;
                value = (ContextItemElement)next;
            }
            return value;
        }

        public ContextItemElement getLast(String key) {
            ContextItemElement value = null;
            for (ContextItem next : this) {
                if (!(next instanceof ContextItemElement) || !((ContextItemElement)next).getKey().equals(key)) continue;
                value = (ContextItemElement)next;
            }
            return value;
        }

        public void removeLast(String key) {
            ContextItem value = null;
            for (ContextItem next : this) {
                if (!(next instanceof ContextItemElement) || !((ContextItemElement)next).getKey().equals(key)) continue;
                value = next;
            }
            this.remove(value);
        }

        @Override
        public String toString() {
            Object result = "";
            for (ContextItem item : this) {
                result = (String)result + item.toString() + ";";
            }
            return result;
        }
    }
}

