/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABComponent;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideABRole
extends ShowHideABComponent {
    public ShowHideABRole(DDiagramContents content_p) {
        super(content_p);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        if (lastContext.getValue() instanceof Role) {
            HashSet<TraceableElement> result = new HashSet<TraceableElement>();
            Role role = (Role)lastContext.getValue();
            for (RoleAllocation allocation : role.getRoleAllocations()) {
                if (!(allocation.getSourceElement() instanceof Entity)) continue;
                result.add(allocation.getSourceElement());
            }
            value.putAll("container", result);
        }
        return value;
    }

    @Override
    protected boolean mustShow(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        if (originCouple_p.getValue() instanceof Role) {
            for (AbstractShowHide.ContextItemView view : originCouple_p.getViews()) {
                if (view.getViews().get("initial").size() <= 0) continue;
                return false;
            }
        }
        return super.mustShow(originCouple_p, context_p, relatedViews_p);
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        if (semantic_p instanceof Role) {
            String mappingName = MappingConstantsHelper.getMappingABRole(this.getContent().getDDiagram());
            mapping = this.getContent().getMapping(mappingName);
        }
        return mapping;
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        return semantic instanceof Role;
    }
}

