/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.diagram.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewRefactorHelper;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.type.DiagramNotationType;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Ratio;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.helper.task.DeleteDRepresentationTask;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ArrangeConstraint;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.business.internal.refresh.SynchronizeGMFModelCommand;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.DiagramDialectArrangeOperation;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.format.data.extension.FormatDataManagerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.utils.RunnableWithBooleanResult;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.ShapeUtil;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;
import org.polarsys.capella.core.transition.diagram.Activator;
import org.polarsys.capella.core.transition.diagram.commands.AbstractProcessingCommands;
import org.polarsys.capella.core.transition.diagram.commands.Messages;
import org.polarsys.capella.core.transition.diagram.handlers.DiagramDescriptionHelper;
import org.polarsys.capella.core.transition.diagram.helpers.TraceabilityHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DiagramTransitionRunnable
extends AbstractProcessingCommands<DDiagram> {
    public static final String TRANSITION_TRACEABILITY = "org.polarsys.capella.core.transition.diagram";
    public static final String SOURCE_DIAGRAM = "SOURCE_DIAGRAM";
    public static final String TARGET_DIAGRAM = "TARGET_DIAGRAM";
    public static final String SOURCE_DESCRIPTION = "SOURCE_DESCRIPTION";
    public static final String TARGET_DESCRIPTION = "TARGET_DESCRIPTION";
    public static final String TARGET_VIEWS = "TARGET__VIEWS";
    public static final String SOURCE_HIDDEN_VIEWS = "SOURCE__HIDDEN_VIEWS";
    public static final String SOURCE_HIDDEN_LABEL_VIEWS = "SOURCE__HIDDEN_LABEL_VIEWS";
    public static final String TARGET_DOUBLE_VIEWS = "SOURCE__HIDDEN_LABEL_VIEWS";
    public static final String DIAGRAM_CREATION = "DIAGRAM_CREATION";
    HashMap<Diagram, DiagramEditPart> diagramsGMF = new HashMap();
    ExtendedViewRefactorHelper helperViewer = new ExtendedViewRefactorHelper();

    public DiagramTransitionRunnable(Collection<DDiagram> elements) {
        super(elements);
    }

    public String getName() {
        return "Diagram Initialization";
    }

    @Override
    protected void init(IProgressMonitor monitor) {
    }

    @Override
    protected void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        IContext context = this.getContext();
        DiagramDescriptionHelper.getService(context).dispose(context);
        TraceabilityHelper.getService(context).dispose(context);
    }

    @Override
    protected void performCommand(Collection<DDiagram> elements, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (elements != null && !elements.isEmpty()) {
            monitor.beginTask(NLS.bind((String)Messages.DiagramTransitionCommand_DescriptionCount, (Object)elements.size()), elements.size());
            for (DDiagram object : elements) {
                try {
                    status = this.proceedDiagram((DRepresentation)object, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    DRepresentation targetDiagram = (DRepresentation)this.getContext().get((Object)TARGET_DIAGRAM);
                    this.checkStatus((DRepresentation)object, targetDiagram, status);
                }
                catch (Exception e) {
                    DRepresentation targetDiagram = (DRepresentation)this.getContext().get((Object)TARGET_DIAGRAM);
                    this.checkStatus((DRepresentation)object, targetDiagram, status);
                }
                monitor.worked(1);
            }
            monitor.done();
        }
    }

    protected void checkStatus(DRepresentation source, DRepresentation target, IStatus status) {
        Logger logger = Logger.getLogger((String)"Diagrams Management");
        ArrayList<DRepresentation> list = new ArrayList<DRepresentation>();
        if (source != null) {
            list.add(source);
        }
        if (target != null) {
            list.add(target);
        }
        EmbeddedMessage message = new EmbeddedMessage(status.getMessage(), "Diagrams Management", list);
        if (status.getSeverity() == 4) {
            logger.error((Object)message);
        } else if (status.getSeverity() == 2) {
            logger.warn((Object)message);
        } else {
            logger.info((Object)message);
        }
    }

    protected HashMapSet<DSemanticDecorator, DSemanticDecorator> getTargetViews(IContext context) {
        if (!context.exists((Object)TARGET_VIEWS)) {
            HashMapSet map = new HashMapSet();
            context.put((Object)TARGET_VIEWS, (Object)map);
        }
        return (HashMapSet)context.get((Object)TARGET_VIEWS);
    }

    protected HashMapSet<DSemanticDecorator, DSemanticDecorator> getHiddenSourceViews(IContext context) {
        if (!context.exists((Object)SOURCE_HIDDEN_VIEWS)) {
            HashMapSet map = new HashMapSet();
            context.put((Object)SOURCE_HIDDEN_VIEWS, (Object)map);
        }
        return (HashMapSet)context.get((Object)SOURCE_HIDDEN_VIEWS);
    }

    protected IStatus proceedDiagram(final DRepresentation diagram, final IProgressMonitor monitor) {
        String diagramName = EObjectExt.getText((EObject)diagram);
        monitor.beginTask(NLS.bind((String)"Diagram Initialization - {0}", (Object)diagramName), 3);
        monitor.setTaskName(NLS.bind((String)"Diagram Initialization - {0}", (Object)diagramName));
        IContext context = this.getContext();
        if (!(diagram instanceof DSemanticDecorator)) {
            return new Status(4, TRANSITION_TRACEABILITY, "Invalid source diagram");
        }
        context.put((Object)SOURCE_DIAGRAM, (Object)diagram);
        final EObject sourceSemantic = ((DSemanticDecorator)diagram).getTarget();
        if (sourceSemantic == null || sourceSemantic.eIsProxy()) {
            return new Status(4, TRANSITION_TRACEABILITY, "Diagram with invalid semantic target");
        }
        final Session session = DiagramHelper.getService().getSession(diagram);
        if (session == null) {
            return new Status(4, TRANSITION_TRACEABILITY, "Cannot retrieve session from the given diagram");
        }
        context.put((Object)"TRANSITION_SOURCE_EDITING_DOMAIN", (Object)session.getTransactionalEditingDomain());
        context.put((Object)"TRANSITION_TARGET_EDITING_DOMAIN", (Object)session.getTransactionalEditingDomain());
        final RepresentationDescription description = DiagramHelper.getService().getDescription(diagram);
        if (description == null || description.eIsProxy()) {
            return new Status(4, TRANSITION_TRACEABILITY, "Invalid source diagram (maybe a missing viewpoint)");
        }
        context.put((Object)SOURCE_DESCRIPTION, (Object)description);
        monitor.worked(1);
        IStatus status = Status.OK_STATUS;
        status = this.runCommand(session, NLS.bind((String)"{0} - {1} (1/3)", (Object)this.getName(), (Object)diagramName), new RunnableWithBooleanResult(){

            public void run() {
                IStatus result = Status.OK_STATUS;
                result = DiagramTransitionRunnable.this.retrieveTargetDiagram(diagram, session, sourceSemantic, description, monitor);
                if (!result.isOK()) {
                    this.setStatus(result);
                    return;
                }
                DRepresentation targetDiagram = (DRepresentation)DiagramTransitionRunnable.this.getContext().get((Object)DiagramTransitionRunnable.TARGET_DIAGRAM);
                result = DiagramTransitionRunnable.this.initializeDiagrams(diagram, targetDiagram);
                if (!result.isOK()) {
                    this.setStatus(result);
                    return;
                }
                result = DiagramTransitionRunnable.this.synchronizeDiagrams(diagram, targetDiagram);
                if (!result.isOK()) {
                    this.setStatus(result);
                    return;
                }
                DiagramTransitionRunnable.this.revealHiddenElements((DSemanticDiagram)diagram, (DSemanticDiagram)targetDiagram);
                this.setStatus(result);
            }
        });
        monitor.worked(1);
        if (!status.isOK()) {
            this.rollbackDiagram(diagram);
            return status;
        }
        status = this.runCommand(session, NLS.bind((String)"{0} - {1} (2/3)", (Object)this.getName(), (Object)diagramName), new RunnableWithBooleanResult(){

            public void run() {
                DRepresentation targetDiagram = (DRepresentation)DiagramTransitionRunnable.this.getContext().get((Object)DiagramTransitionRunnable.TARGET_DIAGRAM);
                DiagramTransitionRunnable.this.copyDDiagramLayout((DSemanticDiagram)diagram, (DSemanticDiagram)targetDiagram, session, DiagramTransitionRunnable.this.getShell());
                this.setStatus(Status.OK_STATUS);
            }
        });
        status = this.runCommand(session, NLS.bind((String)"{0} - {1} (3/3)", (Object)this.getName(), (Object)diagramName), new RunnableWithBooleanResult(){

            public void run() {
                DRepresentation targetDiagram = (DRepresentation)DiagramTransitionRunnable.this.getContext().get((Object)DiagramTransitionRunnable.TARGET_DIAGRAM);
                DiagramTransitionRunnable.this.rearrangeDDiagramLayout((DSemanticDiagram)diagram, (DSemanticDiagram)targetDiagram, session, DiagramTransitionRunnable.this.getShell());
                DiagramTransitionRunnable.this.restoreHiddenElements((DSemanticDiagram)diagram);
                CapellaServices.getService().forceRefresh((DDiagram)targetDiagram);
                DiagramTransitionRunnable.this.finalizeDiagram(diagram, targetDiagram);
                this.setStatus(Status.OK_STATUS);
            }
        });
        if (!status.isOK()) {
            this.rollbackDiagram(diagram);
            return status;
        }
        monitor.worked(1);
        monitor.done();
        DRepresentation targetDiagram = (DRepresentation)this.getContext().get((Object)TARGET_DIAGRAM);
        if (targetDiagram == null) {
            return new Status(4, TRANSITION_TRACEABILITY, "Invalid target diagram");
        }
        return new Status(0, TRANSITION_TRACEABILITY, NLS.bind((String)"Diagram initialized - {0}", (Object)diagramName));
    }

    protected IStatus retrieveTargetDiagram(DRepresentation diagram, Session session, EObject sourceSemantic, RepresentationDescription description, IProgressMonitor monitor) {
        IContext context = this.getContext();
        EObject targetSemantic = null;
        DRepresentation targetDiagram = null;
        RepresentationDescription allocatingDescription = null;
        if (context.exists((Object)TARGET_DIAGRAM)) {
            targetDiagram = (DRepresentation)context.get((Object)TARGET_DIAGRAM);
            context.put((Object)DIAGRAM_CREATION, (Object)Boolean.FALSE);
            if (targetDiagram != null) {
                allocatingDescription = DiagramHelper.getService().getDescription(targetDiagram);
                if (targetDiagram instanceof DSemanticDecorator) {
                    targetSemantic = ((DSemanticDecorator)targetDiagram).getTarget();
                }
            }
        }
        if (allocatingDescription == null) {
            allocatingDescription = DiagramDescriptionHelper.getService(this.getContext()).getTargetDescription(context, session, description);
        }
        if (allocatingDescription == null || allocatingDescription.eIsProxy()) {
            return new Status(4, TRANSITION_TRACEABILITY, NLS.bind((String)"Diagram ''{0}'' is not yet supported by diagram initialization", (Object)EObjectExt.getText((EObject)diagram)));
        }
        context.put((Object)TARGET_DESCRIPTION, (Object)allocatingDescription);
        if (targetSemantic == null) {
            targetSemantic = this.getTargetSemantic(sourceSemantic, description, allocatingDescription);
        }
        if (targetSemantic == null) {
            return new Status(4, TRANSITION_TRACEABILITY, "No semantic element has been found to put the created diagram");
        }
        if (targetDiagram == null) {
            String name = DiagramDescriptionHelper.getService(context).getTargetName(context, diagram, allocatingDescription);
            targetDiagram = DiagramHelper.getService().createDRepresentation(name, targetSemantic, allocatingDescription, session, monitor);
            this.getContext().put((Object)TARGET_DIAGRAM, (Object)targetDiagram);
        }
        if (targetDiagram == null) {
            return new Status(4, TRANSITION_TRACEABILITY, "Cannot create the target diagram");
        }
        return Status.OK_STATUS;
    }

    protected Shell getShell() {
        return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected void finalizeDiagram(DRepresentation diagram, DRepresentation targetDiagram) {
        HashMapSet<DSemanticDecorator, DSemanticDecorator> views = this.getTargetViews(this.getContext());
        HashMapSet<DSemanticDecorator, DSemanticDecorator> hiddens = this.getHiddenSourceViews(this.getContext());
        if (targetDiagram != null && targetDiagram instanceof DDiagram && diagram instanceof DDiagram) {
            ((DDiagram)targetDiagram).setSynchronized(((DDiagram)diagram).isSynchronized());
        }
        views.clear();
        hiddens.clear();
    }

    private IStatus rollbackDiagram(final DRepresentation diagram) {
        Session session = DiagramHelper.getService().getSession(diagram);
        if (session == null) {
            return new Status(4, TRANSITION_TRACEABILITY, "Cannot retrieve session from the given diagram");
        }
        IStatus status = this.runCommand(session, NLS.bind((String)"{0} - {1} (2/2)", (Object)this.getName(), (Object)EObjectExt.getText((EObject)diagram)), new RunnableWithBooleanResult(){

            public void run() {
                DRepresentation targetDiagram = (DRepresentation)DiagramTransitionRunnable.this.getContext().get((Object)DiagramTransitionRunnable.TARGET_DIAGRAM);
                try {
                    DiagramTransitionRunnable.this.restoreHiddenElements((DSemanticDiagram)diagram);
                }
                finally {
                    try {
                        if (!DiagramTransitionRunnable.this.getContext().exists((Object)DiagramTransitionRunnable.DIAGRAM_CREATION) || !Boolean.FALSE.equals(DiagramTransitionRunnable.this.getContext().get((Object)DiagramTransitionRunnable.DIAGRAM_CREATION))) {
                            DiagramTransitionRunnable.this.deleteDiagram(targetDiagram);
                        }
                    }
                    finally {
                        try {
                            DiagramTransitionRunnable.this.finalizeDiagram(diagram, targetDiagram);
                        }
                        finally {
                            this.setStatus(Status.OK_STATUS);
                        }
                    }
                }
            }
        });
        return status;
    }

    protected void deleteDiagram(DRepresentation targetDiagram) {
        DeleteDRepresentationTask task = new DeleteDRepresentationTask(RepresentationHelper.getRepresentationDescriptor((DRepresentation)targetDiagram));
        task.execute();
    }

    protected IStatus initializeDiagrams(DRepresentation sourceDiagram, DRepresentation targetDiagram) {
        RepresentationDescription sourceDescription = DiagramHelper.getService().getDescription(sourceDiagram);
        RepresentationDescription targetDescription = DiagramHelper.getService().getDescription(targetDiagram);
        if (sourceDiagram instanceof DDiagram && targetDiagram instanceof DDiagram) {
            DDiagram srcDiagram = (DDiagram)sourceDiagram;
            DDiagram tgtDiagram = (DDiagram)targetDiagram;
            tgtDiagram.setSynchronized(false);
            for (FilterDescription description : srcDiagram.getActivatedFilters()) {
                FilterDescription filterDescription = DiagramDescriptionHelper.getService(this.getContext()).getTargetFilterDescription(this.getContext(), (DiagramDescription)sourceDescription, (DiagramDescription)targetDescription, description);
                if (filterDescription == null) continue;
                tgtDiagram.getActivatedFilters().add((Object)filterDescription);
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus synchronizeDiagrams(DRepresentation sourceDiagram, DRepresentation targetDiagram) {
        if (sourceDiagram instanceof DDiagram && targetDiagram instanceof DDiagram) {
            EObject sourceSemantic;
            DDiagramContents sourceContents = new DDiagramContents((DDiagram)sourceDiagram);
            DDiagramContents targetContents = new DDiagramContents((DDiagram)targetDiagram);
            HashMapSet<DSemanticDecorator, DSemanticDecorator> map = this.getTargetViews(this.getContext());
            map.put((Object)((DSemanticDecorator)sourceContents.getDDiagram()), (Object)((DSemanticDecorator)targetContents.getDDiagram()));
            DiagramDescription sourceDescription = (DiagramDescription)DiagramHelper.getService().getDescription(sourceDiagram);
            DiagramDescription targetDescription = (DiagramDescription)DiagramHelper.getService().getDescription(targetDiagram);
            for (DDiagramElement element : sourceContents.getDiagramElements()) {
                if (!(element instanceof AbstractDNode)) continue;
                EObject semanticSource = sourceSemantic = element.getTarget();
                Iterator<EObject> iterator = this.getTargetSemantics(semanticSource, (RepresentationDescription)sourceDescription, (RepresentationDescription)targetDescription).iterator();
                while (iterator.hasNext()) {
                    EObject semanticTarget;
                    EObject targetSemantic = semanticTarget = iterator.next();
                    DiagramElementMapping mapping = DiagramDescriptionHelper.getService(this.getContext()).getTargetMapping(this.getContext(), (RepresentationDescription)sourceDescription, (RepresentationDescription)targetDescription, element.getDiagramElementMapping(), semanticSource, semanticTarget);
                    if (mapping == null || !(mapping instanceof AbstractNodeMapping)) continue;
                    for (DDiagramElement target : this.getNodes(sourceDescription, mapping, targetContents, targetSemantic, element)) {
                        map.put((Object)element, (Object)target);
                        this.copyElementView(element, target);
                    }
                }
            }
            for (DDiagramElement element : sourceContents.getDiagramElements()) {
                if (!(element instanceof DEdge)) continue;
                sourceSemantic = element.getTarget();
                for (EObject targetSemantic : this.getTargetSemantics(sourceSemantic, (RepresentationDescription)sourceDescription, (RepresentationDescription)targetDescription)) {
                    DiagramElementMapping mapping = DiagramDescriptionHelper.getService(this.getContext()).getTargetMapping(this.getContext(), (RepresentationDescription)sourceDescription, (RepresentationDescription)targetDescription, element.getDiagramElementMapping(), sourceSemantic, targetSemantic);
                    if (mapping == null || !(mapping instanceof EdgeMapping)) continue;
                    for (DDiagramElement target : this.getEdges(sourceDescription, mapping, targetContents, targetSemantic, element)) {
                        map.put((Object)element, (Object)target);
                        this.copyElementView(element, target);
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected Collection<DDiagramElement> getEdges(DiagramDescription sourceDescription, DiagramElementMapping mapping, DDiagramContents targetContents, EObject targetSemantic, DDiagramElement element) {
        DEdge edge = (DEdge)element;
        ArrayList<DDiagramElement> targetViews = new ArrayList<DDiagramElement>();
        HashMapSet<DSemanticDecorator, DSemanticDecorator> map = this.getTargetViews(this.getContext());
        Collection sourceNodes = map.get((Object)edge.getSourceNode());
        Collection targetNodes = map.get((Object)edge.getTargetNode());
        Collection elements = targetContents.getDiagramElements(targetSemantic, mapping);
        for (DDiagramElement target : elements) {
            map.put((Object)element, (Object)target);
        }
        for (DSemanticDecorator sourceNode : sourceNodes) {
            if (sourceNode == null || !(sourceNode instanceof EdgeTarget)) continue;
            for (DSemanticDecorator targetNode : targetNodes) {
                DDiagramElement targetView;
                if (targetNode == null || !(targetNode instanceof EdgeTarget) || (targetView = DiagramDescriptionHelper.getService(this.getContext()).showEdge(this.getContext(), (RepresentationDescription)sourceDescription, targetContents, (EdgeMapping)mapping, sourceNode, targetNode, targetSemantic)) == null) continue;
                map.put((Object)element, (Object)targetView);
                targetContents.addView(targetView);
                this.copyElementView(element, targetView);
            }
        }
        return targetViews;
    }

    protected Collection<DDiagramElement> getNodes(DiagramDescription sourceDescription, DiagramElementMapping mapping, DDiagramContents targetContents, EObject targetSemantic, DDiagramElement sourceView) {
        ArrayList<DDiagramElement> targetViews = new ArrayList<DDiagramElement>();
        HashMapSet<DSemanticDecorator, DSemanticDecorator> map = this.getTargetViews(this.getContext());
        Collection elements = targetContents.getDiagramElements(targetSemantic, mapping);
        for (DDiagramElement target : elements) {
            map.put((Object)sourceView, (Object)target);
            targetViews.add(target);
        }
        Collection containerNodes = map.get((Object)sourceView.eContainer());
        for (DSemanticDecorator containerNode : containerNodes) {
            BlockArchitecture blockArchitecture;
            Component systemComponent;
            AbstractType targetSemanticComponent;
            if (containerNode == null) continue;
            DSemanticDecorator targetView = DiagramDescriptionHelper.getService(this.getContext()).showNode(this.getContext(), (RepresentationDescription)sourceDescription, targetContents, (AbstractNodeMapping)mapping, containerNode, targetSemantic);
            if (targetView == null && targetSemantic instanceof Part && (targetSemanticComponent = ((Part)targetSemantic).getAbstractType()) instanceof Component && targetSemanticComponent.equals(systemComponent = (blockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)targetSemantic)).getSystem())) {
                targetView = (DSemanticDecorator)targetContents.getDDiagram();
            }
            if (targetView == null) continue;
            map.put((Object)sourceView, (Object)targetView);
            if (!(targetView instanceof DDiagramElement)) continue;
            targetContents.addView((DDiagramElement)targetView);
            this.copyElementView(sourceView, (DDiagramElement)targetView);
        }
        return targetViews;
    }

    private void copyElementView(DDiagramElement element, DDiagramElement targetView) {
        DiagramElementMapping mapping = targetView.getDiagramElementMapping();
        ShapeUtil.copyCustomStyle((DDiagramElement)element, (DDiagramElement)targetView);
        if (targetView instanceof AbstractDNode) {
            AbstractDNode targetNode = (AbstractDNode)targetView;
            if (mapping instanceof ContainerMapping) {
                targetNode.getStyle().setDescription((StyleDescription)((ContainerMapping)mapping).getStyle());
            }
            if (mapping instanceof NodeMapping) {
                targetNode.getStyle().setDescription((StyleDescription)((NodeMapping)mapping).getStyle());
            }
            for (ArrangeConstraint constraint : ((AbstractDNode)element).getArrangeConstraints()) {
                targetNode.getArrangeConstraints().add((Object)constraint);
            }
        } else if (targetView instanceof DEdge) {
            DEdge targetEdge = (DEdge)targetView;
            if (mapping instanceof EdgeMapping) {
                targetEdge.getStyle().setDescription((StyleDescription)((EdgeMapping)mapping).getStyle());
            }
            for (ArrangeConstraint constraint : ((DEdge)element).getArrangeConstraints()) {
                targetEdge.getArrangeConstraints().add((Object)constraint);
            }
        }
        if (element.getTooltipText() != null) {
            targetView.setTooltipText(element.getTooltipText());
        }
    }

    DiagramEditPart loadEditParts(Diagram diagram, Shell shell) {
        DiagramEditPart part = this.diagramsGMF.get(diagram);
        if (part == null) {
            part = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
            this.diagramsGMF.put(diagram, part);
        }
        return this.diagramsGMF.get(diagram);
    }

    Diagram loadGMF(DSemanticDiagram diagram, Session session, boolean sync) {
        Collection sourceDiagrams = this.helperViewer.getReferencingViews((EObject)diagram);
        if (!sourceDiagrams.isEmpty()) {
            Diagram diagramGMF = (Diagram)sourceDiagrams.iterator().next();
            if (sync) {
                CanonicalSynchronizer sourceSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(diagramGMF);
                SynchronizeGMFModelCommand sourceSynchronizerCommand = new SynchronizeGMFModelCommand(session.getTransactionalEditingDomain(), sourceSynchronizer);
                sourceSynchronizerCommand.execute();
            }
            return diagramGMF;
        }
        return null;
    }

    protected void revealHiddenElements(DSemanticDiagram sourceDiagram, DSemanticDiagram targetDiagram) {
        HashMapSet<DSemanticDecorator, DSemanticDecorator> views = this.getTargetViews(this.getContext());
        HashMapSet<DSemanticDecorator, DSemanticDecorator> hiddens = this.getHiddenSourceViews(this.getContext());
        for (DSemanticDecorator sourceView : views.keySet()) {
            if (!(sourceView instanceof DDiagramElement) || !new DDiagramElementQuery((DDiagramElement)sourceView).isHidden()) continue;
            hiddens.put((Object)sourceView, (Object)sourceView);
            CapellaServices.getService().show((DDiagramElement)sourceView);
        }
    }

    protected void restoreHiddenElements(DSemanticDiagram sourceDiagram) {
        HashMapSet<DSemanticDecorator, DSemanticDecorator> views = this.getTargetViews(this.getContext());
        HashMapSet<DSemanticDecorator, DSemanticDecorator> hiddens = this.getHiddenSourceViews(this.getContext());
        for (DSemanticDecorator sourceView : hiddens.keySet()) {
            if (!(sourceView instanceof DDiagramElement)) continue;
            CapellaServices.getService().hide((DDiagramElement)sourceView);
        }
        for (DSemanticDecorator sourceView : views.keySet()) {
            if (!(sourceView instanceof DDiagramElement)) continue;
            if (DiagramServices.getDiagramServices().isHidden((DDiagramElement)sourceView)) {
                for (DSemanticDecorator targetView : views.get((Object)sourceView)) {
                    if (!(targetView instanceof DDiagramElement)) continue;
                    DiagramServices.getDiagramServices().hide((DDiagramElement)targetView);
                }
            }
            if (!DiagramServices.getDiagramServices().isHiddenLabel((DDiagramElement)sourceView)) continue;
            for (DSemanticDecorator targetView : views.get((Object)sourceView)) {
                if (!(targetView instanceof DDiagramElement)) continue;
                DiagramServices.getDiagramServices().hideLabel((DDiagramElement)targetView);
            }
        }
    }

    protected void rearrangeDDiagramLayout(DSemanticDiagram sourceDiagram, DSemanticDiagram targetDiagram, Session session, Shell shell) {
        HashMapSet<DSemanticDecorator, DSemanticDecorator> views = this.getTargetViews(this.getContext());
        for (DSemanticDecorator sourceView : views.keySet()) {
            Collection targetViews = views.get((Object)sourceView);
            if (targetViews.size() <= 1) continue;
            int padding = 0;
            for (DSemanticDecorator targetView : targetViews) {
                Collection sourceDiagrams = this.helperViewer.getReferencingViews((EObject)targetView);
                if (!sourceDiagrams.isEmpty()) {
                    for (Object view : sourceDiagrams) {
                        Bendpoints bendpoints;
                        Node sview;
                        LayoutConstraint targetConstraint;
                        if (view instanceof Node && (targetConstraint = (sview = (Node)view).getLayoutConstraint()) != null && targetConstraint instanceof Location) {
                            Location targetLocation = (Location)targetConstraint;
                            targetLocation.setX(targetLocation.getX() + padding);
                            targetLocation.setY(targetLocation.getY() + padding);
                        }
                        if (!(view instanceof Edge) || (bendpoints = (sview = (Edge)view).getBendpoints()) == null || !(bendpoints instanceof RelativeBendpoints)) continue;
                        RelativeBendpoints bps = (RelativeBendpoints)bendpoints;
                        ArrayList<RelativeBendpoint> cl = new ArrayList<RelativeBendpoint>();
                        for (Object point : bps.getPoints()) {
                            if (!(point instanceof RelativeBendpoint)) continue;
                            RelativeBendpoint bp = (RelativeBendpoint)point;
                            RelativeBendpoint bpE = new RelativeBendpoint(bp.getSourceX() + padding, bp.getSourceY() + padding, bp.getTargetX() + padding, bp.getTargetY() + padding);
                            cl.add(bpE);
                        }
                        bps.setPoints(cl);
                    }
                }
                padding += 30;
            }
        }
    }

    protected void copyDDiagramLayout(DSemanticDiagram sourceDiagram, DSemanticDiagram targetDiagram, Session session, Shell shell) {
        Diagram srcDiagram = this.loadGMF(sourceDiagram, session, false);
        Diagram tgtDiagram = this.loadGMF(targetDiagram, session, true);
        DiagramEditPart sourceEditPart = this.loadEditParts(srcDiagram, shell);
        DiagramEditPart targetEditPart = this.loadEditParts(tgtDiagram, shell);
        List mgrs = FormatDataManagerRegistry.getSiriusFormatDataManagers((DDiagram)sourceDiagram);
        if (!mgrs.isEmpty()) {
            try {
                ((SiriusFormatDataManager)mgrs.iterator().next()).storeFormatData((IGraphicalEditPart)sourceEditPart);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(mgrs = FormatDataManagerRegistry.getSiriusFormatDataManagers((DDiagram)targetDiagram)).isEmpty()) {
            try {
                ((SiriusFormatDataManager)mgrs.iterator().next()).applyLayout((IGraphicalEditPart)targetEditPart);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(mgrs = FormatDataManagerRegistry.getSiriusFormatDataManagers((DDiagram)sourceDiagram)).isEmpty()) {
            try {
                ((SiriusFormatDataManager)mgrs.iterator().next()).clearFormatData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cleanArrangeLayout(targetDiagram, tgtDiagram);
        this.copyNotes(srcDiagram, tgtDiagram, sourceEditPart, targetEditPart);
    }

    protected void cleanArrangeLayout(DSemanticDiagram targetDDiagram, Diagram targetGMFDiagram) {
        new DiagramDialectArrangeOperation().arrange(null, (DDiagram)targetDDiagram);
        SiriusLayoutDataManager.INSTANCE.removeLayoutViews(targetGMFDiagram);
    }

    void copyNotes(Diagram sourceDiagram, Diagram targetDiagram, DiagramEditPart sourceEditPart, DiagramEditPart targetEditPart) {
        LinkedList childs = new LinkedList();
        if (sourceDiagram.getChildren().size() > 0) {
            childs.addAll(sourceDiagram.getChildren());
        }
        while (childs.size() > 0) {
            CreateViewRequest request;
            Object child = childs.removeFirst();
            if (!(child instanceof View)) continue;
            View viewChild = (View)child;
            if (!DiagramNotationType.NOTE.getSemanticHint().equals(viewChild.getType()) || (request = CreateViewRequestFactory.getCreateShapeRequest((IElementType)DiagramNotationType.NOTE, (PreferencesHint)DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT)) == null || !request.getViewDescriptors().iterator().hasNext()) continue;
            targetEditPart.getCommand((Request)request).execute();
            CreateViewRequest.ViewDescriptor descriptor = (CreateViewRequest.ViewDescriptor)request.getViewDescriptors().iterator().next();
            View view = (View)descriptor.getAdapter(View.class);
            this.helperViewer.copyViewChildren(viewChild, view);
            this.helperViewer.copyViewStyle(viewChild, view, view.getStyle(NotationPackage.Literals.SHAPE_STYLE), Collections.emptyList());
            this.helperViewer.copyViewAppearance(viewChild, view, Collections.emptyList());
            if (!(viewChild instanceof Node) || !(view instanceof Node)) continue;
            Node sourceNode = (Node)viewChild;
            Node targetNode = (Node)view;
            Style style = sourceNode.getStyle(NotationPackage.Literals.SHAPE_STYLE);
            if (style != null && style instanceof ShapeStyle) {
                ShapeStyle shapeStyle = (ShapeStyle)style;
                if (view instanceof Shape) {
                    Shape targetShape = (Shape)view;
                    targetShape.setDescription(shapeStyle.getDescription());
                    targetShape.setFillColor(shapeStyle.getFillColor());
                    targetShape.setFontColor(shapeStyle.getFontColor());
                    targetShape.setFontHeight(shapeStyle.getFontHeight());
                    targetShape.setLineColor(shapeStyle.getLineColor());
                    targetShape.setLineWidth(shapeStyle.getLineWidth());
                    targetShape.setRoundedBendpointsRadius(shapeStyle.getRoundedBendpointsRadius());
                    targetShape.setTransparency(shapeStyle.getTransparency());
                }
            }
            if (sourceNode.getLayoutConstraint() == null || targetNode.getLayoutConstraint() == null) continue;
            LayoutConstraint sourceConstraint = sourceNode.getLayoutConstraint();
            LayoutConstraint targetConstraint = targetNode.getLayoutConstraint();
            if (sourceConstraint instanceof Location && targetConstraint instanceof Location) {
                Location sourceLocation = (Location)sourceConstraint;
                Location targetLocation = (Location)targetConstraint;
                targetLocation.setX(sourceLocation.getX());
                targetLocation.setY(sourceLocation.getY());
            }
            if (sourceConstraint instanceof Size && targetConstraint instanceof Size) {
                Size sourceSize = (Size)sourceConstraint;
                Size targetSize = (Size)targetConstraint;
                targetSize.setHeight(sourceSize.getHeight());
                targetSize.setWidth(sourceSize.getWidth());
            }
            if (!(sourceConstraint instanceof Ratio) || !(targetConstraint instanceof Ratio)) continue;
            Ratio sourceRatio = (Ratio)sourceConstraint;
            Ratio targetRatio = (Ratio)targetConstraint;
            targetRatio.setValue(sourceRatio.getValue());
        }
    }

    protected EObject getTargetSemantic(EObject sourceSemantic, RepresentationDescription sourceDescription, RepresentationDescription allocatingDescription) {
        EObject target;
        if (sourceSemantic instanceof TraceableElement && (target = DiagramDescriptionHelper.getService(this.getContext()).getTargetSemantic(this.getContext(), sourceSemantic, sourceDescription, allocatingDescription)) != null) {
            return target;
        }
        return null;
    }

    protected Collection<EObject> getTargetSemantics(EObject sourceSemantic, RepresentationDescription sourceDescription, RepresentationDescription targetDescription) {
        Collection<EObject> target;
        if (sourceSemantic instanceof TraceableElement && !(target = DiagramDescriptionHelper.getService(this.getContext()).getTargetSemantics(this.getContext(), sourceSemantic, sourceDescription, targetDescription)).isEmpty()) {
            return target;
        }
        return Collections.emptyList();
    }

    class ExtendedViewRefactorHelper
    extends ViewRefactorHelper {
        ExtendedViewRefactorHelper() {
        }

        public Diagram createDiagram(Diagram oldDiagram, EObject newElement) {
            return super.createDiagram(oldDiagram, newElement);
        }

        public Collection getReferencingViews(EObject element) {
            Collection views = new EObjectQuery(element).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
            Iterator i = views.iterator();
            block0: while (i.hasNext()) {
                View view = (View)i.next();
                EObject parent = null;
                while ((parent = view.eContainer()) instanceof View) {
                    if (views.contains(parent)) {
                        i.remove();
                        continue block0;
                    }
                    view = (View)parent;
                }
            }
            return views;
        }

        public void copyViewChildren(View oldView, View newView) {
            super.copyViewChildren(oldView, newView);
        }

        public void copyViewStyle(View oldView, View newView, Style oldStyle, List excludeStyles) {
            super.copyViewStyle(oldView, newView, oldStyle, excludeStyles);
        }
    }
}

