/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.common.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.core.common.ui.wizards.LCDWizardPlugin;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionOperations;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionWizard;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItemService;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModelListener;
import org.polarsys.capella.core.ui.toolkit.decomposition.Messages;
import org.polarsys.capella.core.ui.toolkit.dialogs.CapellaWizardDialog;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class LCDecompositionController {
    private DecompositionModel _model;
    private LCDecompositionWizard _wizard;
    public static final String PATH_SEPARATOR = "::";
    private boolean _userHasDeletedSubComponent;

    public List<DecompositionItem> getWrappedInterfaces(LogicalComponent logicalComponent, boolean alreadyDecomposed) {
        ArrayList<DecompositionItem> list = new ArrayList<DecompositionItem>(1);
        List usedInterfaces = ComponentExt.getAllUsedAndRequiredInterfaces((Component)logicalComponent);
        list.addAll(this.getDecompositionItemList(usedInterfaces, true, alreadyDecomposed));
        List implementedInterfaces = ComponentExt.getAllImplementedAndProvidedInterfaces((Component)logicalComponent);
        list.addAll(this.getDecompositionItemList(implementedInterfaces, false, alreadyDecomposed));
        return list;
    }

    public List<DecompositionItem> getWrappedCommunicationLinks(LogicalComponent logicalComponent, boolean alreadyDecomposed) {
        ArrayList<DecompositionItem> list = new ArrayList<DecompositionItem>(1);
        EList communicationLinks = logicalComponent.getOwnedCommunicationLinks();
        list.addAll(this.getDecompositionItemList((List)communicationLinks, true, alreadyDecomposed));
        return list;
    }

    public List<DecompositionItem> getDecompositionItemList(List currentList, boolean isUsed, boolean alreadyDecomposed) {
        ArrayList<DecompositionItem> list = new ArrayList<DecompositionItem>(1);
        for (Object element : currentList) {
            String path = this.getElementPath(element);
            Object name = null;
            if (element instanceof Interface) {
                name = ((Interface)element).getName();
            } else if (element instanceof CommunicationLink) {
                CommunicationLink link = (CommunicationLink)element;
                CommunicationLinkKind kind = link.getKind();
                ExchangeItem exchangeItem = link.getExchangeItem();
                name = "[" + kind.getName() + "] " + exchangeItem.getName() + " (" + String.valueOf(exchangeItem.getExchangeMechanism()) + ")";
                CommunicationLinkProtocol protocol = link.getProtocol();
                if (protocol != CommunicationLinkProtocol.UNSET) {
                    name = (String)name + " [" + String.valueOf(protocol) + "]";
                }
            }
            DecompositionItem item = new DecompositionItem((String)name, element, 2, isUsed, path);
            if (element instanceof Interface) {
                List<DecompositionItemService> listItemSces = this.getDecompositionItemServiceList((List<ExchangeItemAllocation>)((Interface)element).getOwnedExchangeItemAllocations(), item, isUsed);
                item.setServiceItems(listItemSces);
            }
            item.setAlreadyDecomposed(alreadyDecomposed);
            list.add(item);
        }
        return list;
    }

    public List<DecompositionItemService> getDecompositionItemServiceList(List<ExchangeItemAllocation> listOp, DecompositionItem item, boolean used) {
        ArrayList<DecompositionItemService> list = new ArrayList<DecompositionItemService>(1);
        for (ExchangeItemAllocation op : listOp) {
            String path = this.getElementPath(op);
            DecompositionItemService itemSce = new DecompositionItemService(op.getAllocatedItem().getLabel(), (Object)op, used, path);
            itemSce.setParentDecompositionItem(item);
            list.add(itemSce);
        }
        return list;
    }

    public List<Decomposition> getWrappedDecompositions(LogicalComponent logicalComponent) {
        ArrayList<Decomposition> list = new ArrayList<Decomposition>(1);
        if (logicalComponent.getOwnedLogicalArchitectures().isEmpty()) {
            list.add(this.getDecomposition(logicalComponent));
        } else {
            for (LogicalArchitecture logArch : logicalComponent.getOwnedLogicalArchitectures()) {
                list.add(this.getDecomposition(logArch));
            }
        }
        return list;
    }

    public Decomposition getDecomposition(LogicalArchitecture logicalArchitecture) {
        Decomposition decomp = new Decomposition();
        decomp.setName(logicalArchitecture.getName());
        decomp.setValue((Object)logicalArchitecture);
        DecompositionComponent comp = this.createDecompositionComponent((LogicalComponent)logicalArchitecture.getSystem());
        comp.setParentDecomposition(decomp);
        decomp.addTargetComponent(comp);
        return decomp;
    }

    public DecompositionComponent createDecompositionComponent(LogicalComponent component) {
        DecompositionComponent comp = new DecompositionComponent();
        comp.setName(component.getName());
        comp.setValue((Object)component);
        ArrayList<DecompositionItem> items = new ArrayList<DecompositionItem>();
        items.addAll(this.getWrappedInterfaces(component, true));
        items.addAll(this.getWrappedCommunicationLinks(component, true));
        comp.setItems(items);
        comp.setComposite(ComponentExt.isComposite((Component)component));
        if (comp.isReusedComponent()) {
            comp.setPath(this.getElementPath(comp.getReusedTarget()));
        } else {
            comp.setPath(this.getElementPath(comp.getValue()));
        }
        return comp;
    }

    public Decomposition getDecomposition(LogicalComponent logicalComponent) {
        Decomposition decomp = new Decomposition();
        decomp.setName("");
        decomp.setValue(Decomposition.DUMMY_VALUE);
        for (Component tmpComp : ComponentExt.getSubUsedComponents((Component)logicalComponent)) {
            LogicalComponent component = (LogicalComponent)tmpComp;
            DecompositionComponent comp = this.createDecompositionComponent(component);
            boolean flag = false;
            List targetComponents = decomp.getTargetComponents();
            for (DecompositionComponent decompositionComponent : targetComponents) {
                if (!decompositionComponent.getValue().equals(comp.getValue())) continue;
                flag = true;
            }
            if (flag) continue;
            comp.setParentDecomposition(decomp);
            decomp.addTargetComponent(comp);
        }
        return decomp;
    }

    public DecompositionModel createDecompositionModel(LogicalComponent sourceLC) {
        DecompositionComponent sourceComp = new DecompositionComponent();
        sourceComp.setName(sourceLC.getName());
        sourceComp.setValue((Object)sourceLC);
        sourceComp.setSourceComponent(true);
        List<DecompositionItem> tmp = this.getWrappedInterfaces(sourceLC, false);
        tmp.addAll(this.getWrappedCommunicationLinks(sourceLC, false));
        sourceComp.setPath(this.getElementPath(sourceComp.getValue()));
        sourceComp.setItems(tmp);
        this._model = new DecompositionModel(sourceComp);
        LCDecompositionOperations operations = new LCDecompositionOperations();
        operations.setController(this);
        this._model.addDecompositionModelListener((DecompositionModelListener)operations);
        List<Decomposition> decompositions = this.getWrappedDecompositions(sourceLC);
        for (Decomposition decomp : decompositions) {
            this._model.addDecomposition(decomp, true);
            for (DecompositionComponent comp : decomp.getTargetComponents()) {
                comp.setAlreadyDecomposed(true);
                this._model.removeReusedComponent(comp);
            }
        }
        return this._model;
    }

    public boolean isDecompositionComplete() {
        for (Decomposition decomp : this._model.getDecompositions()) {
            if (decomp.getTargetComponents().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean userHasDeletedSubComponent() {
        return this._userHasDeletedSubComponent;
    }

    public void setUserHasDeletedSubComponent(boolean value) {
        this._userHasDeletedSubComponent = value;
    }

    public boolean canFlipToNextPage() {
        return this._model.getDecompositions().size() > 1;
    }

    public void triggerView() {
        this._wizard.trigger();
    }

    public String getElementPath(Object object) {
        NamedElement element = null;
        if (object instanceof NamedElement) {
            element = (NamedElement)object;
        } else if (object instanceof CommunicationLink) {
            element = ((CommunicationLink)object).getExchangeItem();
        }
        if (element != null) {
            SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)element);
            return this.getPath(systemEngineering, element);
        }
        return "";
    }

    public String getPath(SystemEngineering sysEng, NamedElement target) {
        String name;
        String string = name = target instanceof ExchangeItemAllocation ? ((ExchangeItemAllocation)target).getAllocatedItem().getName() : target.getName();
        if (name == null) {
            name = "";
        }
        StringBuffer path = new StringBuffer(name);
        EObject container = target.eContainer();
        if (container instanceof NamedElement) {
            NamedElement parent = (NamedElement)target.eContainer();
            if (parent != sysEng) {
                path.insert(path.indexOf(path.toString()), this.getPath(sysEng, parent) + PATH_SEPARATOR);
            } else {
                path.insert(path.indexOf(path.toString()), parent.getName() + PATH_SEPARATOR);
            }
        }
        return path.toString();
    }

    public DecompositionModel getModel() {
        return this._model;
    }

    public void setModel(DecompositionModel model) {
        this._model = model;
    }

    public void createAndShowDecompositionWizard(LogicalComponent component) {
        this.setWizard(new LCDecompositionWizard());
        this._wizard.setController(this);
        this.createDecompositionModel(component);
        this.getModel().setImgRegistry(LCDWizardPlugin.getDefault().getImageRegistry());
        this._wizard.setDecompositionModel(this.getModel());
        this._wizard.initComponents();
        this._wizard.trigger();
        this._wizard.setWindowTitle(Messages.getString((String)"LCDecomp.window.title"));
        CapellaWizardDialog dlg = new CapellaWizardDialog(Display.getCurrent().getActiveShell(), (IWizard)this._wizard);
        dlg.setPageSize(820, 420);
        dlg.updateSize();
        dlg.open();
    }

    public LCDecompositionWizard getWizard() {
        return this._wizard;
    }

    public void setWizard(LCDecompositionWizard wizard) {
        this._wizard = wizard;
    }
}

