/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageSelector;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageSelectorService;
import org.eclipse.sirius.diagram.ui.business.api.image.WorkspaceImageHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class SetStyleToWorkspaceImageAction
extends Action {
    public static final String SET_STYLE_TO_WORKSPACE_IMAGE_ACTION_ID = "org.eclipse.sirius.diagram.tools.internal.actions.style";
    public static final String SET_STYLE_TO_WORKSPACE_IMAGE_ACTION_NAME = Messages.SetStyleToWorkspaceImageAction_text;

    public SetStyleToWorkspaceImageAction() {
        super(SET_STYLE_TO_WORKSPACE_IMAGE_ACTION_NAME);
        this.setId(SET_STYLE_TO_WORKSPACE_IMAGE_ACTION_ID);
        ImageDescriptor enabledImage = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/image_obj.gif");
        ImageDescriptor disabledImage = ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)1);
        this.setImageDescriptor(enabledImage);
        this.setDisabledImageDescriptor(disabledImage);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        ImageSelector imageSelector = ImageSelectorService.INSTANCE.getImageSelector();
        List<BasicLabelStyle> styles = SetStyleToWorkspaceImageAction.getStyles();
        for (BasicLabelStyle basicLabelStyle : styles) {
            List<String> imagePaths;
            String workspacePath = null;
            BasicLabelStyle basicLabelStyle2 = basicLabelStyle;
            if (basicLabelStyle2 instanceof WorkspaceImage) {
                void img;
                WorkspaceImage cfr_ignored_0 = (WorkspaceImage)basicLabelStyle2;
                WorkspaceImage cfr_ignored_1 = (WorkspaceImage)basicLabelStyle2;
                workspacePath = img.getWorkspacePath();
            }
            if ((imagePaths = imageSelector.selectImages((EObject)basicLabelStyle, ImageSelector.SelectionMode.MONO_SELECTION, workspacePath, false)).size() != 1) continue;
            if (imagePaths.get(0).equals("")) {
                WorkspaceImageHelper.INSTANCE.resetStyle(basicLabelStyle);
                continue;
            }
            WorkspaceImageHelper.INSTANCE.updateStyle(basicLabelStyle, imagePaths.get(0));
        }
    }

    public static List<BasicLabelStyle> getStyles() {
        ArrayList<BasicLabelStyle> styles = new ArrayList<BasicLabelStyle>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiagramElementEditPart diagramElementEditPart;
                DDiagramElement dde;
                DDiagramElementQuery ddeQuery;
                Option oldStyle;
                Object selectedEditPart = objectArray[n2];
                if (selectedEditPart instanceof IDiagramElementEditPart && (oldStyle = (ddeQuery = new DDiagramElementQuery(dde = (diagramElementEditPart = (IDiagramElementEditPart)selectedEditPart).resolveDiagramElement())).getLabelStyle()).some()) {
                    BasicLabelStyle basicLabelStyle = (BasicLabelStyle)oldStyle.get();
                    styles.add(basicLabelStyle);
                }
                ++n2;
            }
        }
        return styles;
    }

    public static boolean selectionCanHaveWorkspaceImage() {
        IStructuredSelection selection;
        boolean result = false;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && page.getSelection() instanceof IStructuredSelection && !(selection = (IStructuredSelection)page.getSelection()).isEmpty()) {
            result = true;
            Iterator it = selection.iterator();
            while (it.hasNext() && result) {
                Object o = it.next();
                if (o instanceof IAbstractDiagramNodeEditPart) {
                    IAbstractDiagramNodeEditPart diagramEditPart = (IAbstractDiagramNodeEditPart)o;
                    View view = (View)diagramEditPart.getModel();
                    EObject element = view.getElement();
                    IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(element);
                    if (permissionAuthority == null || permissionAuthority.canEditInstance(element)) continue;
                    result = false;
                    continue;
                }
                result = false;
            }
        }
        return result;
    }

    public final boolean isEnabled() {
        return SetStyleToWorkspaceImageAction.selectionCanHaveWorkspaceImage();
    }
}

