/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.component;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.validation.component.Messages;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_Component_AllocatedFunctions_1
extends AbstractValidationRule {
    private static final String DOT = ".";
    private static final String TYPE_SUFFIX = ") ";
    private static final String TYPE_PREFIX = " (";

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Component) {
            Component cpnt = (Component)eObj;
            String componentInfo = CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)cpnt);
            for (AbstractFunction fct : cpnt.getAllocatedFunctions()) {
                if (!FunctionExt.isLeaf((AbstractFunction)fct)) {
                    return ctx.createFailureStatus(new Object[]{componentInfo + " " + Messages.getString("MDCHK_Component_AllocatedFunctions_1.allocateNonLeafFunction") + fct.getName() + DOT});
                }
                if (!(cpnt instanceof Entity && !(fct instanceof OperationalActivity) || cpnt instanceof SystemComponent && !(fct instanceof SystemFunction) || cpnt instanceof LogicalComponent && !(fct instanceof LogicalFunction)) && (!(cpnt instanceof PhysicalComponent) || fct instanceof PhysicalFunction)) continue;
                return ctx.createFailureStatus(new Object[]{componentInfo + " " + Messages.getString("MDCHK_Component_AllocatedFunctions_1.allocatesFunction") + fct.getFullLabel() + TYPE_PREFIX + fct.eClass().getName() + TYPE_SUFFIX + Messages.getString("MDCHK_Component_AllocatedFunctions_1.whichIsNotFromTheSameLevel")});
            }
        }
        return ctx.createSuccessStatus();
    }
}

