/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.interface_;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHKComponentInterfaceFunctionPortExchangeItemAllocationConsistency
extends AbstractValidationRule {
    public IStatus validate(IValidationContext context) {
        Component component;
        Collection<IStatus> resultStatuses;
        EObject eObj = context.getTarget();
        if (eObj instanceof Component && !(resultStatuses = this.validateComponent(context, component = (Component)eObj)).isEmpty()) {
            return ConstraintStatus.createMultiStatus((IValidationContext)context, resultStatuses);
        }
        return context.createSuccessStatus();
    }

    private Collection<IStatus> validateComponent(IValidationContext context, Component component) {
        ArrayList<IStatus> resultStatuses = new ArrayList<IStatus>();
        if (!component.getAllocatedFunctions().isEmpty()) {
            boolean isOkForRelatedInterface;
            Set componentFunctionExchangeItems = ComponentExt.getAllocatedFunctionExchangeItems((Component)component);
            Set<AbstractExchangeItem> exchangeItemsForInterfaces = this.getComponentInterfaceExchangeItems(component);
            String prefix = "\"" + component.getName() + "\" ( " + component.eClass().getName() + " ) ";
            boolean isOkForComponent = exchangeItemsForInterfaces.containsAll(componentFunctionExchangeItems);
            if (!isOkForComponent) {
                resultStatuses.add(context.createFailureStatus(new Object[]{context, prefix + "has exchange items allocated to functions ports of its allocated functions not allocated to one of its Interfaces"}));
            }
            if (!(isOkForRelatedInterface = componentFunctionExchangeItems.containsAll(exchangeItemsForInterfaces))) {
                resultStatuses.add(context.createFailureStatus(new Object[]{context, prefix + "has exchange items allocated by its Interfaces not allocated to one of functions ports of its allocated functions"}));
            }
        }
        return resultStatuses;
    }

    private Set<AbstractExchangeItem> getComponentInterfaceExchangeItems(Component component) {
        HashSet<AbstractExchangeItem> exchangeItemsForCurrentInterfaces = new HashSet<AbstractExchangeItem>();
        Collection relatedInterfaces = ComponentExt.getRelatedInterfaces((Component)component);
        for (Interface interfasse : relatedInterfaces) {
            exchangeItemsForCurrentInterfaces.addAll(InterfaceExt.getAllExchangeItems((Interface)interfasse));
        }
        return exchangeItemsForCurrentInterfaces;
    }
}

