/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Bundle;

public class StyledErrorDialog
extends MessageDialog {
    public static boolean openQuestion(Shell parent, String title, String message) {
        return StyledErrorDialog.open(3, parent, title, message, 0);
    }

    public static void openInformation(Shell parent, String title, String message) {
        StyledErrorDialog.open(2, parent, title, message, 0);
    }

    public static void openWarning(Shell parent, String title, String message) {
        StyledErrorDialog.open(4, parent, title, message, 0);
    }

    public static boolean open(int kind, Shell parent, String title, String message, int style) {
        StyledErrorDialog dialog = new StyledErrorDialog(parent, title, null, message, kind, StyledErrorDialog.getButtonLabels(kind), 0);
        int style2 = style & 0x10000000;
        dialog.setShellStyle(dialog.getShellStyle() | style2);
        return dialog.open() == 0;
    }

    static String[] getButtonLabels(int kind) {
        String[] dialogButtonLabels;
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                dialogButtonLabels = new String[]{IDialogConstants.OK_LABEL};
                break;
            }
            case 5: {
                dialogButtonLabels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
                break;
            }
            case 3: {
                dialogButtonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                break;
            }
            case 6: {
                dialogButtonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
            }
        }
        return dialogButtonLabels;
    }

    public StyledErrorDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int imageType, String[] buttonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, imageType, buttonLabels, defaultIndex);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.addAccessibleListeners(this.imageLabel, image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            FormToolkit toolkit = new FormToolkit(Display.getDefault());
            Composite toolkitComp = toolkit.createComposite(composite);
            toolkitComp.setLayout((Layout)new FillLayout(768));
            FormText text = toolkit.createFormText(toolkitComp, false);
            text.setText(this.message, true, true);
            text.setBackground(composite.getBackground());
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)toolkitComp);
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    try {
                        URI uri = URI.create((String)event.data);
                        if ("pref".equals(uri.getScheme())) {
                            HashMap<String, String> para = new HashMap<String, String>();
                            para.put("preferencePageId", uri.getAuthority());
                            Command prefCommand = ((ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class)).getCommand("org.eclipse.ui.window.preferences");
                            prefCommand.executeWithChecks(new ExecutionEvent(prefCommand, para, null, null));
                        }
                    }
                    catch (ExecutionException e) {
                        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport")).log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.importexport", e.getMessage(), (Throwable)e));
                    }
                    catch (NotDefinedException e) {
                        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport")).log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.importexport", e.getMessage(), (Throwable)e));
                    }
                    catch (NotEnabledException e) {
                        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport")).log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.importexport", e.getMessage(), (Throwable)e));
                    }
                    catch (NotHandledException e) {
                        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport")).log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.importexport", e.getMessage(), (Throwable)e));
                    }
                }
            });
        }
        return composite;
    }

    private void addAccessibleListeners(Label label, Image image) {
        label.getAccessible().addAccessibleListener(AccessibleListener.getNameAdapter(event -> {
            String accessibleMessage = this.getAccessibleMessageFor(image);
            if (accessibleMessage == null) {
                return;
            }
            event.result = accessibleMessage;
        }));
    }

    private String getAccessibleMessageFor(Image image) {
        if (image.equals((Object)this.getErrorImage())) {
            return JFaceResources.getString((String)"error");
        }
        if (image.equals((Object)this.getWarningImage())) {
            return JFaceResources.getString((String)"warning");
        }
        if (image.equals((Object)this.getInfoImage())) {
            return JFaceResources.getString((String)"info");
        }
        if (image.equals((Object)this.getQuestionImage())) {
            return JFaceResources.getString((String)"question");
        }
        return null;
    }
}

