/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.ui.dialog;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.polarsys.capella.common.utils.ReflectUtil;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.project.NewProjectWizard;

public class ProjectSelectionDialog
extends ElementTreeSelectionDialog
implements IResourceChangeListener {
    private Button newButton;
    private Label messageLabel;

    public ProjectSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setTitle("Target Capella model selection");
        this.setMessage("Select the target Capella model for the export:");
        this.setHelpAvailable(false);
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    return ProjectSelectionDialog.this.getCapellaProjectFile((IResource)element) != null;
                }
                return false;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentc = (Composite)super.createDialogArea(parent);
        this.newButton = new Button(parentc, 8);
        this.newButton.setText("Create new Project");
        this.newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ProjectSelectionDialog.this.createNewProject();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return parentc;
    }

    public boolean close() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.newButton.dispose();
        return super.close();
    }

    protected Label createMessageArea(Composite composite) {
        this.messageLabel = super.createMessageArea(composite);
        return this.messageLabel;
    }

    protected void createNewProject() {
        NewProjectWizard wizard = new NewProjectWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    protected void computeResult() {
        ArrayList<String> result = new ArrayList<String>();
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        for (Object tmp : selection) {
            if (!(tmp instanceof IResource)) continue;
            result.add(this.getCapellaProjectFile((IResource)tmp));
        }
        this.setResult(result);
    }

    public String getCapellaProjectFile(IResource resource) {
        if (!resource.exists()) {
            return null;
        }
        if (resource instanceof IProject) {
            if (((IProject)resource).isOpen()) {
                IProject project = (IProject)resource;
                IFile file = project.getFile(project.getName() + ".capella");
                if (file.exists()) {
                    return this.getCapellaProjectFile((IResource)file);
                }
                try {
                    IResource[] iResourceArray = project.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (CapellaResourceHelper.isCapellaResource((IResource)member, (boolean)true)) {
                            return this.getCapellaProjectFile(member);
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return null;
        }
        if (CapellaResourceHelper.isCapellaResource((IResource)resource, (boolean)true)) {
            return resource.getFullPath().toString();
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.getTreeViewer().getTree().setEnabled(true);
        this.messageLabel.setEnabled(true);
        try {
            ReflectUtil.setInvisibleFieldValue((Object)((Object)this), (String)"fIsEmpty", (Object)false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        this.refreshDialog(event);
    }

    protected void refreshDialog(IResourceChangeEvent event) {
        this.getTreeViewer().refresh();
        IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            IResource resource = delta.getResource();
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)resource));
            this.getButton(0).forceFocus();
            ++n2;
        }
        this.updateOKStatus();
    }
}

