/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.activities;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.notify.INotifyChangeEvent;
import org.polarsys.capella.core.transition.common.handlers.notify.NotifyHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public abstract class InitializeTransformationActivity
extends AbstractActivity
implements ITransposerWorkflow {
    public static final String ID = "org.polarsys.capella.core.transition.common.activities.InitializeTransformationActivity";

    @Override
    public String getActivityIdentifier() {
        return "initializeTransformation";
    }

    @Override
    public IStatus _run(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        this.initializeTransformation(context, activityParams);
        LogHelper.getInstance().debug(NLS.bind((String)"Start activity ''{0}''", (Object)"Transformation"), Messages.Activity_Transition);
        NotifyHandlerHelper.getInstance(context).notify("NOTIFY__BEGIN_TRANSFORMATION", INotifyChangeEvent.DEFAULT, context);
        return Status.OK_STATUS;
    }

    protected IStatus initializeTraceabilityTransformationHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("TTrH", activityParams);
        if (handler == null) {
            handler = this.createDefaultTraceabilityTransformationHandler();
        }
        context.put((Object)"TTrH", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultTraceabilityTransformationHandler() {
        return ITraceabilityHandler.DEFAULT;
    }

    protected IStatus initializeTransformation(IContext context, ActivityParameters activityParams) {
        IStatus status = Status.OK_STATUS;
        status = this.initializeTraceabilityTransformationHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"TTrH"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeSource(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"SCOPE_SOURCES", "TRANSFORMATION_SOURCE", "_Tr_S_R"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeTarget(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"_Tr_T_R"});
        if (!this.checkStatus(status)) {
            return status;
        }
        context.put((Object)"TH", context.get((Object)"TTrH"));
        status = this.checkParameters(context, new String[]{"TH"});
        if (!this.checkStatus(status)) {
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus verificationRun(IContext context, ActivityParameters activityParams) {
        context.put((Object)"TH", context.get((Object)"TTrH"));
        return super.verificationRun(context, activityParams);
    }

    protected IStatus initializeTarget(IContext context, ActivityParameters activityParams) {
        EObject target = this.createTargetTransformationContainer((Resource)context.get((Object)"_T_T_Res"), context);
        context.put((Object)"_Tr_T_R", (Object)target);
        return Status.OK_STATUS;
    }

    protected abstract EObject createTargetTransformationContainer(Resource var1, IContext var2);

    protected IStatus initializeSource(IContext context, ActivityParameters activityParams) {
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (selection.size() > 0) {
            context.put((Object)"SCOPE_SOURCES", context.get((Object)"TRANSITION_SOURCES"));
            context.put((Object)"TRANSFORMATION_SOURCE", context.get((Object)"TRANSITION_SOURCES"));
            context.put((Object)"_Tr_S_R", context.get((Object)"_TSRo"));
        }
        ContextScopeHandlerHelper.getInstance(context).addAll("IIS_S", selection, context);
        ContextScopeHandlerHelper.getInstance(context).addAll("SOURCE_SCOPE", selection, context);
        return Status.OK_STATUS;
    }
}

