/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.ui.quickfix.resolver;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class DWF_DC_36_Children_To_Closest_Valid_Ancestor_Resolver
extends AbstractCapellaMarkerResolution {
    private static final String RULE_ID = "org.polarsys.capella.core.data.cs.validation.DWF_DC_36";

    public DWF_DC_36_Children_To_Closest_Valid_Ancestor_Resolver() {
        this.setLabel("Move children to their closest valid ancestor");
    }

    public void run(IMarker marker) {
        List elements = this.getModelElements(marker);
        for (EObject element : elements) {
            if (!(element instanceof Component)) continue;
            Component component = (Component)element;
            Set<Component> allSubComponents = DWF_DC_36_Children_To_Closest_Valid_Ancestor_Resolver.getAllSubComponents(component);
            HashSet<Entity> allSubEntities = new HashSet<Entity>();
            HashSet<Part> allSubParts = new HashSet<Part>();
            for (Component subComponent : allSubComponents) {
                if (!(subComponent instanceof Entity)) continue;
                Entity entity = (Entity)subComponent;
                EList parts = entity.getRepresentingParts();
                allSubEntities.add(entity);
                allSubParts.addAll((Collection<Part>)parts);
            }
            EObject closestValidAncestor = DWF_DC_36_Children_To_Closest_Valid_Ancestor_Resolver.getclosestValidAncestor((EObject)component);
            ExecutionManager executionManager = TransactionHelper.getExecutionManager((EObject)component);
            MoveChildrenToClosestValidAncestorCommand command = new MoveChildrenToClosestValidAncestorCommand(closestValidAncestor, allSubEntities, allSubParts);
            executionManager.execute((ICommand)command);
        }
        this.deleteMarker(marker);
    }

    private static Set<Component> getAllSubComponents(Component component) {
        HashSet<Component> allSubComponents = new HashSet<Component>();
        List allSubDefinedComponents = ComponentExt.getAllSubDefinedComponents((Component)component);
        Collection allSubUsedComponents = ComponentExt.getAllSubUsedComponents((Component)component);
        allSubComponents.addAll(allSubDefinedComponents);
        allSubComponents.addAll(allSubUsedComponents);
        allSubComponents.remove(component);
        return allSubComponents;
    }

    private static EObject getclosestValidAncestor(EObject root) {
        EObject parent = root.eContainer();
        while (parent != null) {
            if (ComponentExt.canCreateABActor((EObject)parent)) {
                return parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    protected boolean canResolve(IMarker marker) {
        String markerRuleId = MarkerViewHelper.getRuleID((IMarker)marker, (boolean)true);
        return RULE_ID.equals(markerRuleId);
    }

    private static class MoveChildrenToClosestValidAncestorCommand
    extends AbstractReadWriteCommand {
        private EObject closestValidAncestor;
        private Set<Entity> allSubEntities;
        private Set<Part> allSubParts;

        public MoveChildrenToClosestValidAncestorCommand(EObject closestValidAncestor, Set<Entity> allSubEntities, Set<Part> allSubParts) {
            this.closestValidAncestor = closestValidAncestor;
            this.allSubEntities = allSubEntities;
            this.allSubParts = allSubParts;
        }

        public void run() {
            if (this.closestValidAncestor instanceof Entity) {
                Entity ancestor = (Entity)this.closestValidAncestor;
                ancestor.getOwnedEntities().addAll(this.allSubEntities);
                ancestor.getOwnedFeatures().addAll(this.allSubParts);
            } else if (this.closestValidAncestor instanceof EntityPkg) {
                EntityPkg ancestor = (EntityPkg)this.closestValidAncestor;
                ancestor.getOwnedEntities().addAll(this.allSubEntities);
                ancestor.getOwnedParts().addAll(this.allSubParts);
            }
        }
    }
}

