/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.association;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.util.PropertyNamingHelper;
import org.polarsys.capella.core.model.helpers.AssociationExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class AssociationCompositionProperty
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        Association ass;
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Association && AssociationExt.isComposition((Association)(ass = (Association)eObj))) {
            for (Property property : AssociationExt.getProperties((Association)ass)) {
                AggregationKind aggregationKind = property.getAggregationKind();
                if (aggregationKind == null || aggregationKind == AggregationKind.COMPOSITION) continue;
                NumericValue ownedMinCard = property.getOwnedMinCard();
                NumericValue ownedMaxCard = property.getOwnedMaxCard();
                String min = "";
                String max = "";
                min = PropertyNamingHelper.getCardValue((NumericValue)ownedMinCard);
                max = PropertyNamingHelper.getCardValue((NumericValue)ownedMaxCard);
                if (min == null || max == null || (min.equalsIgnoreCase("0") || min.equalsIgnoreCase("1")) && max.equalsIgnoreCase("1")) continue;
                String actual = "{" + min + "," + max + "}";
                String expected = "{0,1} or {1,1}";
                return ctx.createFailureStatus(new Object[]{ass.getName(), property.getName(), actual, expected});
            }
        }
        return ctx.createSuccessStatus();
    }
}

