/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.export.prefs;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.polarsys.capella.common.helpers.export.DataExporter;
import org.polarsys.capella.common.helpers.export.IExporterProvider;
import org.polarsys.capella.core.commands.preferences.service.AbstractDefaultPreferencePage;
import org.polarsys.capella.core.validation.CapellaValidationActivator;
import org.polarsys.capella.core.validation.export.ExportUtils;
import org.polarsys.capella.core.validation.export.RulesExporterProvider;
import org.polarsys.capella.core.validation.ui.export.prefs.PrefsMessages;

public class ExportValidationPreferencePage
extends AbstractDefaultPreferencePage {
    protected IPreferenceStore doGetPreferenceStore() {
        ScopedPreferenceStore preferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), CapellaValidationActivator.getDefault().getPluginId());
        return preferences;
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.createExportGroup(parent);
    }

    private void createExportGroup(Composite parent) {
        Group group = this.createGroup(PrefsMessages.exportGroupTitle, PrefsMessages.exportGroupToolTip, parent);
        BooleanFieldEditor bfe1 = new BooleanFieldEditor("validation.rules.export.capella.only.exe", PrefsMessages.selectCapellaRulesOnlyLabel, (Composite)group);
        this.addField((FieldEditor)bfe1);
        BooleanFieldEditor bfe2 = new BooleanFieldEditor("validation.rules.export.active.only.exe", PrefsMessages.selectActiveRulesOnlyLabel, (Composite)group);
        this.addField((FieldEditor)bfe2);
        Button button = new Button((Composite)group, 0);
        button.setText(PrefsMessages.exportButtonLabel);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportValidationPreferencePage.this.exportPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ExportValidationPreferencePage.this.exportPressed();
            }
        });
    }

    protected void exportPressed() {
        String selectedFilter;
        String fileExtension;
        RulesExporterProvider exporterProvider = new RulesExporterProvider();
        DataExporter dataExporter = new DataExporter((IExporterProvider)exporterProvider);
        this.performApply();
        FileDialog fd = new FileDialog(this.getShell(), 8192);
        fd.setText(PrefsMessages.fileBrowserDialogTitle);
        fd.setFilterExtensions(dataExporter.getSupportedExtension());
        fd.setFilterNames(dataExporter.getSupportedDescription());
        Object fileName = fd.open();
        int filterIndex = fd.getFilterIndex();
        if (filterIndex != -1 && !((String)fileName).endsWith(fileExtension = (selectedFilter = fd.getFilterExtensions()[filterIndex]).substring(1))) {
            fileName = (String)fileName + fileExtension;
        }
        if (fileName != null) {
            boolean result = ExportUtils.exportValidationRules((DataExporter)dataExporter, (String)fileName);
            if (result) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)PrefsMessages.exportValidationRulesMessages, (String)NLS.bind((String)PrefsMessages.exportOk, (Object)fileName));
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)PrefsMessages.exportValidationRulesMessages, (String)NLS.bind((String)PrefsMessages.exportKo, (Object)fileName));
            }
        }
    }

    protected String getPageDescription() {
        return PrefsMessages.exportPageDesc;
    }

    protected String getPageTitle() {
        return PrefsMessages.exportPageTitle;
    }
}

