/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.TransferTreeListDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ComponentPortKind;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.properties.dialogs.Messages;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.ui.properties.providers.CapellaTransfertViewerLabelProvider;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;

public class SelectFunctionalExchangeDialog
extends SelectElementsDialog {
    private List<EObject> _allocatedExchangeItems;
    private Text _allocatedExchangeItemsText;
    private Button createNewExchangeButton;
    private Button _instanceLevelExchangeCheckBox;
    private static boolean _lastTypeLevelValue = false;
    private DataflowDialogCreationType _creationType;
    private List<? extends EObject> _displayedElements;
    private Text functionalExchangeText;
    private SequenceMessage _sequenceMessage;
    private Button _sourceFunctionButton;
    private Button _sourceFunctionClearButton;
    public HashMap<ListenerType, AbstractNamedElement> _cache = new HashMap();
    private Text sourceFunctionName;
    private Button _targetFunctionButton;
    private Button _targetFunctionClearButton;
    private Text targetFunctionName;
    private InstanceRole _targetIR;
    private InstanceRole _sourceIR;

    public SelectFunctionalExchangeDialog(Shell parentShell, String dialogTitle, String dialogMessage, List<? extends EObject> displayedElements, SequenceMessage message, InstanceRole sourceIR, InstanceRole targetIR, DataflowDialogCreationType creationType) {
        super(parentShell, (DataLabelProvider)new CapellaTransfertViewerLabelProvider(), dialogTitle, dialogMessage, displayedElements, false, null, -1);
        this._sequenceMessage = message;
        this._displayedElements = displayedElements;
        this._creationType = creationType;
        this._allocatedExchangeItems = new ArrayList<EObject>();
        this._sourceIR = sourceIR;
        this._targetIR = targetIR;
    }

    private void configureSelectExchangeButtonHandler() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectFunctionalExchangeDialog.this.updateWindow();
            }
        };
        this.createNewExchangeButton.addSelectionListener((SelectionListener)listener);
        if (this._displayedElements.isEmpty()) {
            this.createNewExchangeButton.setSelection(true);
        } else {
            this.createNewExchangeButton.setSelection(false);
        }
    }

    public void create() {
        super.create();
        if (this.sourceFunctionName != null) {
            this.getShell().setMinimumSize(661, 720);
        } else {
            this.getShell().setMinimumSize(661, 650);
        }
    }

    private void createCompleteHeaderEditPart(Group treeViewerPartGroup) {
        InstanceRole ir = this._sourceIR != null ? this._sourceIR : this._targetIR;
        FunctionPkg function = this.getFunctionPkgFromInstanceRole(ir);
        String treeViewerLabel = Messages.ExchangeDialog_CreateFunctionalExchangeGroup;
        String buttonLabel = Messages.ExchangeDialog_CreateFunctionalExchangeCheckbox;
        String exchangeLabel = Messages.ExchangeDialog_FunctionalExchangeLabel;
        String sourceLabel = Messages.ExchangeDialog_SourceFunctionLabel;
        String targetLabel = Messages.ExchangeDialog_TargetFunctionLabel;
        if (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)ir)) {
            treeViewerLabel = Messages.ExchangeDialog_CreateInteractionGroup;
            buttonLabel = Messages.ExchangeDialog_CreateInteractionCheckbox;
            exchangeLabel = Messages.ExchangeDialog_InteractionLabel;
            sourceLabel = Messages.ExchangeDialog_SourceActivityLabel;
            targetLabel = Messages.ExchangeDialog_TargetActivityLabel;
        }
        treeViewerPartGroup.setText(treeViewerLabel);
        treeViewerPartGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        treeViewerPartGroup.setLayout((Layout)new GridLayout(4, false));
        this.createNewExchangeButton = new Button((Composite)treeViewerPartGroup, 32);
        this.createNewExchangeButton.setText(buttonLabel);
        GridData layoutData = new GridData(4, 1, false, false);
        layoutData.horizontalSpan = 4;
        this.createNewExchangeButton.setLayoutData((Object)layoutData);
        this.createLabel((Composite)treeViewerPartGroup, exchangeLabel);
        this.functionalExchangeText = this.createText((Composite)treeViewerPartGroup);
        ((GridData)this.functionalExchangeText.getLayoutData()).horizontalSpan = 3;
        Component sourceComponent = this._sourceIR == null ? null : (Component)this._sourceIR.getRepresentedInstance().getAbstractType();
        Component targetComponent = this._targetIR == null ? null : (Component)this._targetIR.getRepresentedInstance().getAbstractType();
        this.createLabel((Composite)treeViewerPartGroup, sourceLabel);
        this.sourceFunctionName = this.createText((Composite)treeViewerPartGroup);
        this._sourceFunctionButton = new Button((Composite)treeViewerPartGroup, 8);
        this._sourceFunctionButton.setImage(ToolkitPlugin.getDefault().getImageRegistry().get("toolitem.browse"));
        this._sourceFunctionButton.addSelectionListener((SelectionListener)new FunctionSelectionListener(this.sourceFunctionName, function, sourceComponent, ListenerType.SOURCE));
        this._sourceFunctionClearButton = new Button((Composite)treeViewerPartGroup, 8);
        this._sourceFunctionClearButton.setImage(ToolkitPlugin.getDefault().getImageRegistry().get("toolitem.remove"));
        this._sourceFunctionClearButton.addSelectionListener((SelectionListener)new FunctionClearListener(this.sourceFunctionName, ListenerType.SOURCE));
        this.createLabel((Composite)treeViewerPartGroup, targetLabel);
        this.targetFunctionName = this.createText((Composite)treeViewerPartGroup);
        this._targetFunctionButton = new Button((Composite)treeViewerPartGroup, 8);
        this._targetFunctionButton.setImage(ToolkitPlugin.getDefault().getImageRegistry().get("toolitem.browse"));
        this._targetFunctionButton.addSelectionListener((SelectionListener)new FunctionSelectionListener(this.targetFunctionName, function, targetComponent, ListenerType.TARGET));
        this._targetFunctionClearButton = new Button((Composite)treeViewerPartGroup, 8);
        this._targetFunctionClearButton.setImage(ToolkitPlugin.getDefault().getImageRegistry().get("toolitem.remove"));
        this._targetFunctionClearButton.addSelectionListener((SelectionListener)new FunctionClearListener(this.targetFunctionName, ListenerType.TARGET));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectFunctionalExchangeDialog.this.updateButtons(null);
            }
        };
        this.sourceFunctionName.addModifyListener(modifyListener);
        this.targetFunctionName.addModifyListener(modifyListener);
        this.functionalExchangeText.addModifyListener(modifyListener);
    }

    private void disableDirectCreationForNode(Group headerGroup) {
        boolean isPhysicalArchitecture;
        Component sourceComponent = this._sourceIR == null ? null : (Component)this._sourceIR.getRepresentedInstance().getAbstractType();
        Component targetComponent = this._targetIR == null ? null : (Component)this._targetIR.getRepresentedInstance().getAbstractType();
        boolean isPhysicalComponentSorceOrTarget = sourceComponent != null && targetComponent != null && sourceComponent instanceof PhysicalComponent && targetComponent instanceof PhysicalComponent;
        BlockArchitecture sourceBlockArchitecture = ComponentExt.getRootBlockArchitecture((ModelElement)sourceComponent);
        BlockArchitecture targetBlockArchitecture = ComponentExt.getRootBlockArchitecture((ModelElement)targetComponent);
        boolean bl = isPhysicalArchitecture = sourceBlockArchitecture != null && targetBlockArchitecture != null && sourceBlockArchitecture instanceof PhysicalArchitecture && targetBlockArchitecture instanceof PhysicalArchitecture;
        if (isPhysicalComponentSorceOrTarget && isPhysicalArchitecture) {
            PhysicalComponent sourcePhysicalComponent = (PhysicalComponent)sourceComponent;
            PhysicalComponent targetPhysicalComponent = (PhysicalComponent)targetComponent;
            boolean isNodeSourceOrTarget = sourcePhysicalComponent.getNature().equals((Object)PhysicalComponentNature.NODE) && !ComponentExt.isActor((Component)sourcePhysicalComponent) || targetPhysicalComponent.getNature().equals((Object)PhysicalComponentNature.NODE) && !ComponentExt.isActor((Component)targetPhysicalComponent);
            this.disableInputText(headerGroup, !isNodeSourceOrTarget);
        } else {
            this.disableInputText(headerGroup, true);
        }
    }

    private void disableInputText(Group headerGroup, boolean isEditable) {
        Control[] controls;
        Control[] controlArray = controls = headerGroup.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Text) {
                Text currentText = (Text)control;
                currentText.setEditable(isEditable);
            } else if (control instanceof Button) {
                Button currentControl = (Button)control;
                currentControl.setEnabled(isEditable);
            }
            ++n2;
        }
    }

    private FunctionPkg getFunctionPkgFromInstanceRole(InstanceRole ir) {
        InstanceRole obj = ir;
        while (!(obj instanceof BlockArchitecture)) {
            obj = obj.eContainer();
        }
        return ((BlockArchitecture)obj).getOwnedFunctionPkg();
    }

    private void createSimpleHeaderEditPart(Group treeViewerPartGroup) {
        String exchangeLabel;
        String buttonLabel;
        String treeViewerLabel;
        if (this._creationType == DataflowDialogCreationType.COMPONENT_EXCHANGE) {
            treeViewerLabel = Messages.ExchangeDialog_CreateComponentExchangeGroup;
            buttonLabel = Messages.ExchangeDialog_CreateComponentExchangeCheckbox;
            exchangeLabel = Messages.ExchangeDialog_ComponentExchangeLabel;
        } else {
            treeViewerLabel = Messages.ExchangeDialog_CreateFunctionalExchangeGroup;
            buttonLabel = Messages.ExchangeDialog_CreateFunctionalExchangeCheckbox;
            exchangeLabel = Messages.ExchangeDialog_FunctionalExchangeLabel;
            if (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)this._sourceIR)) {
                treeViewerLabel = Messages.ExchangeDialog_CreateInteractionGroup;
                buttonLabel = Messages.ExchangeDialog_CreateInteractionCheckbox;
                exchangeLabel = Messages.ExchangeDialog_InteractionLabel;
            }
        }
        treeViewerPartGroup.setText(treeViewerLabel);
        treeViewerPartGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        treeViewerPartGroup.setLayout((Layout)new GridLayout(3, false));
        this.createNewExchangeButton = new Button((Composite)treeViewerPartGroup, 32);
        this.createNewExchangeButton.setText(buttonLabel);
        GridData layoutData = new GridData(4, 1, false, false);
        layoutData.horizontalSpan = 3;
        this.createNewExchangeButton.setLayoutData((Object)layoutData);
        this.createNewExchangeButton.setEnabled(true);
        this.createLabel((Composite)treeViewerPartGroup, exchangeLabel);
        this.functionalExchangeText = this.createText((Composite)treeViewerPartGroup);
        ((GridData)this.functionalExchangeText.getLayoutData()).horizontalSpan = 2;
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectFunctionalExchangeDialog.this.updateButtons(null);
            }
        };
        this.functionalExchangeText.addModifyListener(modifyListener);
        CapellaProjectHelper.TriStateBoolean isMultipart = CapellaProjectHelper.isReusableComponentsDriven((EObject)this._sourceIR);
        if (isMultipart.equals((Object)CapellaProjectHelper.TriStateBoolean.True) && this._creationType == DataflowDialogCreationType.COMPONENT_EXCHANGE && !CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)this._sourceIR)) {
            this.createLabel((Composite)treeViewerPartGroup, "Component Exchange between types");
            this._instanceLevelExchangeCheckBox = new Button((Composite)treeViewerPartGroup, 32);
            this._instanceLevelExchangeCheckBox.setSelection(_lastTypeLevelValue);
        }
    }

    protected void doCreateDialogArea(Composite parent) {
        if (!this.isLostFoundContext()) {
            Group headerGroup = new Group(parent, 0);
            if (this._creationType == DataflowDialogCreationType.COMPONENT_EXCHANGE || this._creationType == DataflowDialogCreationType.FUNCTIONAL_EXCHANGE_SCENARIO) {
                this.createSimpleHeaderEditPart(headerGroup);
            } else {
                this.createCompleteHeaderEditPart(headerGroup);
            }
            this.disableDirectCreationForNode(headerGroup);
        }
        super.doCreateDialogArea(parent);
        if (!this.isLostFoundContext()) {
            this.configureSelectExchangeButtonHandler();
        }
        this.updateWindow();
    }

    private boolean isLostFoundContext() {
        return this._sourceIR == null || this._targetIR == null;
    }

    private AbstractFunction ensureFunction(Text sourceFunctionName, AbstractFunction parent) {
        if (sourceFunctionName.getData() != null) {
            return (AbstractFunction)sourceFunctionName.getData();
        }
        SystemFunction result = null;
        if (parent instanceof SystemFunction) {
            result = CtxFactory.eINSTANCE.createSystemFunction();
        } else if (parent instanceof LogicalFunction) {
            result = LaFactory.eINSTANCE.createLogicalFunction();
        } else if (parent instanceof PhysicalFunction) {
            result = PaFactory.eINSTANCE.createPhysicalFunction();
        } else if (parent instanceof OperationalActivity) {
            result = OaFactory.eINSTANCE.createOperationalActivity();
        }
        if (result != null) {
            parent.getOwnedFunctions().add((Object)result);
            CapellaElementExt.creationService((EObject)result);
            result.setName(sourceFunctionName.getText());
        }
        return result;
    }

    private void ensureFunctionRealization(Component component, AbstractFunction func) {
        boolean found = false;
        for (ComponentFunctionalAllocation alloc : component.getFunctionalAllocations()) {
            if (alloc.getFunction() != func) continue;
            found = true;
        }
        if (!found) {
            ComponentFunctionalAllocation cfa = FaFactory.eINSTANCE.createComponentFunctionalAllocation();
            component.getOwnedFunctionalAllocation().add((Object)cfa);
            cfa.setTargetElement((TraceableElement)func);
            cfa.setSourceElement((TraceableElement)component);
            CapellaElementExt.creationService((EObject)cfa);
        }
    }

    private FunctionalExchange ensureFunctions(Text sourceFunctionName, Text targetFunctionName, Text functionalExchangeText) {
        AbstractFunction root = BlockArchitectureExt.getRootFunction((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)(this._sourceIR != null ? this._sourceIR : this._targetIR)));
        AbstractFunction srcFunc = this.ensureFunction(sourceFunctionName, root);
        AbstractFunction tgtFunc = this.ensureFunction(targetFunctionName, root);
        FunctionalExchange fe = FunctionalExchangeExt.createFunctionalExchange((ActivityNode)srcFunc, (ActivityNode)tgtFunc);
        fe.setName(functionalExchangeText.getText());
        if (this._sourceIR != null) {
            if (this._sourceIR.getRepresentedInstance() instanceof Role) {
                Role srcRole = (Role)this._sourceIR.getRepresentedInstance();
                this.ensureFunctionRealization(srcRole, srcFunc);
            } else {
                AbstractType srcComponent = this._sourceIR.getRepresentedInstance().getAbstractType();
                this.ensureFunctionRealization((Component)srcComponent, srcFunc);
            }
        }
        if (this._targetIR != null) {
            if (this._targetIR.getRepresentedInstance() instanceof Role) {
                Role tgtRole = (Role)this._targetIR.getRepresentedInstance();
                this.ensureFunctionRealization(tgtRole, tgtFunc);
            } else {
                AbstractType tgtComponent = this._targetIR.getRepresentedInstance().getAbstractType();
                this.ensureFunctionRealization((Component)tgtComponent, tgtFunc);
            }
        }
        return fe;
    }

    private void ensureFunctionRealization(Role role, AbstractFunction func) {
        boolean found = false;
        for (ActivityAllocation alloc : role.getOwnedActivityAllocations()) {
            if (alloc.getActivity() != func) continue;
            found = true;
        }
        if (!found) {
            ActivityAllocation cfa = OaFactory.eINSTANCE.createActivityAllocation();
            role.getOwnedActivityAllocations().add((Object)cfa);
            cfa.setTargetElement((TraceableElement)func);
            cfa.setSourceElement((TraceableElement)role);
            CapellaElementExt.creationService((EObject)cfa);
        }
    }

    protected EClass getCreatedEClass() {
        if (this._creationType == DataflowDialogCreationType.COMPONENT_EXCHANGE) {
            return FaPackage.Literals.COMPONENT_EXCHANGE;
        }
        return FaPackage.Literals.FUNCTIONAL_EXCHANGE;
    }

    protected EReference getExchangeItemReference(EClass clazz) {
        if (FaPackage.Literals.FUNCTIONAL_EXCHANGE.equals(clazz)) {
            return FaPackage.Literals.FUNCTIONAL_EXCHANGE__EXCHANGED_ITEMS;
        }
        return ModellingcorePackage.Literals.ABSTRACT_INFORMATION_FLOW__CONVOYED_INFORMATIONS;
    }

    protected List<? extends EObject> handleResult() {
        if (this.createNewExchangeButton != null && this.createNewExchangeButton.getSelection()) {
            if (this._creationType == DataflowDialogCreationType.FUNCTIONAL_EXCHANGE) {
                FunctionalExchange fe = this.ensureFunctions(this.sourceFunctionName, this.targetFunctionName, this.functionalExchangeText);
                return Collections.singletonList(fe);
            }
            if (this._creationType == DataflowDialogCreationType.COMPONENT_EXCHANGE && this._sourceIR != null && this._targetIR != null) {
                CommunicationMean componentExchange = null;
                Component srcComponent = (Component)this._sourceIR.getRepresentedInstance().getAbstractType();
                Component tgtComponent = (Component)this._targetIR.getRepresentedInstance().getAbstractType();
                if (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)this._sourceIR)) {
                    componentExchange = OaFactory.eINSTANCE.createCommunicationMean();
                    componentExchange.setSource((InformationsExchanger)((Entity)srcComponent));
                    componentExchange.setTarget((InformationsExchanger)((Entity)tgtComponent));
                } else {
                    boolean isNotMultipart = true;
                    if (this._instanceLevelExchangeCheckBox != null) {
                        _lastTypeLevelValue = isNotMultipart = this._instanceLevelExchangeCheckBox.getSelection();
                    }
                    componentExchange = ComponentExchangeExt.createComponentExchange((Part)((Part)this._sourceIR.getRepresentedInstance()), null, (Part)((Part)this._targetIR.getRepresentedInstance()), null, (ComponentExchangeKind)ComponentExchangeKind.FLOW, (ComponentPortKind)ComponentPortKind.FLOW, (OrientationPortKind)OrientationPortKind.OUT, (ComponentPortKind)ComponentPortKind.FLOW, (OrientationPortKind)OrientationPortKind.IN, (!isNotMultipart ? 1 : 0) != 0);
                }
                ComponentExchangeExt.attachToDefaultContainer((ComponentExchange)componentExchange);
                CapellaElementExt.creationService((EObject)componentExchange);
                componentExchange.setName(this.functionalExchangeText.getText());
                this.saveExchangeItems((EObject)componentExchange);
                return Collections.singletonList(componentExchange);
            }
            if (this._creationType == DataflowDialogCreationType.FUNCTIONAL_EXCHANGE_SCENARIO && this._sourceIR != null && this._targetIR != null) {
                ActivityNode srcFunction = (ActivityNode)this._sourceIR.getRepresentedInstance();
                ActivityNode dstFunction = (ActivityNode)this._targetIR.getRepresentedInstance();
                FunctionalExchange fe = FunctionalExchangeExt.createFunctionalExchange((ActivityNode)srcFunction, (ActivityNode)dstFunction);
                fe.setName(this.functionalExchangeText.getText());
                this.saveExchangeItems((EObject)fe);
                return Collections.singletonList(fe);
            }
        }
        return super.handleResult();
    }

    protected boolean isOkToClose(ISelection selection) {
        if (this.createNewExchangeButton == null) {
            return this.getViewer().getSelection() != null && !this.getViewer().getSelection().isEmpty();
        }
        if (!this.createNewExchangeButton.getSelection() && this.getViewer().getSelection() != null && !this.getViewer().getSelection().isEmpty()) {
            return super.isOkToClose(selection);
        }
        if (this._creationType == DataflowDialogCreationType.COMPONENT_EXCHANGE || this._creationType == DataflowDialogCreationType.FUNCTIONAL_EXCHANGE_SCENARIO) {
            return !this.functionalExchangeText.getText().equals("");
        }
        return !this.functionalExchangeText.getText().equals("") && !this.sourceFunctionName.getText().equals("") && !this.targetFunctionName.getText().equals("");
    }

    public int open() {
        return super.open();
    }

    private void saveExchangeItems(EObject object) {
        EReference reference = this.getExchangeItemReference(object.eClass());
        if (this._allocatedExchangeItems != null && reference != null && reference.isMany()) {
            List value = (List)object.eGet((EStructuralFeature)reference);
            for (EObject item : new ArrayList(value)) {
                if (this._allocatedExchangeItems.contains(item)) continue;
                value.remove(item);
            }
            for (EObject item : this._allocatedExchangeItems) {
                if (value.contains(item)) continue;
                value.add(item);
            }
        }
    }

    public void updateButtons(ISelection selection) {
        EReference reference;
        Object element;
        super.updateButtons(selection);
        ArrayList<EObject> exchangeItems = new ArrayList<EObject>();
        if (selection instanceof TreeSelection && (element = ((TreeSelection)selection).getFirstElement()) instanceof EObject && (reference = this.getExchangeItemReference(((EObject)element).eClass())) != null && reference.isMany() && EcoreUtil2.isEqualOrSuperClass((EClass)reference.getEContainingClass(), (EClass)((EObject)element).eClass())) {
            exchangeItems.addAll((List)((EObject)element).eGet((EStructuralFeature)reference));
        }
        this.updateExchangeItems(exchangeItems);
    }

    private void updateExchangeItems(List<EObject> resultObjects) {
        if (resultObjects != null) {
            this._allocatedExchangeItems = resultObjects;
            Object textDescription = "";
            int i = 0;
            while (i < this._allocatedExchangeItems.size() - 1) {
                textDescription = (String)textDescription + EObjectLabelProviderHelper.getText((Object)this._allocatedExchangeItems.get(i)) + ", ";
                ++i;
            }
            if (!this._allocatedExchangeItems.isEmpty()) {
                textDescription = (String)textDescription + EObjectLabelProviderHelper.getText((Object)this._allocatedExchangeItems.get(this._allocatedExchangeItems.size() - 1));
            }
            if (this._allocatedExchangeItemsText != null) {
                this._allocatedExchangeItemsText.setText((String)textDescription);
            }
        }
    }

    void updateWindow() {
        if (this.createNewExchangeButton != null) {
            boolean newExchange = this.createNewExchangeButton.isEnabled() && this.createNewExchangeButton.getSelection();
            this.functionalExchangeText.setEnabled(newExchange);
            if (this.sourceFunctionName != null) {
                this.sourceFunctionName.setEnabled(newExchange);
                this.targetFunctionName.setEnabled(newExchange);
                this._sourceFunctionButton.setEnabled(newExchange);
                this._sourceFunctionClearButton.setEnabled(newExchange);
                this._targetFunctionButton.setEnabled(newExchange);
                this._targetFunctionClearButton.setEnabled(newExchange);
            }
            TreeAndListViewer viewer = this.getViewer();
            ISelection selection = null;
            if (viewer != null) {
                viewer.setEnabled(!newExchange);
                if (!newExchange) {
                    selection = viewer.getSelection();
                }
            }
            if (this._instanceLevelExchangeCheckBox != null) {
                this._instanceLevelExchangeCheckBox.setEnabled(newExchange);
            }
            this.updateButtons(selection);
        }
    }

    public static enum DataflowDialogCreationType {
        COMPONENT_EXCHANGE,
        FUNCTIONAL_EXCHANGE,
        FUNCTIONAL_EXCHANGE_SCENARIO;

    }

    public class ExchangeItemSelectionListener
    extends SelectionAdapter {
        CapellaElement element;

        public ExchangeItemSelectionListener(CapellaElement component) {
            this.element = component;
        }

        protected List<EObject> getAvailableElements() {
            ArrayList<EObject> returnedList = new ArrayList<EObject>();
            EClass createdEClass = SelectFunctionalExchangeDialog.this.getCreatedEClass();
            IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(createdEClass, (EStructuralFeature)SelectFunctionalExchangeDialog.this.getExchangeItemReference(createdEClass));
            if (query != null) {
                returnedList.addAll(query.getAvailableElements((EObject)this.element));
                returnedList.removeAll(this.getCurrentElements());
            }
            return returnedList;
        }

        protected List<EObject> getCurrentElements() {
            return SelectFunctionalExchangeDialog.this._allocatedExchangeItems;
        }

        public void widgetSelected(SelectionEvent e) {
            List<EObject> availableElements = this.getAvailableElements();
            TransferTreeListDialog dialog = new TransferTreeListDialog(SelectFunctionalExchangeDialog.this.getShell(), Messages.ExchangeDialog_ExchangeItemSelectionWizardTitle, Messages.ExchangeDialog_ExchangeItemSelectionWizardMessage);
            dialog.setLeftInput(availableElements, null);
            dialog.setRightInput(this.getCurrentElements(), null);
            if (dialog.open() == 0) {
                Object[] results = dialog.getResult();
                ArrayList<EObject> resultObjects = new ArrayList<EObject>();
                Object[] objectArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    Object result = objectArray[n2];
                    if (result instanceof EObject) {
                        resultObjects.add((EObject)result);
                    }
                    ++n2;
                }
                SelectFunctionalExchangeDialog.this.updateExchangeItems(resultObjects);
            }
        }
    }

    public class FunctionClearListener
    extends SelectionAdapter {
        private Text _funtionToClear;
        private ListenerType _type;

        public FunctionClearListener(Text functionName, ListenerType type) {
            this._funtionToClear = functionName;
            this._type = type;
        }

        public void widgetSelected(SelectionEvent e) {
            this._funtionToClear.setData(null);
            this._funtionToClear.setText("");
            SelectFunctionalExchangeDialog.this._cache.remove((Object)this._type);
        }
    }

    public class FunctionSelectionListener
    extends SelectionAdapter {
        private Component _component;
        private FunctionPkg _function;
        private Text _text;
        private ListenerType _type;

        public FunctionSelectionListener(Text sourceText, FunctionPkg function, Component component, ListenerType listener_type) {
            this._text = sourceText;
            this._function = function;
            this._component = component;
            this._type = listener_type;
        }

        public Text getText() {
            return this._text;
        }

        public ListenerType getType() {
            return this._type;
        }

        public Component getComponent() {
            return this._component;
        }

        private List<? extends EObject> getAccessibleFunctions(FunctionPkg functionPkg) {
            AbstractNamedElement srcFunc;
            ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
            TreeIterator it = functionPkg.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof AbstractFunction)) continue;
                AbstractFunction af = (AbstractFunction)obj;
                boolean toAdd = true;
                for (ComponentFunctionalAllocation cfa : af.getComponentFunctionalAllocations()) {
                    if (cfa.getBlock() == this._component || ComponentExt.getSubUsedComponents((Component)this._component).contains(cfa.getBlock())) {
                        toAdd = true;
                        break;
                    }
                    toAdd = false;
                }
                if (!toAdd || !af.getSubFunctions().isEmpty()) continue;
                result.add(af);
            }
            if (ListenerType.SOURCE.equals((Object)this._type)) {
                AbstractNamedElement targetFunc = SelectFunctionalExchangeDialog.this._cache.get((Object)ListenerType.TARGET);
                if (targetFunc != null) {
                    result.remove(targetFunc);
                }
            } else if (ListenerType.TARGET.equals((Object)this._type) && (srcFunc = SelectFunctionalExchangeDialog.this._cache.get((Object)ListenerType.SOURCE)) != null) {
                result.remove(srcFunc);
            }
            return result;
        }

        public void widgetSelected(SelectionEvent e) {
            List<? extends EObject> functions = this.getAccessibleFunctions(this._function);
            SelectElementsDialog selectFunctionDialog = new SelectElementsDialog(SelectFunctionalExchangeDialog.this.getParentShell(), Messages.SelectOperationDialog_SelectInterfaceDialog_Title, Messages.SelectOperationDialog_SelectInterfaceDialog_Message, functions);
            if (selectFunctionDialog.open() == 0) {
                AbstractNamedElement selectedFunc = (AbstractNamedElement)selectFunctionDialog.getResult().get(0);
                this._text.setText(selectedFunc.getName());
                this._text.setData((Object)selectedFunc);
                SelectFunctionalExchangeDialog.this._cache.put(this._type, selectedFunc);
            }
        }
    }

    protected static enum ListenerType {
        TARGET,
        SOURCE;

    }
}

