/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.validation.design.consistency;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.NotificationAnalysis;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.CompliancyDefinition;
import org.polarsys.capella.common.re.RePackage;
import org.polarsys.capella.common.re.helpers.ReplicableElementExt;
import org.polarsys.capella.core.re.validation.design.consistency.ComplianceValidationContext;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public abstract class AbstractComplianceConstraint
extends AbstractValidationRule {
    private final boolean validateUnsynchronizedFeatures;
    private final EqualityHelper equalityHelper = new EqualityHelper();
    private final Predicate<CompliancyDefinition> compliancyPredicate;

    public AbstractComplianceConstraint(Predicate<CompliancyDefinition> compliancyPredicate, boolean validateUnsynchronizedFeatures) {
        this.compliancyPredicate = compliancyPredicate;
        this.validateUnsynchronizedFeatures = validateUnsynchronizedFeatures;
    }

    public AbstractComplianceConstraint(Predicate<CompliancyDefinition> compliancyPredicate) {
        this(compliancyPredicate, false);
    }

    public IStatus validate(IValidationContext ctx) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (ctx.getEventType() == EMFEventType.NULL) {
            CatalogElement elem;
            if (ctx.getTarget() instanceof CatalogElement && (elem = (CatalogElement)ctx.getTarget()).getKind() == CatalogElementKind.RPL && elem.getCurrentCompliancy() != null && this.compliancyPredicate.apply((Object)elem.getCurrentCompliancy())) {
                results.addAll(this.validateBatch(elem, ctx));
            }
        } else if (ctx.getFeature() == RePackage.Literals.CATALOG_ELEMENT__OWNED_LINKS) {
            CatalogElement ce = (CatalogElement)ctx.getTarget();
            if (ce.isReadOnly() && ce.getKind() == CatalogElementKind.RPL) {
                for (CatalogElementLink removed : this.getRemovedLinks(ctx)) {
                    IStatus s = this.handleRemovedLink((CatalogElement)ctx.getTarget(), removed, ctx);
                    if (s.isOK()) continue;
                    results.add(s);
                }
            }
        } else if (ctx.getFeature() == RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET) {
            if (ctx.getFeatureNewValue() == null) {
                s = this.handleClearedLink((CatalogElementLink)ctx.getTarget(), ctx);
                if (!s.isOK()) {
                    results.add(s);
                }
            } else {
                s = NotificationAnalysis.getOriginalSingleValue((EObject)ctx.getTarget(), (EStructuralFeature)ctx.getFeature(), (List)ctx.getAllEvents());
            }
        } else {
            for (ComplianceValidationContext cvc : ComplianceValidationContext.create(ctx, this.compliancyPredicate)) {
                IStatus result = this.validate(cvc);
                if (result.isOK()) continue;
                results.add(result);
            }
        }
        IStatus result = null;
        result = results.size() == 1 ? (IStatus)results.get(0) : (results.size() > 1 ? ConstraintStatus.createMultiStatus((IValidationContext)ctx, results) : ctx.createSuccessStatus());
        return result;
    }

    protected Collection<? extends IStatus> validateBatch(CatalogElement rpl, IValidationContext ctx) {
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        ArrayList externalContents = new ArrayList();
        HashMap<EObject, CatalogElementLink> rplContents = new HashMap<EObject, CatalogElementLink>();
        for (CatalogElementLink l : rpl.getOwnedLinks()) {
            EObject rplElement = l.getTarget();
            if (rplElement == null) continue;
            externalContents.addAll(rplElement.eContents());
            rplContents.put(rplElement, l);
        }
        externalContents.removeAll(rplContents.keySet());
        for (EObject e : externalContents) {
            ComplianceValidationContext cvctx = new ComplianceValidationContext(ctx, (CatalogElementLink)rplContents.get(e.eContainer()));
            if (e.eContainingFeature().isMany()) {
                results.add(this.validateAddReference(cvctx, e.eContainmentFeature(), e, e));
                continue;
            }
            results.add(this.validateDifferentReference(cvctx, e.eContainmentFeature(), e, e));
        }
        return results;
    }

    protected IStatus handleRemovedLink(CatalogElement owner, CatalogElementLink removed, IValidationContext ctx) {
        IStatus result = Status.OK_STATUS;
        if (removed.eResource() != null) {
            result = ctx.createFailureStatus(new Object[]{owner, removed});
        } else {
            CatalogElementLink recLink = (CatalogElementLink)NotificationAnalysis.getOriginalSingleValue((EObject)removed, (EStructuralFeature)RePackage.Literals.CATALOG_ELEMENT_LINK__ORIGIN, (List)ctx.getAllEvents());
            if (recLink != null && recLink.eResource() != null) {
                result = ctx.createFailureStatus(new Object[]{owner, removed});
            }
        }
        return result;
    }

    protected IStatus handleClearedLink(CatalogElementLink cleared, IValidationContext ctx) {
        return ctx.createFailureStatus(new Object[]{ctx.getTarget(), ctx.getFeature()});
    }

    protected IStatus validate(ComplianceValidationContext ctx) {
        IStatus result = Status.OK_STATUS;
        EStructuralFeature feature = ctx.getValidationContext().getFeature();
        if (this.validateUnsynchronizedFeatures || !ctx.getRecLink().getUnsynchronizedFeatures().contains((Object)feature.getName())) {
            result = feature instanceof EAttribute ? this.validateAttribute(ctx) : this.validateReference(ctx);
        }
        return result;
    }

    protected IStatus validateReference(ComplianceValidationContext ctx) {
        boolean set;
        IValidationContext vc = ctx.getValidationContext();
        boolean add = vc.getEventType() == EMFEventType.ADD || vc.getEventType() == EMFEventType.ADD_MANY;
        boolean remove = vc.getEventType() == EMFEventType.REMOVE || vc.getEventType() == EMFEventType.REMOVE_MANY;
        boolean bl = set = vc.getEventType() == EMFEventType.SET;
        if (add || remove || set) {
            Collection<Object> values = Collections.emptyList();
            values = vc.getFeatureNewValue() instanceof Collection ? (Collection)vc.getFeatureNewValue() : Collections.singleton(vc.getFeatureNewValue());
            for (Object vRpl : values) {
                if (vRpl != null) {
                    Object vRec = vRpl;
                    Collection vRplLinks = ReplicableElementExt.getReferencingLinks((EObject)((EObject)vRpl));
                    Iterator it = vRplLinks.iterator();
                    while (it.hasNext()) {
                        CatalogElementLink next = (CatalogElementLink)it.next();
                        if (next.getSource() == ctx.getRPL()) {
                            if (next.getOrigin() == null) continue;
                            vRec = next.getOrigin().getTarget();
                            continue;
                        }
                        it.remove();
                    }
                    if (vRec != null) {
                        if (vc.getFeature().isMany()) {
                            if (add && !((Collection)ctx.getRecElement().eGet(vc.getFeature())).contains(vRec)) {
                                return this.validateAddReference(ctx, (EReference)vc.getFeature(), vRpl, vRec);
                            }
                            if (!remove || !((Collection)ctx.getRecElement().eGet(vc.getFeature())).contains(vRec)) continue;
                            return this.validateRemoveReference(ctx, (EReference)vc.getFeature(), vRpl, vRec);
                        }
                        if (ctx.getRecElement().eGet(vc.getFeature()) == vRec) continue;
                        this.validateDifferentReference(ctx, (EReference)vc.getFeature(), vRpl, vRec);
                        continue;
                    }
                    if (add) {
                        return this.validateAddReference(ctx, (EReference)vc.getFeature(), vRpl, vRec);
                    }
                    if (!set) continue;
                    return this.validateDifferentReference(ctx, (EReference)vc.getFeature(), vRpl, vRec);
                }
                if (ctx.getRecElement().eGet(vc.getFeature()) == null) continue;
                this.validateDifferentReference(ctx, (EReference)vc.getFeature(), null, null);
            }
        }
        return Status.OK_STATUS;
    }

    protected abstract IStatus validateAddReference(ComplianceValidationContext var1, EReference var2, Object var3, Object var4);

    protected abstract IStatus validateRemoveReference(ComplianceValidationContext var1, EReference var2, Object var3, Object var4);

    protected abstract IStatus validateDifferentReference(ComplianceValidationContext var1, EReference var2, Object var3, Object var4);

    protected IStatus validateAttribute(ComplianceValidationContext ctx) {
        if (ctx.getValidationContext().getFeature() == ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME) {
            return this.validateName(ctx);
        }
        if (!this.equalityHelper.validateAttribute(ctx.getRecElement(), ctx.getRplElement(), (EAttribute)ctx.getValidationContext().getFeature())) {
            return ctx.createFailureStatus();
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateName(ComplianceValidationContext ctx) {
        String rplName = ((AbstractNamedElement)ctx.getRplElement()).getName();
        String recName = ((AbstractNamedElement)ctx.getRecElement()).getName();
        String suffix = "";
        if (ctx.getRplLink().isSuffixed() && ctx.getRPL().getSuffix() != null) {
            suffix = ctx.getRPL().getSuffix();
        }
        if (recName == null || (recName + suffix).equals(rplName)) {
            return Status.OK_STATUS;
        }
        return ctx.createFailureStatus();
    }

    private Collection<CatalogElementLink> getRemovedLinks(IValidationContext ctx) {
        if (ctx.getEventType() == EMFEventType.REMOVE) {
            return Collections.singleton((CatalogElementLink)ctx.getFeatureNewValue());
        }
        if (ctx.getEventType() == EMFEventType.REMOVE_MANY) {
            return (Collection)ctx.getFeatureNewValue();
        }
        return Collections.emptyList();
    }

    static class EqualityHelper
    extends EcoreUtil.EqualityHelper {
        EqualityHelper() {
        }

        public boolean validateAttribute(EObject eObject1, EObject eObject2, EAttribute attribute) {
            return super.haveEqualFeature(eObject1, eObject2, (EStructuralFeature)attribute);
        }
    }
}

