/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;

public class CapabilityRealizationExt {
    public static void addInvolvedComponent(CapabilityRealization capability, Component component) {
        if (component instanceof CapabilityRealizationInvolvedElement && !capability.getInvolvedComponents().contains((Object)((InvolvedElement)component))) {
            CapabilityRealizationInvolvement involvementLnk = CapellacommonFactory.eINSTANCE.createCapabilityRealizationInvolvement();
            capability.getOwnedCapabilityRealizationInvolvements().add((Object)involvementLnk);
            involvementLnk.setInvolved((InvolvedElement)((CapabilityRealizationInvolvedElement)component));
        }
    }

    public static void removeInvolvedComponent(CapabilityRealization capability, Component component) {
        if (component instanceof CapabilityRealizationInvolvedElement) {
            CapabilityRealizationInvolvement capabilityInvolvement = null;
            for (CapabilityRealizationInvolvement involvement : capability.getOwnedCapabilityRealizationInvolvements()) {
                if (!component.equals(involvement.getInvolvedCapabilityRealizationInvolvedElement())) continue;
                capabilityInvolvement = involvement;
            }
            if (capabilityInvolvement != null) {
                capabilityInvolvement.destroy();
            }
        }
    }

    public static List<CapabilityRealization> getParentsCapabilityRealizationLinked(CapabilityRealization srcCapa) {
        ArrayList<CapabilityRealization> upperCapaList = new ArrayList<CapabilityRealization>();
        for (CapellaElement upperCapa : RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)srcCapa, InteractionPackage.Literals.ABSTRACT_CAPABILITY)) {
            if (!(upperCapa instanceof CapabilityRealization)) continue;
            upperCapaList.add((CapabilityRealization)upperCapa);
            upperCapaList.addAll(CapabilityRealizationExt.getParentsCapabilityRealizationLinked((CapabilityRealization)upperCapa));
        }
        return upperCapaList;
    }

    public static List<LogicalComponent> retrieveLcInvolvedByUpperCapabilityRealization(AbstractCapability currentCapa) {
        ArrayList<LogicalComponent> involvedLcByUpperCapa = new ArrayList<LogicalComponent>();
        if (currentCapa != null) {
            for (CapabilityRealization upperCapa : CapabilityRealizationExt.getParentsCapabilityRealizationLinked((CapabilityRealization)currentCapa)) {
                for (CapabilityRealizationInvolvedElement currentLc : upperCapa.getInvolvedComponents()) {
                    if (!(currentLc instanceof LogicalComponent) || involvedLcByUpperCapa.contains(currentLc)) continue;
                    involvedLcByUpperCapa.add((LogicalComponent)currentLc);
                }
            }
        }
        return involvedLcByUpperCapa;
    }

    public static List<PhysicalComponent> retrievePcInvolvedByUpperCapabilityRealization(AbstractCapability currentCapa) {
        ArrayList<PhysicalComponent> involvedPcByUpperCapa = new ArrayList<PhysicalComponent>();
        if (currentCapa != null) {
            for (CapabilityRealization upperCapa : CapabilityRealizationExt.getParentsCapabilityRealizationLinked((CapabilityRealization)currentCapa)) {
                for (CapabilityRealizationInvolvedElement currentPc : upperCapa.getInvolvedComponents()) {
                    if (!(currentPc instanceof PhysicalComponent) || involvedPcByUpperCapa.contains(currentPc)) continue;
                    involvedPcByUpperCapa.add((PhysicalComponent)currentPc);
                }
            }
        }
        return involvedPcByUpperCapa;
    }

    public static boolean isComponentTargetAvailableForCapInvolvement(EObject context, EObject preSource, EObject preTarget) {
        if (preSource == null || preTarget == null) {
            return false;
        }
        if (preSource instanceof Capability) {
            Capability cap = (Capability)preSource;
            EList ownedActInvol = cap.getOwnedCapabilityInvolvements();
            if (!ownedActInvol.isEmpty() && ownedActInvol.contains((Object)preTarget)) {
                return false;
            }
        } else if (preSource instanceof Mission) {
            Mission mis = (Mission)preSource;
            EList ownedActInvol = mis.getOwnedMissionInvolvements();
            if (!ownedActInvol.isEmpty() && ownedActInvol.contains((Object)preTarget)) {
                return false;
            }
        } else if (preSource instanceof CapabilityRealization) {
            CapabilityRealization capReal = (CapabilityRealization)preSource;
            EList capRealization = capReal.getOwnedCapabilityRealizationInvolvements();
            for (CapabilityRealizationInvolvement element : capRealization) {
                InvolvedElement involved = element.getInvolved();
                if (involved == null || !involved.equals(preTarget)) continue;
                return false;
            }
        }
        return true;
    }

    public static List<CapabilityRealization> getAllCapabilityRealizations(BlockArchitecture architecture) {
        ArrayList<CapabilityRealization> result = new ArrayList<CapabilityRealization>();
        if (architecture != null) {
            Set capabilityRealizations = EObjectExt.getAll((EObject)architecture, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
            for (EObject obj : capabilityRealizations) {
                result.add((CapabilityRealization)obj);
            }
        }
        return result;
    }
}

