/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;

public class StateExt {
    public static Region getPrimaryRegion(State state) {
        return StateExt.getPrimaryRegion(state, true);
    }

    public static Region getPrimaryRegion(State state, boolean create) {
        if (state.getOwnedRegions().isEmpty() && create) {
            Region region = CapellacommonFactory.eINSTANCE.createRegion(NamingConstants.Region_DefaultRegion);
            state.getOwnedRegions().add((Object)region);
            CapellaElementExt.creationService((EObject)region);
        }
        if (state.getOwnedRegions().isEmpty()) {
            return null;
        }
        return (Region)state.getOwnedRegions().get(0);
    }

    public static boolean isStrictState(EObject state) {
        return state instanceof State && !(state instanceof Mode) && !(state instanceof FinalState);
    }

    public static boolean isMode(EObject state) {
        return state instanceof Mode;
    }

    public static boolean isStrictModeState(EObject state) {
        return (state instanceof State || state instanceof Mode) && !(state instanceof FinalState);
    }

    public static List<Object> getActiveElements(State state) {
        ArrayList<Object> result = new ArrayList<Object>();
        Collection<EStructuralFeature.Setting> inverseReferences = CapellaElementExt.getInverseReferencesOfEObject((EObject)state);
        for (EStructuralFeature.Setting setting : inverseReferences) {
            EObject eObject = setting.getEObject();
            if (eObject == null || !(eObject instanceof AbstractFunction) && !(eObject instanceof AbstractCapability) && !(eObject instanceof OperationalCapability) && !(eObject instanceof FunctionalChain)) continue;
            result.add(eObject);
        }
        return result;
    }

    public static List<State> getNonPseudoRecursiveSubStates(State state) {
        ArrayList<State> result = new ArrayList<State>();
        for (Region region : state.getOwnedRegions()) {
            List rStates = region.getOwnedStates().stream().filter(State.class::isInstance).map(State.class::cast).collect(Collectors.toList());
            for (State s : rStates) {
                result.add(s);
                result.addAll(StateExt.getNonPseudoRecursiveSubStates(s));
            }
        }
        return result;
    }
}

