/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.interaction.SequenceMessage;

public class ListExt {
    public static List<EObject> filterByName(List<EObject> list, String name) {
        ArrayList<EObject> filteredList = new ArrayList<EObject>();
        for (EObject obj : list) {
            if (!(obj instanceof NamedElement) || !((NamedElement)obj).getName().equals(name)) continue;
            filteredList.add(obj);
        }
        return filteredList;
    }

    public static <A> boolean containsAny(Collection<A> elements, Collection<A> into) {
        for (A o : elements) {
            if (!into.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static <A> String toString(Collection<A> objects, String separator) {
        Object result = "";
        Iterator<A> iterator = objects.iterator();
        while (iterator.hasNext()) {
            A string = iterator.next();
            result = (String)result + String.valueOf(string);
            if (!iterator.hasNext()) continue;
            result = (String)result + separator;
        }
        return result;
    }

    public static List<Interface> filterInterfacesByName(List<Interface> list, String name) {
        ArrayList<Interface> filteredList = new ArrayList<Interface>();
        for (Interface itf : list) {
            if (!itf.getName().equals(name)) continue;
            filteredList.add(itf);
        }
        return filteredList;
    }

    public static List<Component> filterComponentsByName(List<Component> list, String name) {
        ArrayList<Component> filteredList = new ArrayList<Component>();
        for (Component cpnt : list) {
            if (!cpnt.getName().equals(name)) continue;
            filteredList.add(cpnt);
        }
        return filteredList;
    }

    public static List<CapellaElement> substract(List<CapellaElement> list1, List<CapellaElement> list2) {
        ArrayList<CapellaElement> substractedList = new ArrayList<CapellaElement>();
        for (CapellaElement pc : list1) {
            if (list2.contains(pc)) continue;
            substractedList.add(pc);
        }
        return substractedList;
    }

    public static List<SequenceMessage> reverse(List<SequenceMessage> list) {
        ArrayList<SequenceMessage> reversedList = new ArrayList<SequenceMessage>();
        ListIterator<SequenceMessage> iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            reversedList.add(iterator.previous());
        }
        return reversedList;
    }

    public static List<EObject> removeDuplicates(List<EObject> list) {
        HashSet<EObject> set = new HashSet<EObject>(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    public static List<Object> getIntersectionList(List<?> firstList, List<?> secondList) {
        ArrayList<Object> intersectionList = new ArrayList<Object>(1);
        for (Object element : firstList) {
            if (!secondList.contains(element)) continue;
            intersectionList.add(element);
        }
        return intersectionList;
    }
}

