/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.MultiplicityElement;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;

public class TransformLiteralNumericValueCommand
extends AbstractReadWriteCommand
implements ICommand {
    private ModelElement _businessElement;

    public TransformLiteralNumericValueCommand(ModelElement selectedElement) {
        this._businessElement = selectedElement;
    }

    public void run() {
        if (this._businessElement instanceof LiteralNumericValue) {
            LiteralNumericValue lnv = (LiteralNumericValue)this._businessElement;
            this.transform(lnv);
        }
    }

    private void transform(LiteralNumericValue lnv) {
        NumericReference nr = DatavalueFactory.eINSTANCE.createNumericReference();
        nr.setName(lnv.getName());
        nr.setAbstractType(lnv.getAbstractType());
        nr.setDescription(lnv.getDescription());
        nr.setSummary(lnv.getSummary());
        nr.setAbstract(lnv.isAbstract());
        nr.getAppliedPropertyValues().addAll((Collection)lnv.getAppliedPropertyValues());
        nr.getOwnedPropertyValues().addAll((Collection)lnv.getOwnedPropertyValues());
        nr.getAppliedPropertyValueGroups().addAll((Collection)lnv.getAppliedPropertyValueGroups());
        nr.getOwnedPropertyValueGroups().addAll((Collection)lnv.getOwnedPropertyValueGroups());
        nr.setVisibleInDoc(lnv.isVisibleInDoc());
        nr.setVisibleInLM(lnv.isVisibleInLM());
        nr.setStatus(lnv.getStatus());
        nr.setUnit(lnv.getUnit());
        EObject container = lnv.eContainer();
        if (container instanceof MultiplicityElement) {
            MultiplicityElement me = (MultiplicityElement)container;
            if (me.getOwnedDefaultValue() == lnv) {
                me.setOwnedDefaultValue((DataValue)nr);
            }
            if (me.getOwnedMaxCard() == lnv) {
                me.setOwnedMaxCard((NumericValue)nr);
            }
            if (me.getOwnedMinCard() == lnv) {
                me.setOwnedMinCard((NumericValue)nr);
            }
            if (me.getOwnedMaxLength() == lnv) {
                me.setOwnedMaxLength((NumericValue)nr);
            }
            if (me.getOwnedMinLength() == lnv) {
                me.setOwnedMinLength((NumericValue)nr);
            }
            if (me.getOwnedDefaultValue() == lnv) {
                me.setOwnedDefaultValue((DataValue)nr);
            }
            if (me.getOwnedMaxValue() == lnv) {
                me.setOwnedMaxValue((DataValue)nr);
            }
            if (me.getOwnedMinValue() == lnv) {
                me.setOwnedMinValue((DataValue)nr);
            }
            if (me.getOwnedNullValue() == lnv) {
                me.setOwnedNullValue((DataValue)nr);
            }
        } else if (container instanceof Class) {
            Class cl = (Class)container;
            if (cl.getOwnedDataValues().contains((Object)lnv)) {
                int index = cl.getOwnedDataValues().indexOf((Object)lnv);
                cl.getOwnedDataValues().remove(index);
                cl.getOwnedDataValues().add(index, (Object)nr);
            }
        } else if (container instanceof DataPkg) {
            DataPkg pkg = (DataPkg)container;
            pkg.getOwnedDataValues().remove((Object)lnv);
            pkg.getOwnedDataValues().add((Object)nr);
        }
    }
}

