/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.session;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.sirius.business.api.resource.strategy.ResourceStrategyRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.IModelIdentifier;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.platform.sirius.ted.MetadataException;
import org.polarsys.capella.common.platform.sirius.ted.NoMetadataException;
import org.polarsys.capella.common.platform.sirius.ted.WrongCapellaVersionException;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;
import org.polarsys.capella.core.platform.sirius.ui.session.LocalSessionCreationOperation;
import org.polarsys.capella.core.platform.sirius.ui.session.Messages;
import org.polarsys.kitalpha.emde.xmi.UnknownEObject;

public class CapellaSessionHelper {
    private static final String SEMANTIC_MODEL_NS_URI_PREFIX = "http://www.polarsys.org/capella/core";
    private static final String LEGACY_SEMANTIC_MODEL_NS_URI_PREFIX = "http://www.thalesgroup.com/mde/melody";
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("Model Management");

    public static boolean checkModelsCompliancy(Session session) {
        ResourceSet resourceSet = session.getSessionResource().getResourceSet();
        return CapellaSessionHelper.checkModelsCompliancy(resourceSet);
    }

    public static boolean checkModelsCompliancy(ResourceSet resourceSet) {
        Diagnostic diagnostic = CapellaSessionHelper.checkModelCompliant(resourceSet);
        if (diagnostic.getSeverity() == 4) {
            CapellaSessionHelper.reportError(diagnostic);
            return false;
        }
        return true;
    }

    public static IStatus checkLibrariesAvailability(Session session) {
        Collection res = session.getSemanticResources();
        for (Resource resource : res) {
            IModelIdentifier modelId = ILibraryManager.INSTANCE.getModelIdentifier(resource.getURI());
            IModel model = ILibraryManager.INSTANCE.getModel(ILibraryManager.DEFAULT_EDITING_DOMAIN, modelId);
            Collection unavailable = LibraryManagerExt.getAllUnavailableReferences((IModel)model);
            if (unavailable.isEmpty()) continue;
            MultiStatus status = new MultiStatus(CapellaActionsActivator.getDefault().getPluginId(), 4, Messages.CapellaSessionHelper_MissingLibraries_Message, null);
            for (IModelIdentifier identifier : unavailable) {
                status.add((IStatus)new Status(4, CapellaActionsActivator.getDefault().getPluginId(), identifier.toString()));
            }
            CapellaSessionHelper.reportError((IStatus)status);
            return status;
        }
        return Status.OK_STATUS;
    }

    /*
     * Exception decompiling
     */
    public static IStatus checkModelsFullCompliancy(URI uri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void cleanResourceSet(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (Resource resource : new ArrayList(resourceSet.getResources())) {
                ResourceStrategyRegistry.getInstance().unloadAtResourceSetDispose(resource, (IProgressMonitor)new NullProgressMonitor());
                resourceSet.getResources().remove((Object)resource);
            }
        }
    }

    public static void cleanResourceSet(Session session) {
        ResourceSet resourceSet = session.getSessionResource().getResourceSet();
        for (Resource resource : new ArrayList(resourceSet.getResources())) {
            if (resource.getErrors().size() <= 0) continue;
            ResourceStrategyRegistry.getInstance().unloadAtResourceSetDispose(resource, (IProgressMonitor)new NullProgressMonitor());
            resourceSet.getResources().remove((Object)resource);
        }
    }

    public static Diagnostic checkModelCompliant(ResourceSet resourceSet) {
        BasicDiagnostic diagnostics = new BasicDiagnostic("source", 0, Messages.CapellaSessionHelper_MissingExtensions_Message, null);
        for (Resource resource : resourceSet.getResources()) {
            if ("odesign".equals(resource.getURI().fileExtension())) {
                for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                    if (!(diagnostic instanceof WrappedException)) continue;
                    Throwable th = ((WrappedException)diagnostic).getCause();
                    diagnostics.add(BasicDiagnostic.toDiagnostic((Throwable)th));
                }
                continue;
            }
            if (!"capella".equals(resource.getURI().fileExtension())) continue;
            for (Resource.Diagnostic diagnostic : resource.getWarnings()) {
                if (!(diagnostic instanceof UnknownEObject)) continue;
                UnknownEObject unknown = (UnknownEObject)diagnostic;
                String message = unknown.getMessage();
                BasicDiagnostic diag = new BasicDiagnostic(4, "source", 0, message, null);
                diagnostics.add((Diagnostic)diag);
            }
        }
        return diagnostics;
    }

    public static void reportError(IStatus status) {
        if (status != null && !status.isOK()) {
            StatusManager.getManager().handle(status, 1);
            StatusManager.getManager().handle(status, 4);
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
            __logger.error((Object)new EmbeddedMessage(status.getMessage(), "Model Management"));
        }
    }

    private static void reportError(Diagnostic diagnostic) {
        IStatus status = Status.OK_STATUS;
        if (diagnostic.getChildren().isEmpty()) {
            status = new Status(4, CapellaActionsActivator.getDefault().getPluginId(), diagnostic.getMessage());
        } else {
            status = new MultiStatus(CapellaActionsActivator.getDefault().getPluginId(), 4, diagnostic.getMessage(), null);
            for (Diagnostic identifier : diagnostic.getChildren()) {
                ((MultiStatus)status).add((IStatus)new Status(4, CapellaActionsActivator.getDefault().getPluginId(), identifier.getMessage()));
            }
        }
        CapellaSessionHelper.reportError(status);
    }

    public static void reportException(Exception exception) {
        IStatus handleLoadingErrors = CapellaSessionHelper.handleLoadingErrors(exception);
        CapellaSessionHelper.reportError(handleLoadingErrors);
    }

    public static IStatus handleLoadingErrors(Exception loadingException) {
        Throwable exception = loadingException;
        Object errorMsg = loadingException.getMessage();
        if (exception instanceof RuntimeException) {
            IStatus status;
            if (exception.getCause() != null) {
                exception = exception.getCause();
            }
            if (exception instanceof CoreException && (status = ((CoreException)exception).getStatus()).getException() != null) {
                exception = status.getException();
            }
            if (exception instanceof FeatureNotFoundException) {
                return null;
            }
            if (exception instanceof PackageNotFoundException) {
                PackageNotFoundException notFoundException = (PackageNotFoundException)exception;
                String packageNotFound = notFoundException.uri();
                if (packageNotFound.startsWith(SEMANTIC_MODEL_NS_URI_PREFIX) || packageNotFound.startsWith(LEGACY_SEMANTIC_MODEL_NS_URI_PREFIX)) {
                    String version = new Path(packageNotFound).lastSegment();
                    errorMsg = Messages.CapellaSessionHelper_SemanticModel_Error_Message_WrongVersion_Part1 + ":" + version + Messages.CapellaSessionHelper_SemanticModel_Error_Message_WrongVersion_Part2;
                } else {
                    errorMsg = "A metamodel is missing: " + packageNotFound;
                }
            } else if (exception instanceof ClassNotFoundException) {
                if (exception.getMessage().indexOf(".aird,") >= 0) {
                    errorMsg = Messages.CapellaSessionHelper_Repair_Migrate_Message;
                }
            } else if (exception instanceof UnresolvedReferenceException) {
                errorMsg = exception.getMessage();
            } else if (exception instanceof NoMetadataException) {
                errorMsg = exception.getMessage();
            } else if (exception instanceof WrongCapellaVersionException) {
                errorMsg = exception.getMessage();
            } else if (exception instanceof MetadataException) {
                errorMsg = exception.getMessage();
            } else if (exception instanceof ClassCastException && exception.getMessage().indexOf("org.eclipse.sirius") >= 0) {
                errorMsg = Messages.CapellaSessionHelper_Repair_Migrate_Message;
            }
            if (errorMsg == null) {
                errorMsg = Messages.CapellaSessionHelper_UnknownError_Message;
            }
        }
        if (errorMsg != null) {
            return new Status(4, "org.polarsys.capella.core.preferences", (String)errorMsg, (Throwable)new RuntimeException(exception));
        }
        return Status.OK_STATUS;
    }

    public static Session createLocalSession(List<IFile> semanticModels, URI airdURI, IProgressMonitor monitor) throws IOException, PartInitException, InvocationTargetException, InterruptedException {
        ArrayList<URI> semanticURIs = new ArrayList<URI>();
        for (IFile semanticModelFile : semanticModels) {
            semanticURIs.add(EcoreUtil2.getURI((IFile)semanticModelFile));
        }
        if (!semanticURIs.isEmpty()) {
            LocalSessionCreationOperation sessionCreationOperation = new LocalSessionCreationOperation(semanticURIs, airdURI);
            sessionCreationOperation.run(monitor);
            return sessionCreationOperation.getCreatedSession();
        }
        throw new IllegalArgumentException("No semantic model might be loaded.");
    }
}

