/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.actions;

import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationTreeViewer;
import org.polarsys.capella.core.data.information.ExchangeItem;

public abstract class RemoveElementAction
extends Action {
    protected TreeViewer treeViewer;

    public RemoveElementAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void run() {
        Map<Object, Object> selectionMap = EIAllocationTreeViewer.getSelectionMap(this.treeViewer);
        for (Object selectedItem : selectionMap.keySet()) {
            Object parentItem = selectionMap.get(selectedItem);
            if (parentItem == null) continue;
            if (parentItem instanceof FunctionInputPort) {
                ((FunctionInputPort)parentItem).getIncomingExchangeItems().remove(selectedItem);
                continue;
            }
            if (!(parentItem instanceof FunctionOutputPort)) continue;
            ((FunctionOutputPort)parentItem).getOutgoingExchangeItems().remove(selectedItem);
        }
        this.postRun();
    }

    protected abstract void postRun();

    public String getText() {
        return "Remove ExchangeItem Allocation";
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
    }

    public boolean isEnabled() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection != null && selection.size() == 1) {
            return selection.getFirstElement() instanceof ExchangeItem;
        }
        return false;
    }
}

