/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;
import org.polarsys.kitalpha.emde.extension.preferences.EmdePreferences;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public class EmdePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private boolean isDirty;
    private Button forceGenerationButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite bar = new Composite(parent, 0);
        bar.setLayoutData((Object)new GridData(1808));
        bar.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(256);
        this.forceGenerationButton = new Button(bar, 32);
        this.forceGenerationButton.setText("Force generation using eMDE");
        this.forceGenerationButton.setData((Object)"force.generation");
        this.forceGenerationButton.setLayoutData((Object)gd);
        this.forceGenerationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EmdePreferencePage.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.loadData();
        return bar;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateButtons();
    }

    protected void performApply() {
        try {
            EmdePreferences.getInstancePreferences().putBoolean("force.generation", this.forceGenerationButton.getSelection());
            EmdePreferences.getInstancePreferences().flush();
            this.setDirty(false);
        }
        catch (BackingStoreException e) {
            Log.getDefault().logError((Throwable)e);
        }
    }

    public boolean performCancel() {
        this.performDefaults();
        return super.performCancel();
    }

    protected void performDefaults() {
        if (!this.isDirty) {
            return;
        }
        this.loadData();
        this.setDirty(false);
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void loadData() {
        this.forceGenerationButton.setSelection(EmdePreferences.getInstancePreferences().getBoolean("force.generation", false));
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty == dirty) {
            return;
        }
        this.isDirty = dirty;
        this.updateButtons();
    }

    private void updateButtons() {
        this.getApplyButton().setEnabled(this.isDirty && this.isValid());
        this.getDefaultsButton().setEnabled(this.isDirty);
    }
}

