/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.exchanges;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.projection.exchanges.IExchangesCreator;

public class DefaultExchangesCreator
implements IExchangesCreator {
    protected static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Default");
    protected Component _component;

    public DefaultExchangesCreator(Component component_p) {
        this._component = component_p;
    }

    @Override
    public void createExchanges() {
        boolean exchangeCreated = false;
        ArrayList<AbstractFunction> lf = new ArrayList<AbstractFunction>();
        Collection components = ComponentExt.getAllSubUsedComponents((Component)this._component);
        components.add(this._component);
        for (Component subComponent : components) {
            for (AbstractFunction function : subComponent.getAllocatedFunctions()) {
                lf.add(function);
            }
        }
        for (Component component : components) {
            EList laf = component.getAllocatedFunctions();
            for (AbstractFunction abstractFunction : laf) {
                TraceableElement allocating;
                for (FunctionalExchange fe : FunctionExt.getOutGoingExchange((AbstractFunction)abstractFunction)) {
                    if (!fe.getIncomingComponentExchangeFunctionalExchangeRealizations().isEmpty()) continue;
                    ActivityNode targetObject = fe.getTarget();
                    AbstractFunction targetF = targetObject instanceof AbstractFunction ? (AbstractFunction)targetObject : (AbstractFunction)targetObject.eContainer();
                    for (ComponentFunctionalAllocation componentFunctionalAllocation : targetF.getComponentFunctionalAllocations()) {
                        allocating = componentFunctionalAllocation.getSourceElement();
                        if (!(allocating instanceof Component) || lf.contains(targetF) || !this.isValidCreation((AbstractEventOperation)fe, component, (Component)allocating)) continue;
                        this.doCreateExchange(fe, component, (Component)allocating);
                        exchangeCreated = true;
                    }
                }
                for (FunctionalExchange fe : FunctionExt.getIncomingExchange((AbstractFunction)abstractFunction)) {
                    if (!fe.getIncomingComponentExchangeFunctionalExchangeRealizations().isEmpty()) continue;
                    ActivityNode sourceObject = fe.getSource();
                    AbstractFunction sourceF = sourceObject instanceof AbstractFunction ? (AbstractFunction)sourceObject : (AbstractFunction)sourceObject.eContainer();
                    for (ComponentFunctionalAllocation componentFunctionalAllocation : sourceF.getComponentFunctionalAllocations()) {
                        allocating = componentFunctionalAllocation.getSourceElement();
                        if (!(allocating instanceof Component) || lf.contains(sourceF) || !this.isValidCreation((AbstractEventOperation)fe, component, (Component)allocating)) continue;
                        this.doCreateExchange(fe, (Component)allocating, component);
                        exchangeCreated = true;
                    }
                }
            }
        }
        if (!exchangeCreated) {
            String message = "No component exchange has been created.";
            EmbeddedMessage eMessage = new EmbeddedMessage(message, logger.getName());
            logger.info((Object)eMessage);
        }
    }

    protected boolean isValidBound(Component component_p) {
        if (component_p instanceof PhysicalComponent) {
            return true;
        }
        if (component_p instanceof LogicalComponent) {
            return true;
        }
        return component_p instanceof SystemComponent || ComponentExt.isComponentRoot((EObject)component_p);
    }

    protected boolean isValidCreation(AbstractEventOperation fe_p, Component component_p, Component allocating_p) {
        return this.isValidBound(component_p) && this.isValidBound(allocating_p);
    }

    protected void doCreateExchange(FunctionalExchange functionalExchange_p, Component exchangeOutput_p, Component exchangeInput_p) {
        ComponentExchange ce = FaFactory.eINSTANCE.createComponentExchange(functionalExchange_p.getName());
        if (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)functionalExchange_p))) {
            ce.setKind(ComponentExchangeKind.ASSEMBLY);
        } else {
            ce.setKind(ComponentExchangeKind.FLOW);
        }
        ComponentPort outP = this.getRelatedProvidingPort(exchangeOutput_p, functionalExchange_p.getSource(), functionalExchange_p);
        ComponentPort inP = this.getRelatedRequiringPort(exchangeInput_p, functionalExchange_p.getTarget(), functionalExchange_p);
        ce.setSource((InformationsExchanger)outP);
        ce.setTarget((InformationsExchanger)inP);
        ComponentExchangeExt.attachToDefaultContainer((ComponentExchange)ce);
        ComponentExchangeFunctionalExchangeAllocation cfea = FaFactory.eINSTANCE.createComponentExchangeFunctionalExchangeAllocation();
        cfea.setSourceElement((TraceableElement)ce);
        cfea.setTargetElement((TraceableElement)functionalExchange_p);
        ce.getOwnedComponentExchangeFunctionalExchangeAllocations().add((Object)cfea);
        String message = "The Component exchange " + ce.getName() + " has been succefully created between the exchange source component " + exchangeInput_p.getLabel() + " and the exchange target component " + exchangeOutput_p.getLabel();
        EmbeddedMessage eMessage = new EmbeddedMessage(message, logger.getName(), Arrays.asList(ce, exchangeInput_p, exchangeOutput_p));
        logger.info((Object)eMessage);
    }

    private ComponentPort getRelatedProvidingPort(Component component_p, ActivityNode fport, FunctionalExchange a_p) {
        ComponentPort port = null;
        if (fport == null || component_p == null) {
            return null;
        }
        Interface relatedInterface = null;
        for (AbstractTrace trace : a_p.getIncomingTraces()) {
            if (!(trace instanceof TransfoLink) || !(trace.getSourceElement() instanceof Interface)) continue;
            relatedInterface = (Interface)trace.getSourceElement();
            break;
        }
        if (relatedInterface != null) {
            for (Feature f : component_p.getOwnedFeatures()) {
                ComponentPort cport;
                if (!(f instanceof ComponentPort) || !(cport = (ComponentPort)f).getProvidedInterfaces().contains((Object)relatedInterface)) continue;
                port = cport;
                break;
            }
        }
        if (port == null) {
            port = PortExt.createOutFlowPort((String)fport.getName());
            component_p.getOwnedFeatures().add((Object)port);
        }
        PortExt.attachPort(port, (ActivityNode)fport);
        return port;
    }

    private ComponentPort getRelatedRequiringPort(Component component_p, ActivityNode fport, FunctionalExchange a_p) {
        ComponentPort port = null;
        if (fport == null || component_p == null) {
            return null;
        }
        Interface relatedInterface = null;
        for (AbstractTrace trace : a_p.getIncomingTraces()) {
            if (!(trace instanceof TransfoLink) || !(trace.getSourceElement() instanceof Interface)) continue;
            relatedInterface = (Interface)trace.getSourceElement();
            break;
        }
        if (relatedInterface != null) {
            for (Feature f : component_p.getOwnedFeatures()) {
                ComponentPort cport;
                if (!(f instanceof ComponentPort) || !(cport = (ComponentPort)f).getRequiredInterfaces().contains((Object)relatedInterface)) continue;
                port = cport;
                break;
            }
        }
        if (port == null) {
            port = PortExt.createInFlowPort((String)fport.getName());
            component_p.getOwnedFeatures().add((Object)port);
        }
        PortExt.attachPort(port, (ActivityNode)fport);
        return port;
    }
}

