/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.platform.eclipse.tools.report.console;

import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.polarsys.capella.common.tools.report.appenders.console.IReportConsole;

public class ReportConsole
implements IReportConsole {
    private static final String CAPELLA_CONSOLE = "Capella";
    private static final RGB rgb_BLACK = new RGB(0, 0, 0);
    private static final RGB rgb_DARK_GREEN = new RGB(0, 102, 0);
    private static final RGB rgb_DARK_MAGENTA = new RGB(153, 0, 204);
    private static final RGB rgb_RED = new RGB(204, 0, 0);
    private static final RGB rgb_DARK_YELLOW = new RGB(153, 153, 153);

    public OutputStream getErrorStream() {
        MessageConsole messageConsole = this.getCapellaConsole();
        MessageConsoleStream consoleStream = new MessageConsoleStream(messageConsole);
        return consoleStream;
    }

    public HashMap<Level, MessageConsoleStream> getOutputStreams() {
        HashMap<Level, MessageConsoleStream> conStreamsMap = this.createOutputStreamsColor(this.getCapellaConsole());
        return conStreamsMap;
    }

    public MessageConsole getCapellaConsole() {
        IConsole[] consoles;
        MessageConsole capellaCons = null;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole currentConsole = iConsoleArray[n2];
            if (currentConsole.getName().equalsIgnoreCase(CAPELLA_CONSOLE)) {
                capellaCons = (MessageConsole)currentConsole;
            }
            ++n2;
        }
        if (capellaCons == null) {
            capellaCons = new MessageConsole(CAPELLA_CONSOLE, ImageDescriptor.getMissingImageDescriptor());
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{capellaCons});
        }
        return capellaCons;
    }

    private HashMap<Level, MessageConsoleStream> createOutputStreamsColor(MessageConsole messageCons) {
        HashMap<Level, MessageConsoleStream> conStreamsMap = new HashMap<Level, MessageConsoleStream>();
        conStreamsMap.put(Level.DEBUG, this.createOutputStreamColor(rgb_BLACK, messageCons));
        conStreamsMap.put(Level.INFO, this.createOutputStreamColor(rgb_DARK_GREEN, messageCons));
        conStreamsMap.put(Level.WARN, this.createOutputStreamColor(rgb_DARK_MAGENTA, messageCons));
        conStreamsMap.put(Level.ERROR, this.createOutputStreamColor(rgb_RED, messageCons));
        conStreamsMap.put(Level.FATAL, this.createOutputStreamColor(rgb_DARK_YELLOW, messageCons));
        return conStreamsMap;
    }

    private MessageConsoleStream createOutputStreamColor(RGB rgb_color, MessageConsole messageCons) {
        MessageConsoleStream consoleStream = messageCons.newMessageStream();
        Display standardDisplay = ConsolePlugin.getStandardDisplay();
        Color systemColor = new Color((Device)standardDisplay, rgb_color);
        consoleStream.setColor(systemColor);
        return consoleStream;
    }
}

