/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.af.integration;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.osgi.framework.Version;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.kitalpha.ad.metadata.helpers.Contribution;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class CapellaContribution
extends Contribution {
    public void update(ResourceSet context) {
        if (this.hasCapellaSemanticResource(context)) {
            this.referenceViewpoint(context, "org.polarsys.capella.core.viewpoint");
        } else {
            this.unreferenceViewpoint(context, "org.polarsys.capella.core.viewpoint");
        }
    }

    protected void unreferenceViewpoint(ResourceSet context, String viewpointId) {
        Resource capellaVp = ViewpointManager.getViewpoint((String)viewpointId);
        MetadataHelper.getViewpointMetadata((ResourceSet)context).unReference(capellaVp);
    }

    protected void referenceViewpoint(ResourceSet context, String viewpointId) {
        Resource capellaVp = ViewpointManager.getViewpoint((String)viewpointId);
        Version readVersion = ViewpointManager.readVersion((Resource)capellaVp);
        MetadataHelper.getViewpointMetadata((ResourceSet)context).reference(capellaVp, readVersion);
    }

    protected boolean hasCapellaSemanticResource(ResourceSet context) {
        for (org.eclipse.emf.ecore.resource.Resource resource : context.getResources()) {
            if (resource == null || !CapellaResourceHelper.isAirdResource((URI)resource.getURI())) continue;
            for (EObject root : resource.getContents()) {
                if (!(root instanceof DAnalysis) || !this.hasCapellaSemanticResource((DAnalysis)root)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasCapellaSemanticResource(DAnalysis analysis) {
        for (ResourceDescriptor descriptor : analysis.getSemanticResources()) {
            if (!CapellaResourceHelper.isCapellaResource((URI)descriptor.getResourceURI())) continue;
            return true;
        }
        return false;
    }
}

