/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.factory;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.common.util.MDERichTextHelper;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaRichTextConfiguration;
import org.polarsys.kitalpha.richtext.nebula.widget.toolbar.MDERichTextToolbarItemHandler;
import org.polarsys.kitalpha.richtext.widget.MDERichtextWidgetEditorImpl;
import org.polarsys.kitalpha.richtext.widget.MDERichtextWidgetImpl;
import org.polarsys.kitalpha.richtext.widget.editor.tools.OpenInEditorHandler;
import org.polarsys.kitalpha.richtext.widget.factory.MDERichTextConfigurableFactory;
import org.polarsys.kitalpha.richtext.widget.helper.MDERichtextWidgetHelper;
import org.polarsys.kitalpha.richtext.widget.tools.handlers.AddImageHandler;
import org.polarsys.kitalpha.richtext.widget.tools.handlers.AddLinkHandler;
import org.polarsys.kitalpha.richtext.widget.tools.handlers.ClearContentHandler;
import org.polarsys.kitalpha.richtext.widget.tools.handlers.RefreshHandler;
import org.polarsys.kitalpha.richtext.widget.tools.handlers.SaveContentHandler;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Constants;

public class MDERichTextFactory {
    private final MDENebulaRichTextConfiguration configuration = new MDENebulaRichTextConfiguration();

    public MDERichTextFactory() {
        this.initializeDefaultConfiguration();
    }

    public MDERichTextFactory(String basePath) {
        this();
        this.setBaseHrefPath(basePath);
    }

    protected void initializeDefaultConfiguration() {
        this.configuration.setOption("readOnly", (Object)false);
        this.configuration.setOption("image_previewText", (Object)" ");
        this.configuration.setOption("pasteFromWordPromptCleanup", (Object)true);
    }

    public MDERichTextWidget createEditorRichTextWidget(Composite parent) {
        if (MDERichTextConfigurableFactory.isConfigurableRTEActivated()) {
            MDERichTextConfigurableFactory configurableFactory = new MDERichTextConfigurableFactory();
            return configurableFactory.createPreferencesCompliantRichTextWidget(parent);
        }
        this.initializeMDEDefaultToolbar(false);
        MDERichtextWidgetEditorImpl widget = MDERichtextWidgetHelper.getInstance().getEditorWidgetContribution(parent, this.configuration);
        if (widget == null) {
            widget = new MDERichtextWidgetEditorImpl(parent, this.configuration);
        }
        this.addEditorToolbarItems((MDENebulaBasedRichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createEditorRichTextWidget(Composite parent, int style) {
        if (MDERichTextConfigurableFactory.isConfigurableRTEActivated()) {
            MDERichTextConfigurableFactory configurableFactory = new MDERichTextConfigurableFactory();
            return configurableFactory.createPreferencesCompliantRichTextWidget(parent);
        }
        this.initializeMDEDefaultToolbar(false);
        MDERichtextWidgetEditorImpl widget = new MDERichtextWidgetEditorImpl(parent, this.configuration, style);
        this.addEditorToolbarItems((MDENebulaBasedRichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createDefaultRichTextWidget(Composite parent) {
        if (MDERichTextConfigurableFactory.isConfigurableRTEActivated()) {
            MDERichTextConfigurableFactory configurableFactory = new MDERichTextConfigurableFactory();
            return configurableFactory.createPreferencesCompliantRichTextWidget(parent);
        }
        this.initializeMDEDefaultToolbar(true);
        this.removeUselessItemFromToolbar();
        MDERichtextWidgetImpl widget = new MDERichtextWidgetImpl(parent, this.configuration);
        this.addToolbarItems((MDENebulaBasedRichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createDefaultRichTextWidget(Composite parent, int style) {
        if (MDERichTextConfigurableFactory.isConfigurableRTEActivated()) {
            MDERichTextConfigurableFactory configurableFactory = new MDERichTextConfigurableFactory();
            return configurableFactory.createPreferencesCompliantRichTextWidget(parent);
        }
        this.initializeMDEDefaultToolbar(true);
        this.removeUselessItemFromToolbar();
        MDERichtextWidgetImpl widget = new MDERichtextWidgetImpl(parent, this.configuration, style);
        this.addToolbarItems((MDENebulaBasedRichTextWidget)widget);
        this.initEditorItemStates((MDERichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createMinimalRichTextWidget(Composite parent) {
        if (MDERichTextConfigurableFactory.isConfigurableRTEActivated()) {
            MDERichTextConfigurableFactory configurableFactory = new MDERichTextConfigurableFactory();
            return configurableFactory.createPreferencesCompliantRichTextWidget(parent);
        }
        this.initializeMDEMinimalToolbar();
        this.removeUselessItemFromToolbar();
        MDERichtextWidgetImpl widget = new MDERichtextWidgetImpl(parent, this.configuration){
            IExecutionListener executionListener;
            {
                this.executionListener = null;
            }

            protected void installListeners() {
                super.installListeners();
                this.executionListener = new IExecutionListener(){

                    public void preExecute(String commandId, ExecutionEvent event) {
                        if (!this.isEditorDisposed() && this.hasFocus()) {
                            this.saveContent();
                        }
                    }

                    public void postExecuteSuccess(String commandId, Object returnValue) {
                        if (!this.isEditorDisposed() && this.hasFocus()) {
                            this.setDirtyStateUpdated(false);
                        }
                    }

                    public void postExecuteFailure(String commandId, ExecutionException exception) {
                    }

                    public void notHandled(String commandId, NotHandledException exception) {
                    }
                };
                ICommandService commandSvc = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                Command saveCommand = commandSvc.getCommand("org.eclipse.ui.file.save");
                Command saveAllCommand = commandSvc.getCommand("org.eclipse.ui.file.saveAll");
                saveCommand.addExecutionListener(this.executionListener);
                saveAllCommand.addExecutionListener(this.executionListener);
            }

            public void dispose() {
                if (this.executionListener != null) {
                    ICommandService commandSvc = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                    Command saveCommand = commandSvc.getCommand("org.eclipse.ui.file.save");
                    Command saveAllCommand = commandSvc.getCommand("org.eclipse.ui.file.saveAll");
                    saveCommand.removeExecutionListener(this.executionListener);
                    saveAllCommand.removeExecutionListener(this.executionListener);
                    this.executionListener = null;
                }
                super.dispose();
            }
        };
        this.addToolbarItems((MDENebulaBasedRichTextWidget)widget);
        this.initEditorItemStates((MDERichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createMinimalRichTextWidget(Composite parent, int style) {
        if (MDERichTextConfigurableFactory.isConfigurableRTEActivated()) {
            MDERichTextConfigurableFactory configurableFactory = new MDERichTextConfigurableFactory();
            return configurableFactory.createPreferencesCompliantRichTextWidget(parent);
        }
        this.initializeMDEMinimalToolbar();
        this.removeUselessItemFromToolbar();
        MDERichtextWidgetImpl widget = new MDERichtextWidgetImpl(parent, this.configuration, style);
        this.addToolbarItems((MDENebulaBasedRichTextWidget)widget);
        this.initEditorItemStates((MDERichTextWidget)widget);
        return widget;
    }

    private void removeUselessItemFromToolbar() {
        this.configuration.removeToolbarItems(new String[]{"Link", "Anchor", "Strike", "PasteFromWord"});
    }

    protected void addEditorToolbarItems(MDENebulaBasedRichTextWidget widget) {
        widget.addToolbarItem((MDERichTextWidget)widget, "MDESave", "MDESave", "Save editor content", "mdesave", Constants.SAVE_IMAGE_ICON, (MDERichTextToolbarItemHandler)new SaveContentHandler());
        if (!"linux".equals(Platform.getOS()) || Boolean.getBoolean("org.polarsys.kitalpha.richtext.webkit.gtk.compatibility.workaround.disable")) {
            widget.addToolbarItem((MDERichTextWidget)widget, "Refresh", "Refresh", "Refresh editor", "Refresh", Constants.REFRESH_IMAGE_ICON, (MDERichTextToolbarItemHandler)new RefreshHandler());
        }
        widget.addToolbarItem((MDERichTextWidget)widget, "Clean", "Clean", "Clean", "clean", Constants.CLEAR_ICON, (MDERichTextToolbarItemHandler)new ClearContentHandler());
        widget.addToolbarItem((MDERichTextWidget)widget, "Addlink", "Addlink", "Link", "mdelinks", Constants.ADD_LINK_ICON, (MDERichTextToolbarItemHandler)new AddLinkHandler());
        widget.addToolbarItem((MDERichTextWidget)widget, "AddImage", "AddImage", "Add Image", "mdelinks", Constants.ADD_IMAGE_ICON, (MDERichTextToolbarItemHandler)new AddImageHandler());
    }

    protected void addToolbarItems(MDENebulaBasedRichTextWidget widget) {
        widget.addToolbarItem((MDERichTextWidget)widget, "openEditor", "openEditor", "Open in Editor", "enableEdit", MDERichTextHelper.getURL((String)"org.polarsys.kitalpha.richtext.widget", (String)"icons/openInEditor.gif"), (MDERichTextToolbarItemHandler)new OpenInEditorHandler());
        widget.addToolbarItem((MDERichTextWidget)widget, "MDESave", "MDESave", "Save editor", "mdesave", Constants.SAVE_IMAGE_ICON, (MDERichTextToolbarItemHandler)new SaveContentHandler());
        if (!"linux".equals(Platform.getOS()) || Boolean.getBoolean("org.polarsys.kitalpha.richtext.webkit.gtk.compatibility.workaround.disable")) {
            widget.addToolbarItem((MDERichTextWidget)widget, "Refresh", "Refresh", "Refresh editor", "Refresh", Constants.REFRESH_IMAGE_ICON, (MDERichTextToolbarItemHandler)new RefreshHandler());
        }
        this.addEditorToolbarItems(widget);
    }

    protected MDERichTextFactory initializeMDEDefaultToolbar(boolean addOpenInEditor) {
        if (addOpenInEditor) {
            this.configuration.initializeToolbarItem("enableEdit", new String[]{"openEditor"});
        }
        this.configuration.initializeToolbarItem("mdesave", new String[]{"MDESave"});
        if (!"linux".equals(Platform.getOS()) || Boolean.getBoolean("org.polarsys.kitalpha.richtext.webkit.gtk.compatibility.workaround.disable")) {
            this.configuration.initializeToolbarItem("Refresh", new String[]{"Refresh"});
        }
        this.configuration.initializeToolbarItem("styles", new String[0]);
        this.configuration.initializeToolbarItem("clipboard", new String[0]);
        this.configuration.initializeToolbarItem("clean", new String[]{"Clean"});
        this.configuration.initializeToolbarItem("basicstyles", new String[]{"Bold", "Italic", "Underline", "Subscript", "Superscript"});
        this.configuration.initializeToolbarItem("colors", new String[0]);
        this.configuration.initializeToolbarItem("paragraph", new String[]{"list", "indent"});
        this.configuration.initializeToolbarItem("editing", new String[]{"Find"});
        this.configuration.initializeToolbarItem("mdelinks", new String[]{"Addlink"});
        this.configuration.initializeToolbarItem("mdelinks", new String[]{"AddImage"});
        this.removeUselessItemFromToolbar();
        return this;
    }

    protected MDERichTextFactory initializeMDEMinimalToolbar() {
        this.configuration.initializeToolbarItem("enableEdit", new String[]{"openEditor"});
        this.configuration.initializeToolbarItem("mdesave", new String[]{"MDESave"});
        if (!"linux".equals(Platform.getOS()) || Boolean.getBoolean("org.polarsys.kitalpha.richtext.webkit.gtk.compatibility.workaround.disable")) {
            this.configuration.initializeToolbarItem("Refresh", new String[]{"Refresh"});
        }
        this.configuration.initializeToolbarItem("styles", new String[0]);
        this.configuration.initializeToolbarItem("clipboard", new String[0]);
        this.configuration.initializeToolbarItem("basicstyles", new String[]{"list"});
        this.configuration.initializeToolbarItem("mdelinks", new String[]{"Addlink"});
        return this;
    }

    private void initEditorItemStates(MDERichTextWidget editor) {
        editor.setToolbarItemState("Editable", "CKEDITOR.TRISTATE_ON");
    }

    public MDERichTextFactory initializeToolbarItem(String toolbar, String ... items) {
        this.configuration.initializeToolbarItem(toolbar, items);
        return this;
    }

    public MDERichTextFactory setToolbarColor(String hexaCode) {
        Assert.isNotNull((Object)hexaCode);
        this.configuration.setOption("uiColor", (Object)hexaCode);
        return this;
    }

    public MDERichTextFactory setConfigurationFile(String path) {
        this.configuration.setOption("customConfig", (Object)path);
        return this;
    }

    public MDERichTextFactory setToolbarPosition(String position) {
        this.configuration.setToolbarPosition(position);
        return this;
    }

    public MDERichTextFactory setBaseHrefPath(String basePath) {
        this.configuration.setOption("baseHref", (Object)basePath);
        return this;
    }

    public RichTextEditorConfiguration getConfiguration() {
        return this.configuration;
    }
}

