/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.internal;

import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.widget.editor.intf.MDERichTextEditorCallback;
import org.polarsys.kitalpha.richtext.widget.internal.Activator;
import org.polarsys.kitalpha.richtext.widget.tools.manager.LinkManagerImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ListenerInstaller {
    public void createAllListeners(final MDENebulaBasedRichTextWidget widget) {
        if ("linux".equals(Platform.getOS()) && !Boolean.getBoolean("org.polarsys.kitalpha.richtext.webkit.gtk.compatibility.workaround.disable")) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ListenerInstaller.this.doCreateAllListeners(widget);
                }
            });
        } else {
            this.doCreateAllListeners(widget);
        }
    }

    private void doCreateAllListeners(MDENebulaBasedRichTextWidget widget) {
        this.createBeforePasteConfirmationDialogListener(widget);
        this.createShouldCleanupClipboardFunction(widget);
        this.createOpenLinkListener(widget);
        this.createSaveListener(widget);
        this.createChangeNotificationHandlerListener(widget);
        this.createChangeContentListener(widget);
        this.createFocusEventListener(widget);
        this.createWorkspaceResourceSaveListener((MDERichTextWidget)widget);
        this.createDataReadyEventListener(widget);
        this.createSetDataEventListener(widget);
    }

    private boolean shouldCleanupClipboard(boolean currentShouldCleanup) {
        if (!currentShouldCleanup) {
            return currentShouldCleanup;
        }
        HTMLTransfer htmlTransfer = HTMLTransfer.getInstance();
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        String htmlData = (String)clipboard.getContents((Transfer)htmlTransfer);
        clipboard.dispose();
        if (htmlData != null) {
            block5: {
                String htmlDocument = "<clipboard>" + htmlData + "</clipboard>";
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                OneTagChecker checker = new OneTagChecker("a");
                saxParser.parse((InputStream)new ByteArrayInputStream(htmlDocument.getBytes()), (DefaultHandler)checker);
                if (!checker.containOnlyOneTag()) break block5;
                return false;
            }
            try {
                return currentShouldCleanup;
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                return currentShouldCleanup;
            }
        }
        return currentShouldCleanup;
    }

    public void createShouldCleanupClipboardFunction(MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "shouldCleanupClipboard"){

            public Object function(Object[] arguments) {
                return ListenerInstaller.this.shouldCleanupClipboard((Boolean)arguments[0]);
            }
        };
    }

    public void installAllListeners(final MDENebulaBasedRichTextWidget widget) {
        if ("linux".equals(Platform.getOS()) && !Boolean.getBoolean("org.polarsys.kitalpha.richtext.webkit.gtk.compatibility.workaround.disable")) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ListenerInstaller.this.doInstallAllListeners(widget);
                }
            });
        } else {
            this.doInstallAllListeners(widget);
        }
    }

    private void doInstallAllListeners(MDENebulaBasedRichTextWidget widget) {
        this.installBeforePasteConfirmationDialogListener(widget);
        this.installOpenLinkListener(widget);
        this.installFocusOutListener(widget);
        this.installChangeNotificationHandlerListener(widget);
        this.installChangeContentListener(widget);
        this.installFocusInListener(widget);
        this.installDataReadyEventListener(widget);
        this.installSetDataEventListener(widget);
    }

    protected void createBeforePasteConfirmationDialogListener(MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "getConfirmCleanupMsg"){

            public Object function(Object[] arguments) {
                return "Press OK to clean the Non-XHTML before pasting.\n\nPress Cancel to paste text as it is (not recommended) or better use toolbar action \"Paste as plain text\"";
            }
        };
    }

    protected void installBeforePasteConfirmationDialogListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("editor = CKEDITOR.instances.editor;");
        script.append("editor.on('beforePaste', function (event) {");
        script.append("editor.lang.pastefromword.confirmCleanup = getConfirmCleanupMsg();");
        script.append("editor.config.pasteFromWordPromptCleanup = shouldCleanupClipboard(editor.config.pasteFromWordPromptCleanup);");
        script.append("});");
        script.append("editor.on('beforeCommandExec', function (cmd) {");
        script.append("if(cmd.data.name == 'pastetext'){");
        script.append("editor.config.pasteFromWordPromptCleanup = false;");
        script.append("}});");
        script.append("editor.on('afterPaste', function (event) {");
        script.append("editor.config.pasteFromWordPromptCleanup = true;");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget can not install beforePaste/afterPaste/beforeCommandExec listeners!"));
        }
    }

    protected void createOpenLinkListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "openLinks"){

            public Object function(Object[] arguments) {
                if (arguments != null && arguments.length > 0) {
                    Object[] objectArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        new LinkManagerImpl((MDERichTextWidget)widget).openLink((String)object);
                        ++n2;
                    }
                }
                return null;
            }
        };
    }

    protected void installOpenLinkListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder scriptAddMenu = new StringBuilder();
        scriptAddMenu.append("  CKEDITOR.instances.editor.on('doubleclick', function(event)");
        scriptAddMenu.append("  {");
        scriptAddMenu.append("    var element = CKEDITOR.plugins.link.getSelectedLink( CKEDITOR.currentInstance ) || event.data.element;");
        scriptAddMenu.append("    if (element!=undefined &&  element.is( 'a' ) ) {");
        scriptAddMenu.append("      event.stop();");
        scriptAddMenu.append("      openLinks(element.getAttribute('href'));");
        scriptAddMenu.append("    }");
        scriptAddMenu.append("  }, null, null, 1);");
        scriptAddMenu.append("CKEDITOR.on( 'instanceReady', function(e) {");
        scriptAddMenu.append("CKEDITOR.instances.editor.addCommand(\"openLink\", {");
        scriptAddMenu.append("exec : function( editor ) {");
        scriptAddMenu.append("\t\t\tvar linkTag = editor.getSelection().getStartElement().getAscendant('a', true);");
        scriptAddMenu.append("          if (linkTag != null && linkTag.is('a')){ openLinks(linkTag.getAttribute('href'));}");
        scriptAddMenu.append("    }});");
        scriptAddMenu.append("\tvar openLink = {");
        scriptAddMenu.append("   label : 'Open Link',");
        scriptAddMenu.append("   command : 'openLink'");
        scriptAddMenu.append("\t};");
        scriptAddMenu.append("\tCKEDITOR.instances.editor.contextMenu.addListener( function( element, selection ) {");
        scriptAddMenu.append("\t   var linkTag = element.getAscendant('a', true);");
        scriptAddMenu.append("\t   if (linkTag != null && linkTag.is('a')){return { ");
        scriptAddMenu.append("     \topenLink : CKEDITOR.TRISTATE_ON ");
        scriptAddMenu.append("   };}");
        scriptAddMenu.append("\t});");
        scriptAddMenu.append("\tCKEDITOR.instances.editor.addMenuItems({");
        scriptAddMenu.append("  openLink : {");
        scriptAddMenu.append(" label : 'Open Link',");
        scriptAddMenu.append("      command : 'openLink',");
        scriptAddMenu.append("\t      group : 'link',");
        scriptAddMenu.append("\t      order : 1");
        scriptAddMenu.append("\t   }});");
        scriptAddMenu.append("});");
        if (!widget.executeScript(scriptAddMenu.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install the open link command"));
        }
    }

    protected void createSaveListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "saveContent"){

            public Object function(Object[] arguments) {
                if ("linux".equals(Platform.getOS()) && !Boolean.getBoolean("org.polarsys.kitalpha.richtext.webkit.gtk.compatibility.workaround.disable")) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            widget.saveContent();
                        }
                    });
                } else {
                    widget.saveContent();
                }
                return null;
            }
        };
    }

    protected void installFocusOutListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('blur', function () {");
        script.append("saveContent();");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install the save handler"));
        }
    }

    protected void createChangeNotificationHandlerListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "changeHandler"){

            public Object function(Object[] arguments) {
                if (arguments != null && arguments.length > 0) {
                    PropertyChangeEvent event = new PropertyChangeEvent(widget, "widgetContent", null, arguments[0]);
                    widget.firePropertyChangeEvent(event);
                }
                return null;
            }
        };
    }

    protected void installChangeNotificationHandlerListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('blur', function () {");
        script.append("changeHandler(CKEDITOR.instances.editor.getData());");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install the notification handler"));
        }
    }

    protected void createChangeContentListener(final MDENebulaBasedRichTextWidget widget) {
        final boolean[] widgetSaveTriggeredByContentChangeDetection = new boolean[1];
        widget.addPropertyChangeListener(evt -> {
            if (evt.getSource() == widget && "widgetSaved".equals(evt.getPropertyName())) {
                widget.setDirtyStateUpdated(widgetSaveTriggeredByContentChangeDetection[0]);
            }
        });
        new BrowserFunction(widget.getBrowser(), "onChangeEvent"){

            public Object function(Object[] arguments) {
                if ("linux".equals(Platform.getOS()) && !Boolean.getBoolean("org.polarsys.kitalpha.richtext.webkit.gtk.compatibility.workaround.disable")) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            this.onChangeEvent(widget);
                        }
                    });
                } else {
                    this.onChangeEvent(widget);
                }
                return null;
            }

            private void onChangeEvent(MDENebulaBasedRichTextWidget widget2) {
                if (!widget2.isDirtyStateUpdated()) {
                    widgetSaveTriggeredByContentChangeDetection[0] = true;
                    widget2.saveContent();
                    widgetSaveTriggeredByContentChangeDetection[0] = false;
                }
            }
        };
    }

    protected void installChangeContentListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('change', function () {");
        script.append("onChangeEvent();");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install onChangeEvent handler"));
        }
    }

    protected void createFocusEventListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "resetDirtyState"){

            public Object function(Object[] arguments) {
                widget.setDirtyStateUpdated(false);
                return null;
            }
        };
    }

    protected void installFocusInListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('focus', function () {");
        script.append("resetDirtyState();");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install resetDirtyState handler"));
        }
    }

    protected void createDataReadyEventListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "notifyDataReady"){

            public Object function(Object[] arguments) {
                widget.setIsLoading(false);
                return null;
            }
        };
    }

    protected void installDataReadyEventListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('dataReady', function () {");
        script.append("notifyDataReady();");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install dataReady handler"));
        }
    }

    protected void createSetDataEventListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "notifySetData"){

            public Object function(Object[] arguments) {
                widget.setIsLoading(true);
                return null;
            }
        };
    }

    protected void installSetDataEventListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('setData', function () {");
        script.append("notifySetData();");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install setData handler"));
        }
    }

    protected void createWorkspaceResourceSaveListener(MDERichTextWidget widget) {
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.richtext.widget.saveResourceCallback");
        if (contributions != null && contributions.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                try {
                    MDERichTextEditorCallback callback = (MDERichTextEditorCallback)c.createExecutableExtension("class");
                    callback.registerWorkspaceResourceSaveListener(widget);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                ++n2;
            }
        }
    }

    class OneTagChecker
    extends DefaultHandler {
        private boolean onlyOneTag = true;
        private boolean inRoot = false;
        private static final String ROOT_ELEMENT = "clipboard";
        private String expectedTag;

        public OneTagChecker(String tag) {
            this.expectedTag = tag;
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.onlyOneTag = true;
            this.inRoot = false;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (this.inRoot) {
                if (!qName.equals(this.expectedTag)) {
                    this.onlyOneTag = false;
                }
            } else if (qName.equals(ROOT_ELEMENT)) {
                this.inRoot = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals(ROOT_ELEMENT)) {
                this.inRoot = false;
            }
            super.endElement(uri, localName, qName);
        }

        public boolean containOnlyOneTag() {
            return this.onlyOneTag;
        }
    }
}

