/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class OneIfRatherThanDuplicateBlocksThatFallThroughFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        OneIfRatherThanDuplicateBlocksThatFallThroughFinder finder = new OneIfRatherThanDuplicateBlocksThatFallThroughFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new OneIfRatherThanDuplicateBlocksThatFallThroughFixCore(FixMessages.OneIfRatherThanDuplicateBlocksThatFallThroughFix_description, compilationUnit, ops);
    }

    protected OneIfRatherThanDuplicateBlocksThatFallThroughFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class OneIfRatherThanDuplicateBlocksThatFallThroughFinder
    extends ASTVisitor {
        private List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;

        public OneIfRatherThanDuplicateBlocksThatFallThroughFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(Block visited) {
            SuccessiveIfVisitor successiveIfVisitor = new SuccessiveIfVisitor(visited);
            visited.accept((ASTVisitor)successiveIfVisitor);
            return successiveIfVisitor.result;
        }

        private final class SuccessiveIfVisitor
        extends ASTVisitor {
            private final Block startNode;
            private boolean result = true;

            public SuccessiveIfVisitor(Block startNode) {
                this.startNode = startNode;
            }

            public boolean visit(Block node) {
                return this.startNode == node;
            }

            public boolean visit(IfStatement visited) {
                if (this.result && ASTNodes.fallsThrough(visited.getThenStatement())) {
                    ArrayList<IfStatement> duplicateIfBlocks = new ArrayList<IfStatement>(4);
                    AtomicInteger operandCount = new AtomicInteger(ASTNodes.getNbOperands(visited.getExpression()));
                    duplicateIfBlocks.add(visited);
                    while (this.addOneMoreIf(duplicateIfBlocks, operandCount)) {
                    }
                    if (duplicateIfBlocks.size() > 1) {
                        OneIfRatherThanDuplicateBlocksThatFallThroughFinder.this.fResult.add(new OneIfRatherThanDuplicateBlocksThatFallThroughOperation(duplicateIfBlocks));
                        this.result = false;
                        return false;
                    }
                }
                return true;
            }

            private boolean addOneMoreIf(List<IfStatement> duplicateIfBlocks, AtomicInteger operandCount) {
                IfStatement nextSibling;
                IfStatement lastBlock = duplicateIfBlocks.get(duplicateIfBlocks.size() - 1);
                if (lastBlock.getElseStatement() == null && (nextSibling = ASTNodes.as(ASTNodes.getNextSibling((Statement)lastBlock), IfStatement.class)) != null && nextSibling.getElseStatement() == null && operandCount.get() + ASTNodes.getNbOperands(nextSibling.getExpression()) < 5 && ASTNodes.match((ASTNode)lastBlock.getThenStatement(), (ASTNode)nextSibling.getThenStatement())) {
                    operandCount.addAndGet(ASTNodes.getNbOperands(nextSibling.getExpression()));
                    duplicateIfBlocks.add(nextSibling);
                    return true;
                }
                return false;
            }
        }
    }

    private static class OneIfRatherThanDuplicateBlocksThatFallThroughOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final List<IfStatement> duplicateIfBlocks;

        public OneIfRatherThanDuplicateBlocksThatFallThroughOperation(List<IfStatement> duplicateIfBlocks) {
            this.duplicateIfBlocks = duplicateIfBlocks;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.OneIfRatherThanDuplicateBlocksThatFallThroughCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            ArrayList<Expression> newConditions = new ArrayList<Expression>(this.duplicateIfBlocks.size());
            for (IfStatement ifStatement : this.duplicateIfBlocks) {
                InfixExpression oneOriginalCondition = ASTNodes.as(ifStatement.getExpression(), InfixExpression.class);
                if (ASTNodes.hasOperator(oneOriginalCondition, InfixExpression.Operator.CONDITIONAL_OR, new InfixExpression.Operator[0])) {
                    newConditions.add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(ifStatement.getExpression())));
                    continue;
                }
                newConditions.add(ASTNodeFactory.parenthesizeIfNeeded(ast, ASTNodes.createMoveTarget(rewrite, ifStatement.getExpression())));
            }
            InfixExpression newCondition = ast.newInfixExpression();
            newCondition.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
            newCondition.setLeftOperand((Expression)newConditions.remove(0));
            newCondition.setRightOperand((Expression)newConditions.remove(0));
            newCondition.extendedOperands().addAll(newConditions);
            int i = 0;
            while (i < this.duplicateIfBlocks.size() - 1) {
                ASTNodes.removeButKeepComment(rewrite, (ASTNode)this.duplicateIfBlocks.get(i), group);
                ++i;
            }
            rewrite.replace((ASTNode)this.duplicateIfBlocks.get(this.duplicateIfBlocks.size() - 1).getExpression(), (ASTNode)newCondition, group);
        }
    }
}

