/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ui.actions.ModelAdaptation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class LayerPropertyTester
extends PropertyTester {
    public boolean test(Object object_p, String propertyName_p, Object[] params_p, Object testedValue_p) {
        ModelElement element;
        boolean result = false;
        if ((propertyName_p.equals("layerOf") || propertyName_p.equals("graphicalLayerOf") || propertyName_p.equals("layerOfWithOutDataFlowScenario") || propertyName_p.equals("graphicalLayerOfWithOutDataFlowScenario")) && (element = ModelAdaptation.adaptToCapella((Object)object_p)) != null && element instanceof CapellaElement) {
            String layerName = (String)testedValue_p;
            if (layerName.equalsIgnoreCase("OperationalAnalysis")) {
                result = CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element)) || element instanceof OperationalAnalysis;
            } else if (layerName.equalsIgnoreCase("SystemAnalysis")) {
                result = CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)element)) || element instanceof SystemAnalysis;
            } else if (layerName.equalsIgnoreCase("LogicalArchitecture")) {
                result = CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)element)) || element instanceof LogicalArchitecture;
            } else if (layerName.equalsIgnoreCase("PhysicalArchitecture")) {
                result = CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)element)) || element instanceof PhysicalArchitecture;
            } else if (layerName.equalsIgnoreCase("EPBSArchitecture")) {
                boolean bl = result = CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)((CapellaElement)element)) || element instanceof EPBSArchitecture;
            }
            if (result && (propertyName_p.equals("layerOfWithOutDataFlowScenario") || propertyName_p.equals("graphicalLayerOfWithOutDataFlowScenario"))) {
                result = false;
                if (element instanceof Scenario) {
                    result = this.isInterfaceScenario((Scenario)element);
                } else if (element instanceof AbstractCapability) {
                    result = this.containsInterfaceScenario((AbstractCapability)element);
                } else if (element instanceof CapabilityPkg) {
                    result = this.containsInterfaceScenario((CapabilityPkg)element);
                } else if (element instanceof CapabilityRealizationPkg) {
                    result = this.containsInterfaceScenario((CapabilityRealizationPkg)element);
                }
            }
        }
        return result;
    }

    private boolean isInterfaceScenario(Scenario scenario_p) {
        return scenario_p.getKind().equals((Object)ScenarioKind.INTERFACE);
    }

    private boolean containsInterfaceScenario(AbstractCapability abstractCapability_p) {
        for (Scenario scenario : abstractCapability_p.getOwnedScenarios()) {
            if (!this.isInterfaceScenario(scenario)) continue;
            return true;
        }
        return false;
    }

    private boolean containsInterfaceScenario(CapabilityPkg capabilityPkg_p) {
        for (Capability capability : capabilityPkg_p.getOwnedCapabilities()) {
            if (!this.containsInterfaceScenario((AbstractCapability)capability)) continue;
            return true;
        }
        for (CapabilityPkg capabilityPkg : capabilityPkg_p.getOwnedCapabilityPkgs()) {
            if (!this.containsInterfaceScenario(capabilityPkg)) continue;
            return true;
        }
        return false;
    }

    private boolean containsInterfaceScenario(CapabilityRealizationPkg capabilityRealizationPkg_p) {
        for (CapabilityRealization capabilityRealization : capabilityRealizationPkg_p.getOwnedCapabilityRealizations()) {
            if (!this.containsInterfaceScenario((AbstractCapability)capabilityRealization)) continue;
            return true;
        }
        for (CapabilityRealizationPkg capabilityRealizationPkg : capabilityRealizationPkg_p.getOwnedCapabilityRealizationPkgs()) {
            if (!this.containsInterfaceScenario(capabilityRealizationPkg)) continue;
            return true;
        }
        return false;
    }
}

