/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;

public class DeleteCommand
extends CompoundCommand {
    private EditingDomain editingDomain;
    private Collection<?> elementsToDelete;

    public DeleteCommand(EditingDomain editingDomain, Collection<?> elementToDelete) {
        Assert.isTrue((boolean)(editingDomain instanceof TransactionalEditingDomain), (String)"The Editing Domain must be not null and must be a Transactional one");
        Assert.isNotNull(elementToDelete, (String)"The Element set to delete must be not null");
        this.editingDomain = editingDomain;
        this.elementsToDelete = elementToDelete;
    }

    protected void deletePointingReference(EObject referencingEObject, EStructuralFeature feature, EObject referenceToDelete) {
        if (feature.isMany()) {
            this.appendAndExecute(RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)referencingEObject, (Object)feature, (Object)referenceToDelete));
        } else {
            this.appendAndExecute(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)referencingEObject, (Object)feature, null));
        }
    }

    public void execute() {
        EStructuralFeature.Setting setting;
        Object settings;
        LinkedHashSet<EObject> eObjects = new LinkedHashSet<EObject>();
        for (Object wrappedObject : this.getElementsToDelete()) {
            TreeIterator j;
            Object object = AdapterFactoryEditingDomain.unwrap(wrappedObject);
            if (object instanceof EObject) {
                eObjects.add((EObject)object);
                j = ((EObject)object).eAllContents();
                while (j.hasNext()) {
                    eObjects.add((EObject)j.next());
                }
                continue;
            }
            if (!(object instanceof Resource)) continue;
            j = ((Resource)object).getAllContents();
            while (j.hasNext()) {
                eObjects.add((EObject)j.next());
            }
        }
        ECrossReferenceAdapter crossReferencer = this.getECrossReferencerAdapter();
        HashMap<EObject, Collection> usages = new HashMap<EObject, Collection>(0);
        for (EObject eObject : eObjects) {
            Collection inverseReferences = crossReferencer.getInverseReferences(eObject, true);
            settings = inverseReferences.iterator();
            while (settings.hasNext()) {
                setting = (EStructuralFeature.Setting)settings.next();
                try {
                    if (!((EReference)EReference.class.cast(setting.getEStructuralFeature())).isContainment()) continue;
                    settings.remove();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            usages.put(eObject, inverseReferences);
        }
        super.execute();
        for (Map.Entry entry : usages.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            settings = (Collection)entry.getValue();
            Iterator iterator = settings.iterator();
            while (iterator.hasNext()) {
                EStructuralFeature eStructuralFeature;
                setting = (EStructuralFeature.Setting)iterator.next();
                EObject referencingEObject = setting.getEObject();
                if (eObjects.contains(referencingEObject) || !(eStructuralFeature = setting.getEStructuralFeature()).isChangeable()) continue;
                this.deletePointingReference(referencingEObject, eStructuralFeature, eObject);
            }
        }
    }

    protected void doPrepare() {
        this.append(RemoveCommand.create((EditingDomain)this.getEditingDomain(), this.getElementsToDelete()));
    }

    protected boolean prepare() {
        this.doPrepare();
        return super.prepare();
    }

    protected ECrossReferenceAdapter getECrossReferencerAdapter() {
        for (Adapter adapter : this.editingDomain.getResourceSet().eAdapters()) {
            if (!(adapter instanceof SiriusCrossReferenceAdapter)) continue;
            return (ECrossReferenceAdapter)adapter;
        }
        return null;
    }

    protected EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected Collection<?> getElementsToDelete() {
        return this.elementsToDelete;
    }
}

