/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IConverter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.TypedValidation;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;

public class CapellaInterpreter
implements IInterpreterProvider,
IInterpreter,
TypedValidation {
    public static final String PREFIX = "capella:";

    public boolean provides(String expression) {
        return expression != null && expression.startsWith(this.getPrefix());
    }

    public IInterpreter createInterpreter() {
        return this;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public String getVariablePrefix() {
        return "";
    }

    public boolean supportsValidation() {
        return true;
    }

    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        return this.analyzeExpression(context, expression).getStatuses();
    }

    public Object evaluate(EObject target, String expression) throws EvaluationException {
        List result = null;
        EObject resolvedTarget = CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)target);
        if (resolvedTarget != null && expression != null && expression.startsWith(PREFIX)) {
            String command = expression.substring(PREFIX.length(), expression.length()).trim();
            Set categories = CategoryRegistry.getInstance().gatherCategories(resolvedTarget).stream().filter(category -> CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, category.getName().trim().replaceAll(" ", "_")).equals(command)).collect(Collectors.toSet());
            if (!categories.isEmpty()) {
                ICategory category2 = (ICategory)categories.iterator().next();
                if (category2 != null) {
                    result = category2.compute((Object)resolvedTarget);
                }
            } else {
                throw new EvaluationException();
            }
        }
        return result;
    }

    public IConverter getConverter() {
        return null;
    }

    public void setVariable(String name, Object value) {
    }

    public void unSetVariable(String name) {
    }

    public Object getVariable(String name) {
        return null;
    }

    public Map<String, ?> getVariables() {
        return null;
    }

    public void clearVariables() {
    }

    public void addImport(String dependency) {
    }

    public Collection<String> getImports() {
        return null;
    }

    public void removeImport(String dependency) {
    }

    public void clearImports() {
    }

    public void setProperty(Object key, Object value) {
    }

    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
    }

    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
    }

    public void dispose() {
    }

    public ValidationResult analyzeExpression(IInterpreterContext context, String expression) {
        return null;
    }
}

