/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.Collection;
import org.polarsys.capella.core.data.capellacore.CapellaElement;

public interface CollectorVisitor<I, O> {
    public static final CollectorVisitor<? extends CapellaElement, ? extends CapellaElement> DEFAULT_VISITOR = new CollectorVisitor<CapellaElement, CapellaElement>(){

        @Override
        public void visit(CapellaElement input, Collection<CapellaElement> output) {
            output.add(input);
        }
    };

    public void visit(I var1, Collection<O> var2);

    public static class BasicCollectorVisitor
    implements CollectorVisitor<Object, Object> {
        private Class<? extends Object> filterType;

        private BasicCollectorVisitor(Class<? extends Object> filterType) {
            this.filterType = filterType;
        }

        public static <I, O> CollectorVisitor<I, O> getVisitor(Class<?> filterType) {
            return new BasicCollectorVisitor(filterType);
        }

        @Override
        public void visit(Object input, Collection<Object> output) {
            if (this.filterType.isInstance(input)) {
                output.add(input);
            }
        }
    }
}

