/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.policies;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenDiagramEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.ui.tools.internal.editor.NavigateToCommand;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ui.toolkit.dialogs.OpenRepresentationDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectNewRepresentationDialog;
import org.polarsys.capella.core.commands.preferences.ui.sirius.DoubleClickBehaviourUtil;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.analysis.Messages;

public class OpenRelatedDiagramEditPolicy
extends OpenDiagramEditPolicy {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected org.eclipse.gef.commands.Command getOpenCommand(Request request) {
        EObject element;
        IGraphicalEditPart editPart;
        View view;
        EditPart targetEditPart;
        if (!"open".equals(request.getType()) || !((targetEditPart = this.getTargetEditPart(request)) instanceof IGraphicalEditPart) || (view = (editPart = (IGraphicalEditPart)targetEditPart).getNotationView()) == null || !((element = ViewUtil.resolveSemanticElement((View)view)) instanceof DDiagramElement)) return null;
        DDiagramElement container = (DDiagramElement)element;
        EObject targetSemanticElement = container.getTarget();
        if (container.getParentDiagram().isIsInShowingMode() || targetSemanticElement == null || !DoubleClickBehaviourUtil.INSTANCE.shouldOpenRelatedDiagramsOnDoubleClick(targetSemanticElement)) {
            return null;
        }
        targetSemanticElement = DoubleClickBehaviourUtil.INSTANCE.getTargetSemanticElement(targetSemanticElement);
        final Session session = SessionManager.INSTANCE.getSession(element);
        Collection representations = RepresentationHelper.getAllRepresentationDescriptorsTargetedBy(Collections.singleton(targetSemanticElement));
        if (!representations.isEmpty()) {
            if (representations.size() > 1) {
                Shell activeShell = Display.getDefault().getActiveShell();
                OpenRepresentationDialog dialog = new OpenRepresentationDialog(activeShell, representations);
                dialog.open();
                if (dialog.getReturnCode() != 0) return null;
                return new ICommandProxy((ICommand)new GMFCommandWrapper(session.getTransactionalEditingDomain(), (Command)new NavigateToCommand(session, dialog.getSelectedDescriptor().getRepresentation())));
            }
            DRepresentationDescriptor element1 = (DRepresentationDescriptor)representations.toArray()[0];
            return new ICommandProxy((ICommand)new GMFCommandWrapper(session.getTransactionalEditingDomain(), (Command)new NavigateToCommand(session, element1.getRepresentation())));
        }
        Session currentSession = SessionManager.INSTANCE.getSession(targetSemanticElement);
        Collection selectedViewpoints = currentSession.getSelectedViewpoints(false);
        Collection descriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(selectedViewpoints, targetSemanticElement);
        if (descriptions.isEmpty()) return null;
        if (descriptions.size() > 1) {
            Shell activeShell = Display.getDefault().getActiveShell();
            SelectNewRepresentationDialog dialog = new SelectNewRepresentationDialog(activeShell, Messages.OpenRelatedDiagram_Message, targetSemanticElement, descriptions);
            dialog.open();
            if (dialog.getReturnCode() != 0) return null;
            CreateRepresentationCommand createRepresentationCommand = new CreateRepresentationCommand(session, dialog.getSelectedRepresentationDescription(), targetSemanticElement, dialog.getName(), (IProgressMonitor)new NullProgressMonitor()){

                protected void doExecute() {
                    super.doExecute();
                    NavigateToCommand navCommand = new NavigateToCommand(session, this.getCreatedRepresentation());
                    navCommand.execute();
                }
            };
            return new ICommandProxy((ICommand)new GMFCommandWrapper(session.getTransactionalEditingDomain(), (Command)createRepresentationCommand));
        }
        Shell activeShell = Display.getDefault().getActiveShell();
        RepresentationDescription description = (RepresentationDescription)descriptions.iterator().next();
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)targetSemanticElement);
        String titleExpression = description.getTitleExpression();
        String newName = "";
        try {
            newName = interpreter.evaluateString(targetSemanticElement, titleExpression);
        }
        catch (EvaluationException e) {
            e.printStackTrace();
        }
        IInputValidator validator = newText -> {
            if (newText.isBlank()) {
                return org.polarsys.capella.common.ui.toolkit.dialogs.Messages.blankName;
            }
            return null;
        };
        InputDialog dialog = new InputDialog(activeShell, "New " + MessageTranslator.INSTANCE.getMessage((EObject)description, new IdentifiedElementQuery((IdentifiedElement)description).getLabel()), Messages.OpenRelatedDiagram_Message + "\nName:", newName, validator);
        dialog.open();
        if (dialog.getReturnCode() != 0) return null;
        CreateRepresentationCommand createRepresentationCommand = new CreateRepresentationCommand(session, description, targetSemanticElement, dialog.getValue(), (IProgressMonitor)new NullProgressMonitor()){

            protected void doExecute() {
                super.doExecute();
                NavigateToCommand navCommand = new NavigateToCommand(session, this.getCreatedRepresentation());
                navCommand.execute();
            }
        };
        return new ICommandProxy((ICommand)new GMFCommandWrapper(session.getTransactionalEditingDomain(), (Command)createRepresentationCommand));
    }
}

