/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.datavalue.properties.controllers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.AbstractBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractStringValue;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.ui.properties.controllers.AbstractSimpleEditableSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.EditableSemanticFieldException;

public class EnumerationLiteralController
extends AbstractSimpleEditableSemanticFieldController {
    public EObject writeOpenValue(EObject semanticElement, EStructuralFeature semanticFeature, String defaultName, EObject value) {
        NumericReference ref = null;
        if (value instanceof Property) {
            ref = DatavalueFactory.eINSTANCE.createNumericReference(defaultName);
            ref.eSet((EStructuralFeature)DatavaluePackage.eINSTANCE.getNumericReference_ReferencedProperty(), (Object)value);
        } else if (value instanceof NumericValue) {
            ref = DatavalueFactory.eINSTANCE.createNumericReference(defaultName);
            ref.eSet((EStructuralFeature)DatavaluePackage.eINSTANCE.getNumericReference_ReferencedValue(), (Object)value);
        } else if (value instanceof AbstractBooleanValue) {
            ref = DatavalueFactory.eINSTANCE.createBooleanReference(defaultName);
            ref.eSet((EStructuralFeature)DatavaluePackage.eINSTANCE.getBooleanReference_ReferencedValue(), (Object)value);
        } else if (value instanceof AbstractStringValue) {
            ref = DatavalueFactory.eINSTANCE.createStringReference(defaultName);
            ref.eSet((EStructuralFeature)DatavaluePackage.eINSTANCE.getStringReference_ReferencedValue(), (Object)value);
        } else if (value instanceof EnumerationLiteral) {
            ref = DatavalueFactory.eINSTANCE.createEnumerationReference(defaultName);
            ref.eSet((EStructuralFeature)DatavaluePackage.eINSTANCE.getEnumerationReference_ReferencedValue(), (Object)value);
        }
        if (ref != null && semanticElement instanceof AbstractType && (value instanceof NumericValue || value instanceof AbstractBooleanValue || value instanceof AbstractStringValue)) {
            ref.eSet((EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractTypedElement_AbstractType(), (Object)semanticElement);
        }
        if (ref != null) {
            semanticElement.eSet(semanticFeature, (Object)ref);
            return ref;
        }
        return value;
    }

    public EObject editValue(EObject semanticElement, EStructuralFeature semanticFeature, String defaultName) {
        if (semanticElement != null) {
            DataValue currentValue = (DataValue)semanticElement.eGet(semanticFeature);
            if (currentValue != null) {
                this.editValueWizard((EObject)currentValue);
            } else {
                EObject owner = semanticElement.eContainer();
                if (owner instanceof Enumeration) {
                    Object newValue = null;
                    DataType domainType = ((Enumeration)owner).getDomainType();
                    newValue = domainType instanceof BooleanType ? DatavalueFactory.eINSTANCE.createLiteralBooleanValue(defaultName) : (domainType instanceof StringType ? DatavalueFactory.eINSTANCE.createLiteralStringValue(defaultName) : (domainType instanceof Enumeration ? DatavalueFactory.eINSTANCE.createEnumerationLiteral(defaultName) : DatavalueFactory.eINSTANCE.createLiteralNumericValue(defaultName)));
                    if (newValue != null) {
                        semanticElement.eSet(semanticFeature, newValue);
                        if (this.editValueWizard((EObject)newValue)) {
                            currentValue = newValue;
                        } else {
                            throw new EditableSemanticFieldException();
                        }
                    }
                }
            }
            return currentValue;
        }
        return null;
    }
}

