/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.controlNode;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.fa.ControlNode;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.model.helpers.SequenceLinkEndExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ControlNodeInconsistentOperations
extends AbstractValidationRule {
    public static final String ControlNode_Inconsistency_No_InOut_Sequence_Links = "has no incoming and outgoing Sequence Links";
    public static final String ControlNode_Inconsistency_No_In_Sequence_Links = "has no incoming Sequence Links";
    public static final String ControlNode_Inconsistency_No_Out_Sequence_Links = "has no outgoing Sequence Links";
    public static final String ControlNode_Inconsistency_Minimum_InOut_Sequence_Links = "has only one incoming and one outgoing Sequence Link";

    public IStatus validate(IValidationContext ctx) {
        if (ctx.getEventType() == EMFEventType.NULL && ctx.getTarget() instanceof ControlNode) {
            String className = "ControlNode";
            ControlNode controlNode = (ControlNode)ctx.getTarget();
            List inLinks = SequenceLinkEndExt.getIncomingSequenceLinks((SequenceLinkEnd)controlNode);
            List outLinks = SequenceLinkEndExt.getOutgoingSequenceLinks((SequenceLinkEnd)controlNode);
            int inCount = inLinks.size();
            int outCount = outLinks.size();
            if (inCount == 0 && outCount == 0) {
                return ctx.createFailureStatus(new Object[]{className, ControlNode_Inconsistency_No_InOut_Sequence_Links});
            }
            if (inCount == 0) {
                return ctx.createFailureStatus(new Object[]{className, ControlNode_Inconsistency_No_In_Sequence_Links});
            }
            if (outCount == 0) {
                return ctx.createFailureStatus(new Object[]{className, ControlNode_Inconsistency_No_Out_Sequence_Links});
            }
            if (inCount == 1 && outCount == 1) {
                return ctx.createFailureStatus(new Object[]{className, ControlNode_Inconsistency_Minimum_InOut_Sequence_Links});
            }
        }
        return ctx.createSuccessStatus();
    }
}

